/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.internal.console.ConCommandKeys;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUninstall;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUninstallPackageSelector;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewProperties;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPageUninstallPkgs
extends AConPage {
    ConDataCtxtUninstallPackageSelector m_context;
    Profile m_selectedProfile;
    ConViewTreeList mainList;
    ConViewStatus m_statusView = new ConViewStatus();

    public ConPageUninstallPkgs(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.m_context = (ConDataCtxtUninstallPackageSelector)this.conManager().getDataContext(ConDataCtxtUninstallPackageSelector.class);
        this.setHeaderView(Messages.PageUninstall_Pkg_Header);
        this.m_context.loadInstalledPackageFixInformation();
        ConViewProperties groupName = new ConViewProperties(){

            public void present(OutputFormatter a_output) {
                this.clear();
                this.addProperty(Messages.PageUpdate_Pkg_PgGroup, ConPageUninstallPkgs.this.m_selectedProfile.getProfileId());
                super.present(a_output);
            }
        };
        groupName.setFormatString("%s:  %s");
        this.addView((IConView)groupName);
        this.mainList = new ConViewTreeList(Messages.PageUninstall_Pkg_InstalledPkg, 1, true, true){

            protected ConViewTreeListEntry generateEntry(Object element, String label, AConActionEntry action) {
                return new UninstallTreeListEntry(element, label, action);
            }
        };
        this.mainList.setContentProvider((IConViewContentProvider)new UninstallContentProvider());
        this.addView((IConView)this.mainList);
        this.addView((IConView)this.m_statusView);
        ConViewList otherOptions = new ConViewList(Messages.General_OtherOptions, true){

            public void present(OutputFormatter a_output) {
                this.clearList();
                if (!ConPageUninstallPkgs.this.mainList.areNoneSet()) {
                    this.addEntry(Messages.PageUninstall_Pkg_UnselectAll, "U", new ConActUninstallPkgsSelectNone());
                }
                if (!ConPageUninstallPkgs.this.mainList.areAllSet()) {
                    this.addEntry(Messages.PageUninstall_Pkg_SelectAll, ConCommandKeys.keys_All, new ConActUninstallPkgsSelectAll());
                }
                super.present(a_output);
            }
        };
        this.addView((IConView)otherOptions);
        super.init();
    }

    public boolean isPageComplete() {
        if (this.m_context.getSelectedJobs().containsJobs()) {
            IStatus status = this.m_statusView.getStatus();
            return status == null || status.isOK();
        }
        return false;
    }

    public void setVisible(boolean a_visible) {
        ConDataCtxtUninstall ctxt;
        Profile newlySelectedProfile;
        if (a_visible && this.m_selectedProfile != (newlySelectedProfile = (ctxt = (ConDataCtxtUninstall)this.conManager().getDataContext(ConDataCtxtUninstall.class)).getSelectedProfiles().getSingleSelectedProfile())) {
            this.m_selectedProfile = newlySelectedProfile;
            this.m_context.getSelectedJobs().clear();
            this.mainList.refresh();
            this.m_statusView.setStatus(Status.OK_STATUS);
        }
        super.setVisible(a_visible);
    }

    protected boolean hasNext() {
        return this.isPageComplete();
    }

    class ConActUninstallPkgsSelect
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActUninstallPkgsSelect() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            UninstallJob job = (UninstallJob)entry.getElement();
            boolean previousSelected = ConPageUninstallPkgs.this.m_context.getSelectedJobs().contains(job);
            ConPageUninstallPkgs.this.m_context.flipUninstallJobSelection(job);
            if (!previousSelected) {
                ConViewTreeListEntry[] children = entry.getChildren();
                if (children != null && children.length > 0) {
                    ConViewTreeListEntry[] conViewTreeListEntryArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ConViewTreeListEntry element = conViewTreeListEntryArray[n2];
                        UninstallJob childJob = (UninstallJob)element.getElement();
                        if (!ConPageUninstallPkgs.this.m_context.getSelectedJobs().contains(childJob)) {
                            ConPageUninstallPkgs.this.m_context.flipUninstallJobSelection(childJob);
                        }
                        ++n2;
                    }
                }
            } else {
                ConViewTreeListEntry[] children = entry.getChildren();
                if (children != null && children.length > 0) {
                    ConViewTreeListEntry[] conViewTreeListEntryArray = children;
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ConViewTreeListEntry element = conViewTreeListEntryArray[n3];
                        UninstallJob childJob = (UninstallJob)element.getElement();
                        if (ConPageUninstallPkgs.this.m_context.getSelectedJobs().contains(childJob)) {
                            ConPageUninstallPkgs.this.m_context.flipUninstallJobSelection(childJob);
                            this.unselectOfferingNode(childJob);
                        }
                        ++n3;
                    }
                } else {
                    ConViewTreeListEntry parentNode = entry.getParent();
                    if (parentNode != null) {
                        UninstallJob parentJob = (UninstallJob)parentNode.getElement();
                        if (ConPageUninstallPkgs.this.m_context.getSelectedJobs().contains(parentJob)) {
                            ConPageUninstallPkgs.this.m_context.flipUninstallJobSelection(parentJob);
                        }
                        this.unselectOfferingNode(job);
                    }
                }
            }
            ConPageUninstallPkgs.this.m_statusView.setStatus(ConUtils.checkOfferingSupportConsoleMode(ConPageUninstallPkgs.this.m_context.getSelectedJobs().getSelectedOfferingJobs()));
            ConPageUninstallPkgs.this.m_context.prepareJobs();
            super.run(a_conManager);
        }

        private void unselectOfferingNode(UninstallJob unstallFixJob) {
            UninstallJob[] uninstallOfferingJobs;
            UninstallJob[] uninstallJobArray = uninstallOfferingJobs = ConPageUninstallPkgs.this.m_context.getAvailableUninstallOfferingJobs(ConPageUninstallPkgs.this.m_selectedProfile);
            int n = uninstallOfferingJobs.length;
            int n2 = 0;
            while (n2 < n) {
                UninstallJob uninstallOfferingJob = uninstallJobArray[n2];
                UninstallJob[] jobs = ConPageUninstallPkgs.this.m_context.getAvailableUninstallFixJobs(ConPageUninstallPkgs.this.m_selectedProfile, uninstallOfferingJob);
                if (jobs != null && jobs.length > 0 && Arrays.asList(jobs).contains(unstallFixJob) && ConPageUninstallPkgs.this.m_context.getSelectedJobs().contains(uninstallOfferingJob)) {
                    ConPageUninstallPkgs.this.m_context.flipUninstallJobSelection(uninstallOfferingJob);
                }
                ++n2;
            }
        }
    }

    class ConActUninstallPkgsSelectAll
    extends AConActionEntry<ConViewListEntry> {
        ConActUninstallPkgsSelectAll() {
        }

        public void run(IConManager a_conManager) {
            ConPageUninstallPkgs.this.m_context.selectAllJobs(ConPageUninstallPkgs.this.m_selectedProfile);
            ConPageUninstallPkgs.this.m_statusView.setStatus(ConUtils.checkOfferingSupportConsoleMode(ConPageUninstallPkgs.this.m_context.getSelectedJobs().getSelectedOfferingJobs()));
            ConPageUninstallPkgs.this.m_context.prepareJobs();
            super.run(a_conManager);
        }
    }

    class ConActUninstallPkgsSelectNone
    extends AConActionEntry<ConViewListEntry> {
        ConActUninstallPkgsSelectNone() {
        }

        public void run(IConManager a_conManager) {
            ConPageUninstallPkgs.this.m_context.getSelectedJobs().removeAllJobs();
            ConPageUninstallPkgs.this.m_statusView.setStatus(Status.OK_STATUS);
            super.run(a_conManager);
        }
    }

    class UninstallContentProvider
    extends AConViewContentProvider {
        UninstallContentProvider() {
        }

        public String getLabel(Object element) {
            if (element instanceof UninstallJob) {
                return UninstallContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((UninstallJob)element).getOfferingOrFix());
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            UninstallJob job;
            IOffering offering;
            if (parentElement instanceof UninstallJob && (offering = (job = (UninstallJob)parentElement).getOffering()) != null) {
                return ConPageUninstallPkgs.this.m_context.getAvailableUninstallFixJobs(ConPageUninstallPkgs.this.m_selectedProfile, job);
            }
            return null;
        }

        public Object[] getElements() {
            return ConPageUninstallPkgs.this.m_context.getAvailableUninstallOfferingJobs(ConPageUninstallPkgs.this.m_selectedProfile);
        }

        public void updateEntry(ConViewTreeListEntry entry) {
            Object element = entry.getElement();
            if (element instanceof UninstallJob) {
                UninstallJob job = (UninstallJob)element;
                if (ConPageUninstallPkgs.this.m_context.getSelectedJobs().contains(job)) {
                    entry.setSelected(true);
                } else {
                    entry.setSelected(false);
                }
            }
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof UninstallJob) {
                return new ConActUninstallPkgsSelect();
            }
            return super.getAction(element);
        }
    }

    static class UninstallTreeListEntry
    extends ConViewTreeListEntry {
        public UninstallTreeListEntry(Object elem, String a_name, AConActionEntry a_action) {
            super(elem, a_name, a_action);
        }

        public void setSelected(boolean a_selected) {
            if (this.m_selected != a_selected && this.m_parent != null) {
                this.m_parent.setCollapsed(false);
            }
            this.m_selected = a_selected;
        }
    }
}

