/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtModify;
import com.ibm.cic.agent.internal.console.pages.AConPageElementDetails;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.OutputFormatter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPageModify
extends AConPageElementDetails {
    ConDataCtxtModify context;
    private final ConViewStatus m_statusView = new ConViewStatus();

    public ConPageModify(IConManager conManager) {
        super(conManager);
    }

    public void init() {
        this.setHeaderView(Messages.PageModify_Header);
        this.context = (ConDataCtxtModify)this.conManager().getDataContext(ConDataCtxtModify.class);
        super.init();
    }

    public void present(OutputFormatter outputFmt) {
        this.clear();
        Profile[] profiles = this.context.getAllProductProfiles();
        if (profiles.length > 0) {
            ConViewListNumbered mainList = new ConViewListNumbered(Messages.PageModify_SelectPG, true, 1);
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                mainList.addEntry(profile.getProfileId(), (AConActionEntry)new ConActionFlipSelectProfile(), this.context.isProfileSelected(profile)).setContext((Object)profile);
                ++n2;
            }
            this.addView((IConView)mainList);
            this.addElementDescription(this.context.getSelectedProfile());
            this.addView((IConView)this.m_statusView);
        } else {
            this.addView((IConView)new ConViewText(Messages.PageModify_NoPkgToModify, true));
        }
        super.present(outputFmt);
    }

    public boolean isPageComplete() {
        if (this.context.isAnyProfileSelected()) {
            IStatus status = this.m_statusView.getStatus();
            return status == null || status.isOK();
        }
        return false;
    }

    public IStatus canFlipToNext() {
        this.m_statusView.setStatus(this.context.performNext());
        return this.m_statusView.getStatus();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Profile selectedProfile = this.context.getSelectedProfile();
            if (selectedProfile == null) {
                this.m_statusView.setStatus(Status.OK_STATUS);
            } else {
                IStatus consoleModeStatus = ConUtils.containPkgNotSupportConsoleMode(selectedProfile);
                this.m_statusView.setStatus(consoleModeStatus);
            }
        }
    }

    class ConActionFlipSelectProfile
    extends AConActionEntry<ConViewListEntry> {
        ConActionFlipSelectProfile() {
        }

        public void run(IConManager a_conManager) {
            Profile profile = (Profile)((ConViewListEntry)this.getEntry()).getContext();
            ConPageModify.this.context.flipProfileSelection(profile);
            Profile selectedProfile = ConPageModify.this.context.getSelectedProfile();
            if (selectedProfile == null) {
                ConPageModify.this.m_statusView.setStatus(Status.OK_STATUS);
            } else {
                IStatus consoleModeStatus = ConUtils.containPkgNotSupportConsoleMode(selectedProfile);
                ConPageModify.this.m_statusView.setStatus(consoleModeStatus);
            }
            super.run(a_conManager);
        }
    }
}

