/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInst;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInstLocation;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInstSharedResourceLocation;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtLocaleLangs;
import com.ibm.cic.agent.internal.console.manager.SummaryTreeContentProvider;
import com.ibm.cic.agent.internal.console.pages.ConPageBaseSummary;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewProperties;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.List;
import java.util.Set;

public class ConPageInstSummary
extends ConPageBaseSummary {
    ConDataCtxtInst m_context;

    public ConPageInstSummary(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.General_Header_Summary);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        ConDataCtxtLocaleLangs localeLangContext;
        Set<String> selectedCode;
        Profile profile;
        ConDataCtxtInstLocation installLocationContext;
        this.clear();
        ConViewProperties propsView = new ConViewProperties(Messages.General_Summary_TargetLocation, null, null);
        ConDataCtxtInstSharedResourceLocation sharedLocation = (ConDataCtxtInstSharedResourceLocation)this.conManager().getDataContext(ConDataCtxtInstSharedResourceLocation.class);
        if (sharedLocation != null && sharedLocation.hasInstallIMJob()) {
            propsView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.General_Summary_PackageGroupName, sharedLocation.getIMProfile().getProfileId());
            propsView.addProperty(Messages.General_Summary_InstallationDirectory, sharedLocation.getIMProfile().getInstallLocation());
        }
        if (!AgentUtil.onlyInstallAgent(this.m_context.getSelectedJobs().toList())) {
            installLocationContext = (ConDataCtxtInstLocation)this.conManager().getDataContext(ConDataCtxtInstLocation.class);
            if (installLocationContext != null) {
                propsView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.General_Summary_PackageGroupName, installLocationContext.getSelectedProfile().getProfileId());
                propsView.addProperty(Messages.General_Summary_InstallationDirectory, installLocationContext.getSelectedProfile().getInstallLocation());
            }
            if (sharedLocation != null) {
                propsView.addProperty(Messages.General_Summary_SharedResourceDirectory, sharedLocation.getSharedResourceLocationNoExceptions());
            }
        }
        this.addView((IConView)propsView);
        this.addView((IConView)new ConViewText(""));
        if (!AgentUtil.onlyInstallAgent(this.m_context.getSelectedJobs().toList()) && (installLocationContext = (ConDataCtxtInstLocation)this.conManager().getDataContext(ConDataCtxtInstLocation.class)) != null && (profile = installLocationContext.getSelectedProfile()) != null && profile.isShadow() && !(selectedCode = (localeLangContext = (ConDataCtxtLocaleLangs)this.conManager().getDataContext(ConDataCtxtLocaleLangs.class)).getSelectedLangs()).isEmpty()) {
            ConViewList translationView = new ConViewList(Messages.PageInstallSummary_Translation, true);
            translationView.addEntry(localeLangContext.getSelectedLangLabels());
            this.addView((IConView)translationView);
        }
        if (this.m_context.getSelectedJobs().getSelectedFixJobs().isEmpty()) {
            ConViewList packageView = new ConViewList(Messages.PageInstall_Summary_Packages, true);
            List<InstallJob> packageList = this.m_context.getSelectedJobs().toList();
            for (InstallJob job : packageList) {
                packageView.addEntry(AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)job.getOfferingOrFix()));
            }
            this.addView((IConView)packageView);
        } else {
            ConViewTreeList pkgTreeView = new ConViewTreeList(Messages.PageInstall_Summary_Packages, 1, false, false);
            pkgTreeView.setContentProvider((IConViewContentProvider)new SummaryTreeContentProvider(this.m_context.getSelectedJobs()));
            this.addView((IConView)pkgTreeView);
        }
        ConViewList optionsList = new ConViewList(Messages.General_Options);
        this.addGenerateResponseFileEntry(optionsList);
        this.addView((IConView)optionsList);
        super.present(a_output);
    }

    @Override
    protected CommandRecorder getCommandRecorder() {
        return this.m_context.getCommandRecorder(false);
    }

    @Override
    protected String getResponseFileOptionLabel() {
        return Messages.PageInstall_Summary_GenerateResponseFile;
    }

    public boolean isPageComplete() {
        return this.m_context.getSelectedJobs().containsJobs();
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtInst)this.conManager().getDataContext(ConDataCtxtInst.class);
        return this.m_context == null;
    }
}

