/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInst;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInstLocation;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.pages.ConPageEnterPath;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPageInstInstallLocation
extends AConPage {
    Profile m_viewProfile;
    private ConDataCtxtInstLocation m_context;
    private boolean m_newContext = true;
    private IStatus m_status = Statuses.ST.createMultiStatus();

    public ConPageInstInstallLocation(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageInstall_Install_Location_Header);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        Profile prof;
        int n;
        int n2;
        Profile[] profileArray;
        ConViewListNumbered existingProfileInfo;
        this.clear();
        int startIndex = 1;
        Profile newProfile = this.m_context.getNewProfile();
        Profile[] recomendedExistingProfiles = this.m_context.getRecommendedExistingProfiles();
        Profile[] invalidExistingProfiles = this.m_context.getInvalidExistingProfiles();
        if (this.m_newContext) {
            Profile defaultSelectedProfile = this.m_context.getDefaultSelectedProfile();
            this.m_status = this.m_context.selectProfile(defaultSelectedProfile);
            this.m_viewProfile = defaultSelectedProfile;
            this.m_newContext = false;
        }
        if (newProfile != null) {
            ConViewListNumbered newProfileInfo = new ConViewListNumbered(Messages.PageInstall_Install_Location_ListNew_Header, true, startIndex++);
            newProfileInfo.addEntry(newProfile.getProfileId(), (AConActionEntry)new ConActSelectProfile(), this.m_context.isProfileSelected(newProfile)).setContext((Object)newProfile);
            this.addView((IConView)newProfileInfo);
        }
        if (recomendedExistingProfiles.length > 0) {
            existingProfileInfo = new ConViewListNumbered(Messages.PageInstall_Install_Location_ListExisting_Header, true, startIndex);
            profileArray = recomendedExistingProfiles;
            n2 = recomendedExistingProfiles.length;
            n = 0;
            while (n < n2) {
                prof = profileArray[n];
                existingProfileInfo.addEntry(prof.getProfileId(), (AConActionEntry)new ConActSelectProfile(), this.m_context.isProfileSelected(prof)).setContext((Object)prof);
                ++n;
            }
            this.addView((IConView)existingProfileInfo);
        }
        if (invalidExistingProfiles.length > 0) {
            existingProfileInfo = new ConViewListNumbered(Messages.PageInstall_Install_Location_ListIncompatibleExisting_Header, false, startIndex += recomendedExistingProfiles.length);
            profileArray = invalidExistingProfiles;
            n2 = invalidExistingProfiles.length;
            n = 0;
            while (n < n2) {
                prof = profileArray[n];
                existingProfileInfo.addEntry(prof.getProfileId(), (AConActionEntry)new ConActSelectProfile()).setContext((Object)prof);
                ++n;
            }
            this.addView((IConView)existingProfileInfo);
        }
        ConViewStatus statusView = new ConViewStatus(null, true, this.m_status, 6);
        this.addView((IConView)statusView);
        if (this.m_viewProfile != null) {
            ConViewText profileId = new ConViewText(NLS.bind((String)Messages.PageInstall_Install_Location_Profile_Id, (Object)this.m_viewProfile.getProfileId()));
            this.addView((IConView)profileId);
            ConViewText profileLocation = new ConViewText(NLS.bind((String)Messages.PageInstall_Install_Location_Profile_Location, (Object)this.m_viewProfile.getInstallLocation()));
            this.addView((IConView)profileLocation);
            IOffering[] selectedProductOfferings = this.m_context.getSelectedProductOfferings();
            if (BitModeUtils.isMultiBitModePlatform() && BitModeUtils.isBitModeApplicable((Profile)this.m_viewProfile, (IOffering[])selectedProductOfferings)) {
                ConViewText profileBitMode = new ConViewText(NLS.bind((String)Messages.PageInstall_Install_Location_Profile_BitMode, (Object)BitModeUtils.getBitModeText((Profile)this.m_viewProfile)));
                this.addView((IConView)profileBitMode);
            }
            this.addView((IConView)ConViewText.NEW_LINE);
            if (!this.isContainedProfile(this.m_viewProfile, recomendedExistingProfiles) && !this.isContainedProfile(this.m_viewProfile, invalidExistingProfiles)) {
                ConViewList changeLocation = new ConViewList(Messages.General_Options, true);
                changeLocation.addEntry(Messages.PageInstall_Install_Location_Profile_Location_Change, "M", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PageInstall_Install_Location_Profile_Location_Enter_Header, (String)Messages.PageInstall_Install_Location_Profile_Location_Enter_Text, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                    protected IStatus processInput() {
                        IStatus status = ConPageInstInstallLocation.this.m_context.setInstallLocation(this.getInput());
                        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                            ConPageInstInstallLocation.this.m_status = status;
                            status = Status.OK_STATUS;
                        }
                        return status;
                    }
                })).setContext((Object)this.m_viewProfile);
                if (BitModeUtils.isMultiBitModePlatform() && BitModeUtils.isBitModeApplicable((Profile)this.m_viewProfile, (IOffering[])selectedProductOfferings) && BitModeUtils.hasBitModeChoice((IOffering[])selectedProductOfferings)) {
                    int bits = this.m_viewProfile.is32bit() ? 64 : 32;
                    changeLocation.addEntry(NLS.bind((String)Messages.PageInstall_Install_Location_Profile_BitMode_Change, (Object)bits), "T", (AConActionEntry)new ConActToggleBitMode());
                }
                this.addView((IConView)changeLocation);
            }
        }
        super.present(a_output);
    }

    private boolean isContainedProfile(Profile p, Profile[] profiles) {
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile prof = profileArray[n2];
            if (prof == p) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPageComplete() {
        if (this.m_context.getSelectedProfile() == null) {
            return false;
        }
        return !StatusUtil.isErrorOrCancel((IStatus)this.m_status);
    }

    public boolean skipPage() {
        if (AgentUtil.onlyInstallAgent(((ConDataCtxtInst)this.conManager().getDataContext(ConDataCtxtInst.class)).getSelectedJobs().toList())) {
            return true;
        }
        ConDataCtxtInstLocation newContext = (ConDataCtxtInstLocation)this.conManager().getDataContext(ConDataCtxtInstLocation.class);
        if (this.m_context != newContext) {
            this.m_context = newContext;
            this.m_newContext = true;
        }
        return this.m_context == null;
    }

    public void setVisible(boolean aVisible) {
        if (aVisible && this.m_context != null && this.m_viewProfile != null) {
            this.m_status = this.m_context.updateJobsProfile(this.m_viewProfile);
        }
    }

    class ConActSelectProfile
    extends AConActionEntry<ConViewListEntry> {
        ConActSelectProfile() {
        }

        public void run(IConManager a_conManager) {
            ConPageInstInstallLocation.this.m_viewProfile = (Profile)((ConViewListEntry)this.getEntry()).getContext();
            ConPageInstInstallLocation.this.m_status = ConPageInstInstallLocation.this.m_context.selectProfile(ConPageInstInstallLocation.this.m_viewProfile);
            super.run(a_conManager);
        }
    }

    class ConActToggleBitMode
    extends AConActionEntry<ConViewListEntry> {
        ConActToggleBitMode() {
        }

        public void run(IConManager a_conManager) {
            IOffering[] offerings = ConPageInstInstallLocation.this.m_context.getSelectedProductOfferings();
            if (ConPageInstInstallLocation.this.m_viewProfile.is64bit()) {
                BitModeUtils.setProfilePlatformProperties((Profile)ConPageInstInstallLocation.this.m_viewProfile, (IOfferingOrFix[])offerings, (String)BitModeUtils.get32bitArch());
            } else {
                BitModeUtils.setProfilePlatformProperties((Profile)ConPageInstInstallLocation.this.m_viewProfile, (IOfferingOrFix[])offerings, (String)BitModeUtils.get64bitArch());
            }
            ConPageInstInstallLocation.this.m_context.setInstallLocation(BitModeUtils.getProfileInstallLocationForBitMode((Profile)ConPageInstInstallLocation.this.m_viewProfile));
            ConPageInstInstallLocation.this.m_status = ConPageInstInstallLocation.this.m_context.updateJobsProfile(ConPageInstInstallLocation.this.m_viewProfile);
            super.run(a_conManager);
        }
    }
}

