/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtForProfiles;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUninstall;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConDataCtxtUninstallPackageSelector
extends ConDataCtxtForProfiles {
    private final ConDataCtxtUninstall m_mainUninstallContext;
    private static final Logger log = Logger.getLogger(ConDataCtxtUninstallPackageSelector.class);
    private final Map<String, Map<UninstallJob, List<UninstallJob>>> m_availableUninstalls = new HashMap<String, Map<UninstallJob, List<UninstallJob>>>();

    public ConDataCtxtUninstallPackageSelector(ConDataCtxtUninstall a_mainContext) {
        this.m_mainUninstallContext = a_mainContext;
    }

    public void loadInstalledPackageFixInformation() {
        Profile[] profiles;
        this.m_availableUninstalls.clear();
        Agent agent = Agent.getInstance();
        Profile[] profileArray = profiles = this.m_mainUninstallContext.getAllProductProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            HashMap installedOfferingFixMap = new HashMap();
            IOffering[] offerings = agent.getInstalledOfferings(profile);
            HashSet<IFix> fixSet = new HashSet<IFix>();
            HashMap<IFix, UninstallJob> fixToJobMap = new HashMap<IFix, UninstallJob>();
            IOffering[] iOfferingArray = offerings;
            int n3 = offerings.length;
            int n4 = 0;
            while (n4 < n3) {
                IOffering offering = iOfferingArray[n4];
                UninstallJob uninstallOfferingJob = new UninstallJob(profile, (IOfferingOrFix)offering);
                installedOfferingFixMap.put(uninstallOfferingJob, new ArrayList());
                IFix[] fixes = agent.getInstalledFixes(profile, offering);
                int j = 0;
                while (j < fixes.length) {
                    UninstallJob uninstallFixJob = null;
                    if (!fixSet.contains(fixes[j])) {
                        uninstallFixJob = new UninstallJob(profile, (IOfferingOrFix)fixes[j]);
                        fixSet.add(fixes[j]);
                        fixToJobMap.put(fixes[j], uninstallFixJob);
                    } else {
                        uninstallFixJob = (UninstallJob)fixToJobMap.get(fixes[j]);
                    }
                    if (uninstallFixJob != null) {
                        ((List)installedOfferingFixMap.get(uninstallOfferingJob)).add(uninstallFixJob);
                    }
                    ++j;
                }
                ++n4;
            }
            this.m_availableUninstalls.put(profile.getProfileId(), installedOfferingFixMap);
            ++n2;
        }
    }

    public IStatus selectJob(UninstallJob a_job) {
        IStatus return_value = Status.OK_STATUS;
        if (this.getSelectedJobs().addJob(a_job)) {
            this.getSelectedJobs().sortByNameAndVersion();
        }
        return return_value;
    }

    public void selectAllJobs(Profile a_profile) {
        UninstallJob[] uninstallJobArray = this.getAvailableUninstallJobs(a_profile);
        int n = uninstallJobArray.length;
        int n2 = 0;
        while (n2 < n) {
            UninstallJob job = uninstallJobArray[n2];
            this.getSelectedJobs().addJob(job);
            ++n2;
        }
    }

    public UninstallJob[] getAvailableUninstallJobs(Profile a_profile) {
        HashSet<UninstallJob> allAvailableUninstallJobs = new HashSet<UninstallJob>();
        Map<UninstallJob, List<UninstallJob>> map = this.m_availableUninstalls.get(a_profile.getProfileId());
        Set<UninstallJob> uninstallOfferingJobSet = map.keySet();
        allAvailableUninstallJobs.addAll(uninstallOfferingJobSet);
        for (UninstallJob offeringJob : uninstallOfferingJobSet) {
            List<UninstallJob> fixJobs = map.get(offeringJob);
            allAvailableUninstallJobs.addAll(fixJobs);
        }
        return allAvailableUninstallJobs.toArray(new UninstallJob[allAvailableUninstallJobs.size()]);
    }

    public UninstallJob[] getAvailableUninstallOfferingJobs(Profile a_profile) {
        Set<UninstallJob> keys = this.m_availableUninstalls.get(a_profile.getProfileId()).keySet();
        List<Object> sortedJobs = new ArrayList<UninstallJob>(keys);
        sortedJobs = SortUtil.sortByProfileNameAndVersion(sortedJobs, (boolean)true);
        return sortedJobs.toArray(new UninstallJob[sortedJobs.size()]);
    }

    public UninstallJob[] getAvailableUninstallFixJobs(Profile a_profile, UninstallJob offeringJob) {
        Map<UninstallJob, List<UninstallJob>> map = this.m_availableUninstalls.get(a_profile.getProfileId());
        List fixJobs = map.get(offeringJob);
        if (fixJobs == null) {
            return null;
        }
        fixJobs = SortUtil.sortByNameAndVersion(fixJobs);
        return fixJobs.toArray(new UninstallJob[fixJobs.size()]);
    }

    public void flipUninstallJobSelection(UninstallJob a_job) {
        JobListManager<UninstallJob> selectedJobs = this.getSelectedJobs();
        if (!selectedJobs.contains(a_job)) {
            selectedJobs.addJob(a_job);
            selectedJobs.sortByNameAndVersion(false);
        } else {
            selectedJobs.removeJob(a_job);
        }
    }

    public JobListManager<UninstallJob> getSelectedJobs() {
        return this.m_mainUninstallContext.getSelectedJobs();
    }

    public void prepareJobs() {
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        try {
            List<UninstallJob> jobsToPrepare = this.getSelectedJobs().toList();
            monitor.beginTask(Messages.General_ConDataCtxt_PrepareAndResolve, -1);
            if (jobsToPrepare != null && jobsToPrepare.size() > 0) {
                IStatus status = SharedUIUtils.prepareAndResolveSelectedJobs(jobsToPrepare, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(status);
            }
        }
        finally {
            monitor.done();
        }
    }
}

