/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.internal.console.manager.AConDataAgentWizard;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanelList;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanels;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPreChecks;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUninstallPackageSelector;
import com.ibm.cic.agent.internal.console.manager.ConManager;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.agent.internal.console.manager.ProfileListManager;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.model.IOffering;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConDataCtxtUninstall
extends AConDataAgentWizard {
    IConManager m_manager;
    private final Profile[] m_allProfiles;
    private final JobListManager m_selectedJobs = new JobListManager();
    private final ProfileListManager m_selectedProfiles = new ProfileListManager(true);
    ConDataCtxtUninstallPackageSelector m_contextPackageSelector;
    ConDataCtxtCustomPanels m_uninstallCustomPanelsContext = null;
    ConDataCtxtCustomPanelList m_uninstallCustomPanelListCtxt = null;
    private ConDataCtxtPreChecks m_prerequisiteChecksCtxt = null;

    public ConDataCtxtUninstall(IConManager a_manager) {
        this.m_manager = a_manager;
        this.m_allProfiles = Agent.getInstance().getSortedProductProfiles(true);
        if (this.m_allProfiles.length == 1) {
            this.getSelectedProfiles().selectProfile(this.m_allProfiles[0]);
        }
    }

    public <T extends IConDataCtxt> T getAdapter(Class<T> cls) {
        if (cls == ConDataCtxtUninstallPackageSelector.class) {
            if (this.m_contextPackageSelector == null) {
                this.m_contextPackageSelector = new ConDataCtxtUninstallPackageSelector(this);
            }
            return (T)((Object)this.m_contextPackageSelector);
        }
        if (cls == ConDataCtxtPreChecks.class) {
            if (this.m_prerequisiteChecksCtxt == null || this.m_selectedJobs.isChanged()) {
                this.m_prerequisiteChecksCtxt = new ConDataCtxtPreChecks(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_prerequisiteChecksCtxt);
        }
        if (cls == ConDataCtxtCustomPanelList.class) {
            if (this.m_uninstallCustomPanelListCtxt != null && this.m_selectedJobs.isChanged()) {
                this.clear();
            }
            if (this.m_uninstallCustomPanelListCtxt == null) {
                this.m_uninstallCustomPanelListCtxt = new ConDataCtxtCustomPanelList(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_uninstallCustomPanelListCtxt);
        }
        if (cls == ConDataCtxtCustomPanels.class) {
            if (this.m_uninstallCustomPanelsContext != null && this.m_selectedJobs.isChanged()) {
                this.clear();
            }
            if (this.m_uninstallCustomPanelsContext == null) {
                this.m_uninstallCustomPanelsContext = new ConDataCtxtCustomPanels(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_uninstallCustomPanelsContext);
        }
        return (T)super.getAdapter(cls);
    }

    public Profile[] getAllProductProfiles() {
        return this.m_allProfiles;
    }

    public ProfileListManager getSelectedProfiles() {
        return this.m_selectedProfiles;
    }

    public IStatus uninstallSelected() {
        IStatus return_value = Status.OK_STATUS;
        Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
        return_value = ((ConManager)this.m_manager).getConsoleApp().run(this.getCommandRecorder().getRecordedCommand(), CmdLine.CL.getParam1StrVal("-record"));
        if (!return_value.isOK()) {
            System.out.println(return_value);
        }
        return return_value;
    }

    public CommandRecorder getCommandRecorder() {
        List<UninstallJob> jobs = this.getSelectedJobs().toList();
        for (UninstallJob j : jobs) {
            j.setAcceptLicense(true);
            j.setSelected(true);
        }
        AgentJob[] jobsToUninstall = jobs.toArray(new AgentJob[jobs.size()]);
        CommandRecorder commandRecorder = new CommandRecorder();
        commandRecorder.recordJobs(jobsToUninstall, true);
        return commandRecorder;
    }

    public JobListManager<UninstallJob> getSelectedJobs() {
        return this.m_selectedJobs;
    }

    public boolean selectedAreAllFixes() {
        List<UninstallJob> selectedJobs = this.getSelectedJobs().toList();
        for (UninstallJob job : selectedJobs) {
            IOffering offering = job.getOffering();
            if (offering == null) continue;
            return false;
        }
        return true;
    }

    private void clear() {
        this.m_uninstallCustomPanelListCtxt = null;
        this.m_uninstallCustomPanelsContext = null;
        this.m_prerequisiteChecksCtxt = null;
    }
}

