/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsMain;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConDataCtxtPrefsReps
extends ConDataCtxtPrefsBase {
    public static final ICicPreferenceConstants.PreferenceTag repTag = ICicPreferenceConstants.REPOSITORY_LOCATIONS;
    public static final ICicPreferenceConstants.PreferenceTag serviceRepTag = ICicPreferenceConstants.USE_SERVICE_REPOSITORIES;
    ICicPreferenceConstants.ComposedPreferenceTag repoSpecialSettingsTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, "", ICicPreferenceConstants.REPOSITORY_SPECIAL_SETTINGS);
    ICicPreferenceConstants.ComposedPreferenceTag repoIsOpenTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, "", ICicPreferenceConstants.REPOSITORY_IS_OPEN);
    List<RepositoryData> m_list = new ArrayList<RepositoryData>();
    private boolean m_useServiceRep = CicPreferenceManager.getInstance().getBoolean(serviceRepTag.key());
    int m_currentIndex = -1;

    ConDataCtxtPrefsReps(ConDataCtxtPrefsMain a_mainPreferenceDataContext) {
        super(a_mainPreferenceDataContext);
        this.loadRepositorySettings();
    }

    @Override
    public boolean isPreferenceEditable() {
        return SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)repTag) || SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)serviceRepTag);
    }

    public void loadRepositorySettings() {
        String[] locations;
        String[] stringArray = locations = this.parentContext().getPrefMan().getStringArray(repTag.key());
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            boolean open = this.parentContext().getPrefMan().getBoolean(this.repoIsOpenTag.replaceKey(1, location).key());
            this.m_list.add(new RepositoryData(location, open));
            ++n2;
        }
    }

    public List<RepositoryData> getList() {
        return this.m_list;
    }

    public int getCurrentIndex() {
        return this.m_currentIndex;
    }

    public ConDataCtxtPrefsMain parentContext() {
        return this.m_mainPrefDataContext;
    }

    public void setCurrentIndex(int index) {
        this.m_currentIndex = index;
    }

    public void removeRepository() {
        if (this.m_currentIndex >= 0) {
            this.m_list.remove(this.m_currentIndex);
            this.m_preferencesChanged = true;
            this.m_currentIndex = -1;
        }
    }

    public void repositoryOpenClose() {
        if (this.m_currentIndex >= 0) {
            RepositoryData element = this.m_list.get(this.m_currentIndex);
            element.open = !element.open;
            this.m_preferencesChanged = true;
            this.m_currentIndex = -1;
        }
    }

    public boolean isOpen() {
        RepositoryData element = this.m_list.get(this.m_currentIndex);
        return element.open;
    }

    public IStatus testConnection() {
        RepositoryData entry = this.m_list.get(this.m_currentIndex);
        RepositoryGroup repGroup = RepositoryGroup.getDefault();
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)repGroup, (String)entry.location, null, null, (String)entry.location, null);
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        monitor.beginTask(Messages.PagePreference_Rep_TestConnection, -1);
        IStatus status = RepositoryUtils.addRepositoryOrRefreshStatus((IRepositoryInfo)repInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        monitor.done();
        if (!status.isOK()) {
            status = new RepositoryStatus(RepositoryStatus.ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY, entry.location);
        }
        return status;
    }

    public String selectedRepository() {
        RepositoryData element = this.m_list.get(this.m_currentIndex);
        return element.location;
    }

    public void addRepository(String a_location) {
        this.m_list.add(new RepositoryData(a_location, true));
        this.m_preferencesChanged = true;
    }

    public boolean isRepositoryInList(String a_location) {
        for (RepositoryData repData : this.m_list) {
            String repLocation = repData.location;
            if (!repLocation.equals(a_location)) continue;
            return true;
        }
        return false;
    }

    public boolean isPassportAdvantageRep(String a_location) {
        String lcPassportAdvantageSiteLocation;
        String lcRepositoryLocation = a_location.toLowerCase();
        return lcRepositoryLocation.startsWith(lcPassportAdvantageSiteLocation = CommonDef.Urls.EntitledRepositoryUrl.toLowerCase());
    }

    public boolean canMoveUp() {
        return this.m_currentIndex > 0;
    }

    public boolean canMoveDown() {
        return this.m_currentIndex < this.m_list.size() - 1;
    }

    public void moveUp() {
        if (this.canMoveUp()) {
            RepositoryData entry = this.m_list.get(this.m_currentIndex);
            this.m_list.remove(this.m_currentIndex);
            this.m_list.add(--this.m_currentIndex, entry);
            this.m_preferencesChanged = true;
        }
    }

    public void moveDown() {
        if (this.canMoveDown()) {
            RepositoryData entry = this.m_list.get(this.m_currentIndex);
            this.m_list.remove(this.m_currentIndex);
            this.m_list.add(++this.m_currentIndex, entry);
            this.m_preferencesChanged = true;
        }
    }

    public void setIfUseServiceRep(boolean useServiceRep) {
        this.m_preferencesChanged = true;
        this.m_useServiceRep = useServiceRep;
    }

    public boolean getIfUseServiceRep() {
        return this.m_useServiceRep;
    }

    @Override
    public void savePreferences() {
        ICicPreferenceHandler prefCurrentHandler = this.parentContext().getCurrentPrefHandler();
        prefCurrentHandler.remove(repTag);
        if (this.m_list.isEmpty()) {
            prefCurrentHandler.addValue(repTag.key(), "");
            prefCurrentHandler.addValue(this.repoIsOpenTag.key(), "");
        } else {
            for (RepositoryData entry : this.m_list) {
                String location = entry.location;
                prefCurrentHandler.addValue(repTag.key(), location);
                Boolean open = entry.open;
                prefCurrentHandler.setValue(this.repoIsOpenTag.replaceKey(1, location).key(), open.booleanValue());
            }
        }
        prefCurrentHandler.setValue(serviceRepTag.key(), this.m_useServiceRep);
        super.savePreferences();
    }

    @Override
    public void restoreDefaults() {
        this.m_preferencesChanged = true;
        this.m_list.clear();
        this.m_useServiceRep = this.parentContext().getDefaultPrefHandler().getBoolean(serviceRepTag.key());
    }

    public static class RepositoryData {
        public String location;
        public boolean open;

        RepositoryData(String l, boolean o) {
            this.location = l;
            this.open = o;
        }
    }
}

