/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.actions;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.SharedUpdateAgentUtils;
import com.ibm.cic.agent.internal.console.ConUpdateAgentUtils;
import com.ibm.cic.common.core.console.actions.ConActionAddPage;
import com.ibm.cic.common.core.console.dialogs.ConMessageDialog;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.sharedUI.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class ConActionCheckAgentUpdate
extends ConActionAddPage {
    protected abstract AConPage doCreateNewPage(IConManager var1);

    protected AConPage createNewPage(IConManager a_manager) {
        return this.runChecksForRepositoriesAndAgentUpdate(a_manager);
    }

    private IStatus checkRepositories(IConManager manager, IProgressMonitor monitor) {
        try {
            monitor.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.ProgressDialog_Checking_Repositories, 2);
            IStatus status = Agent.getInstance().getRepositoryGroupStatus(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (status.matches(8)) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.displayMessages(manager, status);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus checkForUpdates(IConManager manager, IProgressMonitor monitor) {
        if (!Agent.getInstance().searchForAgentUpdate()) {
            return Statuses.ST.createMultiStatus(-51, "", new Object[0]);
        }
        IStatus status = ConUpdateAgentUtils.checkForAgentUpdateNDisplayServiceRepStatus(manager, monitor);
        if (StatusUtil.isCancel((IStatus)status)) {
            return Statuses.ST.createMultiStatus(-51, null, new Object[0]);
        }
        return status;
    }

    private void displayMessages(IConManager manager, IStatus status) {
        Boolean[] isWarning = new Boolean[]{Boolean.FALSE};
        CicMultiStatus crStatus = SharedUpdateAgentUtils.getConnectionAndRepositoryMessageStatus((IStatus)status, (Boolean[])isWarning);
        if (!status.isOK()) {
            ConStatusMessageDialog.openError((IConManager)manager, (String)Messages.DialogTitle_Warning, null, (IStatus)crStatus, (int)15);
        } else {
            String repMessages = crStatus.getMessage();
            if (repMessages.length() > 0) {
                if (isWarning[0].booleanValue()) {
                    ConMessageDialog.openWarning((IConManager)manager, (String)Messages.AddRepositoryDialog_RepWarning, (String)repMessages);
                } else {
                    ConMessageDialog.openInformation((IConManager)manager, (String)Messages.AddRepositoryDialog_RepInfo, (String)repMessages);
                }
            }
        }
    }

    private AConPage runChecksForRepositoriesAndAgentUpdate(IConManager manager) {
        IStatus return_value = this.checkRepositories(manager, ConsoleProgressMonitor.createMonitorWithUnknownWork());
        if (!return_value.isOK()) {
            return null;
        }
        return_value = this.checkForUpdates(manager, ConsoleProgressMonitor.createMonitorWithUnknownWork());
        if (StatusUtil.isErrorOrCancel((IStatus)return_value) || return_value.getCode() != -51) {
            return null;
        }
        return this.doCreateNewPage(manager);
    }
}

