/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.BitLevel;
import org.apache.harmony.math.internal.nls.Messages;

class Multiplication {
    static final int whenUseKaratsuba = 63;
    static final int[] tenPows;
    static final int[] fivePows;
    static final BigInteger[] bigTenPows;
    static final BigInteger[] bigFivePows;

    private Multiplication() {
    }

    static BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        return Multiplication.karatsuba(bigInteger, bigInteger2);
    }

    static BigInteger karatsuba(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.numberLength > bigInteger.numberLength) {
            BigInteger bigInteger3 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger3;
        }
        if (bigInteger2.numberLength < 63) {
            return Multiplication.multiplyPAP(bigInteger, bigInteger2);
        }
        int n = (bigInteger.numberLength & 0xFFFFFFFE) << 4;
        BigInteger bigInteger4 = bigInteger.shiftRight(n);
        BigInteger bigInteger5 = bigInteger2.shiftRight(n);
        BigInteger bigInteger6 = bigInteger.subtract(bigInteger4.shiftLeft(n));
        BigInteger bigInteger7 = bigInteger2.subtract(bigInteger5.shiftLeft(n));
        BigInteger bigInteger8 = Multiplication.karatsuba(bigInteger4, bigInteger5);
        BigInteger bigInteger9 = Multiplication.karatsuba(bigInteger6, bigInteger7);
        BigInteger bigInteger10 = Multiplication.karatsuba(bigInteger4.subtract(bigInteger6), bigInteger7.subtract(bigInteger5));
        bigInteger10 = bigInteger10.add(bigInteger8).add(bigInteger9);
        bigInteger10 = bigInteger10.shiftLeft(n);
        bigInteger8 = bigInteger8.shiftLeft(n << 1);
        return bigInteger8.add(bigInteger10).add(bigInteger9);
    }

    static BigInteger multiplyPAP(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int n2 = bigInteger.numberLength;
        int n3 = bigInteger2.numberLength;
        int n4 = n2 + n3;
        int n5 = n = bigInteger.sign != bigInteger2.sign ? -1 : 1;
        if (n4 == 2) {
            long l = Multiplication.unsignedMultAddAdd(bigInteger.digits[0], bigInteger2.digits[0], 0, 0);
            int n6 = (int)l;
            int n7 = (int)(l >>> 32);
            return n7 == 0 ? new BigInteger(n, n6) : new BigInteger(n, 2, new int[]{n6, n7});
        }
        int[] nArray = bigInteger.digits;
        int[] nArray2 = bigInteger2.digits;
        int[] nArray3 = new int[n4];
        Multiplication.multArraysPAP(nArray, n2, nArray2, n3, nArray3);
        BigInteger bigInteger3 = new BigInteger(n, n4, nArray3);
        bigInteger3.cutOffLeadingZeroes();
        return bigInteger3;
    }

    static void multArraysPAP(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        if (n == 0 || n2 == 0) {
            return;
        }
        if (n == 1) {
            nArray3[n2] = Multiplication.multiplyByInt(nArray3, nArray2, n2, nArray[0]);
        } else if (n2 == 1) {
            nArray3[n] = Multiplication.multiplyByInt(nArray3, nArray, n, nArray2[0]);
        } else {
            Multiplication.multPAP(nArray, nArray2, nArray3, n, n2);
        }
    }

    static void multPAP(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        if (nArray == nArray2 && n == n2) {
            Multiplication.square(nArray, n, nArray3);
            return;
        }
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            int n3 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                l = Multiplication.unsignedMultAddAdd(n3, nArray2[j], nArray3[i + j], (int)l);
                nArray3[i + j] = (int)l;
                l >>>= 32;
            }
            nArray3[i + n2] = (int)l;
        }
    }

    private static int multiplyByInt(int[] nArray, int[] nArray2, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = Multiplication.unsignedMultAddAdd(nArray2[i], n2, (int)l, 0);
            nArray[i] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    static int multiplyByInt(int[] nArray, int n, int n2) {
        return Multiplication.multiplyByInt(nArray, nArray, n, n2);
    }

    static BigInteger multiplyByPositiveInt(BigInteger bigInteger, int n) {
        int n2 = bigInteger.sign;
        if (n2 == 0) {
            return BigInteger.ZERO;
        }
        int n3 = bigInteger.numberLength;
        int[] nArray = bigInteger.digits;
        if (n3 == 1) {
            long l = Multiplication.unsignedMultAddAdd(nArray[0], n, 0, 0);
            int n4 = (int)l;
            int n5 = (int)(l >>> 32);
            return n5 == 0 ? new BigInteger(n2, n4) : new BigInteger(n2, 2, new int[]{n4, n5});
        }
        int n6 = n3 + 1;
        int[] nArray2 = new int[n6];
        nArray2[n3] = Multiplication.multiplyByInt(nArray2, nArray, n3, n);
        BigInteger bigInteger2 = new BigInteger(n2, n6, nArray2);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    static BigInteger pow(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = bigInteger;
        while (n > 1) {
            if ((n & 1) != 0) {
                bigInteger2 = bigInteger2.multiply(bigInteger3);
            }
            bigInteger3 = bigInteger3.numberLength == 1 ? bigInteger3.multiply(bigInteger3) : new BigInteger(1, Multiplication.square(bigInteger3.digits, bigInteger3.numberLength, new int[bigInteger3.numberLength << 1]));
            n >>= 1;
        }
        bigInteger2 = bigInteger2.multiply(bigInteger3);
        return bigInteger2;
    }

    static int[] square(int[] nArray, int n, int[] nArray2) {
        int n2;
        long l;
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            l = 0L;
            for (n2 = n3 + 1; n2 < n; ++n2) {
                l = Multiplication.unsignedMultAddAdd(nArray[n3], nArray[n2], nArray2[n3 + n2], (int)l);
                nArray2[n3 + n2] = (int)l;
                l >>>= 32;
            }
            nArray2[n3 + n] = (int)l;
        }
        BitLevel.shiftLeftOneBit(nArray2, nArray2, n << 1);
        l = 0L;
        n3 = 0;
        n2 = 0;
        while (n3 < n) {
            l = Multiplication.unsignedMultAddAdd(nArray[n3], nArray[n3], nArray2[n2], (int)l);
            nArray2[n2] = (int)l;
            l >>>= 32;
            nArray2[n2] = (int)(l += (long)nArray2[++n2] & 0xFFFFFFFFL);
            l >>>= 32;
            ++n3;
            ++n2;
        }
        return nArray2;
    }

    static BigInteger multiplyByTenPow(BigInteger bigInteger, long l) {
        return l < (long)tenPows.length ? Multiplication.multiplyByPositiveInt(bigInteger, tenPows[(int)l]) : bigInteger.multiply(Multiplication.powerOf10(l));
    }

    static BigInteger powerOf10(long l) {
        long l2;
        BigInteger bigInteger;
        int n = (int)l;
        if (l < (long)bigTenPows.length) {
            return bigTenPows[n];
        }
        if (l <= 50L) {
            return BigInteger.TEN.pow(n);
        }
        if (l <= 1000L) {
            return bigFivePows[1].pow(n).shiftLeft(n);
        }
        long l3 = 1L + (long)((double)l / 2.4082399653118496);
        if (l3 > Runtime.getRuntime().freeMemory()) {
            throw new ArithmeticException(Messages.getString("math.01"));
        }
        if (l <= Integer.MAX_VALUE) {
            return bigFivePows[1].pow(n).shiftLeft(n);
        }
        BigInteger bigInteger2 = bigInteger = bigFivePows[1].pow(Integer.MAX_VALUE);
        n = (int)(l % Integer.MAX_VALUE);
        for (l2 = l - Integer.MAX_VALUE; l2 > Integer.MAX_VALUE; l2 -= Integer.MAX_VALUE) {
            bigInteger2 = bigInteger2.multiply(bigInteger);
        }
        bigInteger2 = bigInteger2.multiply(bigFivePows[1].pow(n));
        bigInteger2 = bigInteger2.shiftLeft(Integer.MAX_VALUE);
        for (l2 = l - Integer.MAX_VALUE; l2 > Integer.MAX_VALUE; l2 -= Integer.MAX_VALUE) {
            bigInteger2 = bigInteger2.shiftLeft(Integer.MAX_VALUE);
        }
        bigInteger2 = bigInteger2.shiftLeft(n);
        return bigInteger2;
    }

    static BigInteger multiplyByFivePow(BigInteger bigInteger, int n) {
        if (n < fivePows.length) {
            return Multiplication.multiplyByPositiveInt(bigInteger, fivePows[n]);
        }
        if (n < bigFivePows.length) {
            return bigInteger.multiply(bigFivePows[n]);
        }
        return bigInteger.multiply(bigFivePows[1].pow(n));
    }

    static long unsignedMultAddAdd(int n, int n2, int n3, int n4) {
        return ((long)n & 0xFFFFFFFFL) * ((long)n2 & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL) + ((long)n4 & 0xFFFFFFFFL);
    }

    static {
        int n;
        tenPows = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        fivePows = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        bigTenPows = new BigInteger[32];
        bigFivePows = new BigInteger[32];
        long l = 1L;
        for (n = 0; n <= 18; ++n) {
            Multiplication.bigFivePows[n] = BigInteger.valueOf(l);
            Multiplication.bigTenPows[n] = BigInteger.valueOf(l << n);
            l *= 5L;
        }
        while (n < bigTenPows.length) {
            Multiplication.bigFivePows[n] = bigFivePows[n - 1].multiply(bigFivePows[1]);
            Multiplication.bigTenPows[n] = bigTenPows[n - 1].multiply(BigInteger.TEN);
            ++n;
        }
    }
}

