/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.installAdaptors.AbstractPropertyContributorRegistry;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseIniContributorRegistry
extends AbstractPropertyContributorRegistry {
    private final File launcherLocation;
    static String EMPTY_STR = "";
    static String DELIMITER = " ";
    static String DELIMITER_HYPHEN = " -";
    static int HYPHEN = 45;
    static int QUOTE = 34;
    private static final String PROGRAM_ARGS = "-programArgs";
    private static final String VM_LOCATION_ARG = "-vm";
    private static final String[] SIZE_ARGS = new String[]{"-Xmso", "-Xms", "-Xmx", "-Xoss", "-Xss", "-Xmca", "-Xmco", "-Xmns", "-Xmnx", "-Xmn", "-Xmos", "-Xmox", "-Xmoi", "-Xmo", "-Xmrx", "-Xmr", "-Xiss", "-Xscmx", "-Xmine", "-Xmaxe", "-XX:MaxPermSize"};
    private static final HashSet SIZE_ARGS_SET = new HashSet<String>(Arrays.asList(SIZE_ARGS));
    private static final String[] NUMBER_ARGS = new String[]{"-Xminf", "-Xmaxf", "-Xgcthreads"};
    private static final HashSet NUMBER_ARGS_SET = new HashSet<String>(Arrays.asList(NUMBER_ARGS));

    public EclipseIniContributorRegistry(InstallContext context) {
        super(new File(context.getAdapterStorage("eclipse"), "eclipseIni.properties"));
        this.launcherLocation = PlatformUtils.getLauncherLocation((String)context.getInstallLocation());
    }

    @Override
    public void initialize(ConfigurationContributorEditor editor) throws CoreException {
        String vmLocation = editor.getVMLocation();
        ArrayList programArgsList = editor.getProgramArgumentList();
        ArrayList vmArgList = editor.getVMArgList();
        if (this.load()) {
            this.addDelta(programArgsList, vmLocation, vmArgList);
        } else {
            this.addExisting(programArgsList, vmLocation, vmArgList);
        }
    }

    public void setVmLocation(Map contribution, String location) {
        contribution.put(VM_LOCATION_ARG, location);
    }

    public void addVmArgs(Map contribution, List rawArgs) {
        for (String rawArg : rawArgs) {
            String[] nameAndValue = this.getArgNameAndValue(rawArg);
            contribution.put(nameAndValue[0], nameAndValue[1]);
        }
    }

    private Map<String, String> splitProgramArgs(String rawArgs) {
        LinkedHashMap<String, String> argsMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (rawArgs != null && i < rawArgs.length()) {
            if (rawArgs.charAt(i) == HYPHEN) {
                String optionName = null;
                String optionValue = null;
                if ((i += (optionName = rawArgs.indexOf(DELIMITER, i) > 0 ? rawArgs.substring(i, rawArgs.indexOf(DELIMITER, i)) : rawArgs.substring(i)).length() + 1) >= rawArgs.length() || rawArgs.charAt(i) == HYPHEN) {
                    --i;
                    argsMap.put(optionName, EMPTY_STR);
                } else {
                    if (rawArgs.charAt(i) == QUOTE) {
                        optionValue = rawArgs.substring(i + 1, rawArgs.indexOf(QUOTE, i + 1));
                        i += optionValue.length() + 2;
                    } else {
                        optionValue = rawArgs.indexOf(DELIMITER_HYPHEN, i) > 0 ? rawArgs.substring(i, rawArgs.indexOf(DELIMITER_HYPHEN, i)) : rawArgs.substring(i);
                        i += optionValue.length();
                    }
                    argsMap.put(optionName.trim(), optionValue.trim());
                }
            }
            ++i;
        }
        return argsMap;
    }

    public void addProgramArgs(Map contribution, List rawArgs) {
        if (rawArgs == null || rawArgs.size() == 0) {
            return;
        }
        String programArgs = EMPTY_STR;
        for (String rawArg : rawArgs) {
            if (rawArg.length() <= 0) continue;
            programArgs = programArgs.length() == 0 ? rawArg : String.valueOf(programArgs) + " " + rawArg;
        }
        this.addProgramArgs(contribution, programArgs);
    }

    private void addProgramArgs(Map contribution, String programArgs) {
        Map<String, String> args = this.splitProgramArgs(programArgs);
        for (Map.Entry<String, String> entry : args.entrySet()) {
            contribution.put(PROGRAM_ARGS + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void applyMergedChanges(ConfigurationContributorEditor editor) {
        editor.setProgramArgumentList(this.getProgramArgsList());
        editor.setVMLocation(this.getVmLocation());
        editor.setVMArgList(this.getVmArgList());
    }

    @Override
    protected Map createMergedPropertyMap() {
        return new LinkedHashMap();
    }

    @Override
    protected String getMergedValue(String name, String currentValue, String newValue) {
        if (name.startsWith(PROGRAM_ARGS)) {
            return newValue;
        }
        if (this.isSizeArg(name)) {
            return this.maxSize(newValue, currentValue);
        }
        return newValue;
    }

    private ArrayList getProgramArgsList() {
        Map registry = this.getMergedRegistry();
        ArrayList<String> argsList = new ArrayList<String>();
        for (Map.Entry entry : registry.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(PROGRAM_ARGS)) continue;
            argsList.add(name.substring(PROGRAM_ARGS.length()));
            if (entry.getValue() == null || EMPTY_STR.equals(entry.getValue())) continue;
            argsList.add((String)entry.getValue());
        }
        return argsList;
    }

    private String getVmLocation() {
        Map registry = this.getMergedRegistry();
        return (String)registry.get(VM_LOCATION_ARG);
    }

    private ArrayList getVmArgList() {
        Map registry = this.getMergedRegistry();
        ArrayList<String> list = new ArrayList<String>(registry.size());
        for (Map.Entry entry : registry.entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals(VM_LOCATION_ARG) || name.startsWith(PROGRAM_ARGS)) continue;
            String value = (String)entry.getValue();
            String rawArg = this.getRawArg(name, value);
            list.add(rawArg);
        }
        return list;
    }

    private void addDelta(List programRawArgs, String vmLocation, List vmRawArgs) throws CoreException {
        Map current = this.createNewContribution();
        if (vmLocation != null) {
            current.put(VM_LOCATION_ARG, vmLocation);
        }
        this.addProgramArgs(current, programRawArgs);
        this.addVmArgs(current, vmRawArgs);
        this.addDelta(current);
    }

    private void addExisting(List programRawArgs, String vmLocation, List vmRawArgs) throws CoreException {
        if (vmLocation != null || vmRawArgs.size() != 0 || programRawArgs.size() != 0) {
            Map current = this.createNewContribution();
            if (vmLocation != null) {
                current.put(VM_LOCATION_ARG, vmLocation);
            }
            this.addProgramArgs(current, programRawArgs);
            this.addVmArgs(current, vmRawArgs);
            this.addExisting(current);
        }
    }

    private String[] getArgNameAndValue(String rawArg) {
        int i;
        String[] nameAndValue = new String[]{rawArg, ""};
        if (rawArg.startsWith("-D") || rawArg.startsWith("-XX:")) {
            int i2 = rawArg.indexOf(61);
            if (i2 > 0) {
                nameAndValue[0] = rawArg.substring(0, i2);
                nameAndValue[1] = rawArg.substring(i2 + 1);
            }
        } else if (rawArg.startsWith("-X") && !this.getNumberArgNameAndValue(rawArg, nameAndValue) && (i = rawArg.indexOf(58)) > 0) {
            nameAndValue[0] = rawArg.substring(0, i);
            nameAndValue[1] = rawArg.substring(i + 1);
        }
        return nameAndValue;
    }

    private String getRawArg(String name, String value) {
        String rawArg;
        if (name.startsWith("-D") || name.startsWith("-XX:")) {
            rawArg = value.length() == 0 ? name : String.valueOf(name) + '=' + value;
        } else if (name.startsWith("-X")) {
            rawArg = this.isNumberArg(name) ? String.valueOf(name) + value : (value.length() == 0 ? name : String.valueOf(name) + ':' + value);
        } else {
            assert (value.length() == 0);
            rawArg = name;
        }
        return rawArg;
    }

    private boolean getNumberArgNameAndValue(String rawArg, String[] nameAndValue) {
        int i = this.indexOfNumberArgValue(rawArg, SIZE_ARGS);
        if (i > 0) {
            nameAndValue[0] = rawArg.substring(0, i);
            nameAndValue[1] = rawArg.substring(i);
            return true;
        }
        i = this.indexOfNumberArgValue(rawArg, NUMBER_ARGS);
        if (i > 0) {
            nameAndValue[0] = rawArg.substring(0, i);
            nameAndValue[1] = rawArg.substring(i);
            return true;
        }
        return false;
    }

    private int indexOfNumberArgValue(String arg, String[] numberArgs) {
        String[] stringArray = numberArgs;
        int n = numberArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String numberArg = stringArray[n2];
            if (arg.startsWith(numberArg)) {
                return numberArg.length();
            }
            ++n2;
        }
        return -1;
    }

    private boolean isSizeArg(String arg) {
        return SIZE_ARGS_SET.contains(arg);
    }

    private boolean isNumberArg(String arg) {
        return NUMBER_ARGS_SET.contains(arg) || this.isSizeArg(arg);
    }

    private String maxSize(String value1, String value2) {
        int size2;
        int size1 = this.parseSize(value1);
        return size1 > (size2 = this.parseSize(value2)) ? value1 : value2;
    }

    private int parseSize(String sizeStr) {
        int size;
        if (sizeStr.length() == 0) {
            return 0;
        }
        char c = Character.toLowerCase(sizeStr.charAt(sizeStr.length() - 1));
        try {
            size = c == 'm' || c == 'k' ? Integer.parseInt(sizeStr.substring(0, sizeStr.length() - 1)) : Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        if (c == 'm') {
            size = size * 1024 * 1024;
        } else if (c == 'k') {
            size *= 1024;
        }
        return size;
    }

    @Override
    protected boolean argMergedValueEquals(String name, String args1, String args2) {
        if (args1 == null || args2 == null) {
            return args1 == null && args2 == null;
        }
        if (VM_LOCATION_ARG.equals(name)) {
            return FileUtil.filesAreSame((File)this.getCanonicalVmLocation(args1), (File)this.getCanonicalVmLocation(args2));
        }
        boolean result = super.argMergedValueEquals(name, args1, args2);
        if (result || !name.startsWith(PROGRAM_ARGS)) {
            return result;
        }
        return this.argValueEquals(name.substring(PROGRAM_ARGS.length()), args1, args2);
    }

    private boolean argValueEquals(String argName, String value1, String value2) {
        Path path1 = new Path(value1);
        Path path2 = new Path(value2);
        if (path1.segmentCount() > 1 || path2.segmentCount() > 1) {
            return path1.equals((Object)path2);
        }
        return value1.equals(value2);
    }

    @Override
    protected Map fixupContribution(Map contribution) {
        String programArgs = (String)contribution.get(PROGRAM_ARGS);
        if (programArgs != null) {
            this.addProgramArgs(contribution, (String)contribution.get(PROGRAM_ARGS));
            contribution.remove(PROGRAM_ARGS);
        }
        return contribution;
    }

    private File getCanonicalVmLocation(String vmLocation) {
        File f = new File(vmLocation);
        if (!f.isAbsolute()) {
            f = new File(this.launcherLocation, vmLocation);
        }
        return FileUtil.getCanonicalFile((File)f);
    }
}

