/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.installAdaptors.BundleEntry;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.agent.internal.installAdaptors.EclipseBundleOperation;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import com.ibm.cic.common.eclipseAdapterData.EclipseFeatureData;
import com.ibm.cic.common.eclipseAdapterData.EclipseIdVersionData;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class ConfigureFeatureOperation
extends EclipseBundleOperation {
    private final EclipseFeatureData featureData;

    public ConfigureFeatureOperation(EclipseFeatureData featureData, Collection artifacts, IInstallableUnit unit, InstallContext context, ConfigurationContributorEditor targetedConfig, boolean configure) {
        super(artifacts, unit, context, targetedConfig, configure);
        this.featureData = featureData;
    }

    protected CommonAdapterData getData() {
        return this.featureData;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        if (this.isConfigure()) {
            BundleEntry entry = this.getBundleEntry((EclipseIdVersionData)this.featureData);
            if (entry != null) {
                String location = entry.getLocalURL().toExternalForm();
                Version pluginVersion = this.featureData.getPluginVersion();
                this.targetedConfig.addFeature(this.featureData.getId(), this.featureData.getVersion().toString(), location, this.featureData.getPluginId(), pluginVersion == null ? null : pluginVersion.toString(), this.featureData.isPrimary(), this.featureData.getApplication());
            }
        } else {
            String location = this.getLocation((EclipseIdVersionData)this.featureData, "features", true);
            this.targetedConfig.removeFeature(this.featureData.getId(), this.featureData.getVersion().toString(), location);
        }
        return Status.OK_STATUS;
    }

    protected boolean isMatchingArtifact(IArtifact artifact) {
        return artifact instanceof EclipseArtifact && ((EclipseArtifact)artifact).getType() == 3;
    }
}

