/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformConfigurationState {
    private static final String ORG_OSGI_FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    private static final String OSGI_ID = "org.eclipse.osgi";
    private static final Version OSGI_VERSION_WITH_ARBITRARY_ATTR_MATCHING = new Version(3, 7, 0);
    private static final Set<String> PREDEFINED_REQUIRE_BUNDLE_ATTRS;
    private static final Set<String> PREDEFINED_FRAGMENT_HOST_ATTRS;
    private static final Map<String, Set<String>> HEADERS_WITH_ARBITRARY_ATTRS;
    private final PlatformAdmin platformAdmin = Platform.getPlatformAdmin();
    private final StateObjectFactory factory = this.platformAdmin.getFactory();
    private final State state = this.factory.createState(false);
    private final Set requiredExecutionEnvironment = new HashSet();
    private int initialRequiredExecutionEnvironmentSize;
    private final Map idToDescription = new HashMap();
    private boolean doFilterArbitraryAttributes = false;
    private int nextId = 1;
    private static final boolean trace = false;
    private String currentIndent = "";

    static {
        HashSet<String> attrs = new HashSet<String>();
        attrs.add("bundle-version");
        attrs.add("optional");
        attrs.add("reprovide");
        PREDEFINED_REQUIRE_BUNDLE_ATTRS = Collections.unmodifiableSet(attrs);
        attrs = new HashSet();
        attrs.add("bundle-version");
        PREDEFINED_FRAGMENT_HOST_ATTRS = Collections.unmodifiableSet(attrs);
        HashMap<String, Set<String>> headers = new HashMap<String, Set<String>>();
        headers.put("Require-Bundle", PREDEFINED_REQUIRE_BUNDLE_ATTRS);
        headers.put("Fragment-Host", PREDEFINED_FRAGMENT_HOST_ATTRS);
        HEADERS_WITH_ARBITRARY_ATTRS = Collections.unmodifiableMap(headers);
    }

    public PlatformConfigurationState() {
        this.state.setResolver(this.platformAdmin.createResolver());
        this.initRequiredExecutionEnvironments();
    }

    public IStatus init(File configDir, BundleInfo[] infos, IProgressMonitor monitor) throws IOException, BundleException {
        monitor.beginTask("", infos.length + 2);
        try {
            Version systemBundleVersion;
            BundleInfo systemBundle = this.getSystemBundle(infos);
            if (systemBundle != null && (systemBundleVersion = new Version(systemBundle.getVersion())).compareTo(OSGI_VERSION_WITH_ARBITRARY_ATTR_MATCHING) < 0) {
                this.doFilterArbitraryAttributes = true;
            }
            BundleInfo[] bundleInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                BundleInfo info = bundleInfoArray[n2];
                BundleDescription description = this.addBundleDescription(info, configDir);
                if (description != null && !info.getSymbolicName().equals(description.getSymbolicName())) {
                    Status status = new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.PlatformConfigurationState_nonMatchingBundleId, (Object)info.getSymbolicName(), (Object)description.getSymbolicName()), null);
                    return status;
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                ++n2;
            }
            IStatus status = this.setPlatformProperties();
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            monitor.worked(1);
            this.internalResolve(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void resolve(IProgressMonitor monitor) {
        this.internalResolve(true, monitor);
    }

    private void internalResolve(boolean flushConstraints, IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        try {
            this.state.resolve(true);
            if (flushConstraints) {
                this.flushConstraints();
            }
            this.dumpState();
        }
        finally {
            monitor.done();
        }
    }

    public State getState() {
        return this.state;
    }

    private void flushConstraints() {
        BundleDescription[] bundles;
        BundleDescription[] bundleDescriptionArray = bundles = this.state.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            HostSpecification host = bundle.getHost();
            if (!bundle.isResolved()) {
                BundleSpecification[] requiredBundles;
                if (host != null) {
                    this.state.resolveConstraint((VersionConstraint)host, null);
                }
                if ((requiredBundles = bundle.getRequiredBundles()) != null && requiredBundles.length != 0) {
                    BundleSpecification[] bundleSpecificationArray = requiredBundles;
                    int n3 = requiredBundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        BundleSpecification requiredBundle = bundleSpecificationArray[n4];
                        this.state.resolveConstraint((VersionConstraint)requiredBundle, null);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private IStatus setPlatformProperties() {
        Dictionary[] currentPlatformProperties = this.platformAdmin.getState(false).getPlatformProperties();
        String execEnv = null;
        Dictionary d = null;
        if (currentPlatformProperties.length == 1) {
            d = currentPlatformProperties[0];
            execEnv = (String)d.get(ORG_OSGI_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (execEnv == null) {
            return new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.PlatformConfigurationState_missingExecutionEnvironment, (Object)ORG_OSGI_FRAMEWORK_EXECUTIONENVIRONMENT), null);
        }
        if (this.requiredExecutionEnvironment.size() == this.initialRequiredExecutionEnvironmentSize) {
            this.state.setPlatformProperties(currentPlatformProperties);
            return Status.OK_STATUS;
        }
        Hashtable d2 = new Hashtable(d.size());
        Enumeration keys = d.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            ((Dictionary)d2).put(key, d.get(key));
        }
        StringBuffer sb = new StringBuffer();
        for (String executionEnvironment : this.requiredExecutionEnvironment) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(executionEnvironment);
        }
        ((Dictionary)d2).put(ORG_OSGI_FRAMEWORK_EXECUTIONENVIRONMENT, sb.toString());
        this.state.setPlatformProperties(new Dictionary[]{d2});
        return Status.OK_STATUS;
    }

    private BundleDescription addBundleDescription(BundleInfo info, File configDir) throws IOException, BundleException {
        Attributes attributes;
        String symbolicNameHeader;
        Manifest manifest;
        BundleDescription bundleDescription = null;
        URL bundleUrl = new URL(info.getLocation());
        String bundleUrlStr = bundleUrl.toString();
        if (bundleUrlStr.endsWith(CicConstants.getJarFileDotExt())) {
            manifest = this.getJarManifest(bundleUrl);
        } else {
            File file = new File(bundleUrl.getFile());
            file = new File(file.getCanonicalFile(), "META-INF/MANIFEST.MF");
            manifest = this.getFileManifest(file);
        }
        if (manifest == null) {
            manifest = this.getGeneratedManifest(info, configDir);
        } else {
            Attributes attributes2 = manifest.getMainAttributes();
            if (attributes2.getValue("Bundle-SymbolicName") == null) {
                manifest = this.getGeneratedManifest(info, configDir);
            }
        }
        String symbolicName = info.getSymbolicName();
        boolean doUpdate = false;
        if (manifest != null && (symbolicNameHeader = (attributes = manifest.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
            long bundleId;
            if (this.isSingleton(symbolicNameHeader)) {
                BundleDescription existingBundleDescription = (BundleDescription)this.idToDescription.get(symbolicName);
                if (existingBundleDescription != null) {
                    bundleId = existingBundleDescription.getBundleId();
                    doUpdate = true;
                } else {
                    bundleId = this.getNextBundleId();
                }
            } else {
                bundleId = this.getNextBundleId();
            }
            Dictionary d = this.getAttributeDictionary(attributes);
            bundleDescription = this.factory.createBundleDescription(this.state, d, bundleUrlStr, bundleId);
            this.addRequiredExecutionEnvironments(bundleDescription);
        }
        if (bundleDescription == null) {
            bundleDescription = this.factory.createBundleDescription((long)this.getNextBundleId(), symbolicName, new Version(info.getVersion()), bundleUrlStr, null, null, null, null, true, true, false, null, null, null, null);
        }
        boolean ignoreBundle = false;
        BundleDescription existingBundleDescription = this.idToDescription.put(symbolicName, bundleDescription);
        if (existingBundleDescription != null && existingBundleDescription.getVersion().compareTo(bundleDescription.getVersion()) > 0) {
            this.idToDescription.put(symbolicName, existingBundleDescription);
            if (doUpdate) {
                ignoreBundle = true;
            }
        }
        if (!ignoreBundle) {
            if (doUpdate) {
                this.state.updateBundle(bundleDescription);
            } else {
                this.state.addBundle(bundleDescription);
            }
        }
        return bundleDescription;
    }

    private boolean isSingleton(String symbolicNameHeader) throws BundleException {
        ManifestElement[] symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader);
        String singleton = symbolicNameElements[0].getDirective("singleton");
        if (singleton == null) {
            singleton = symbolicNameElements[0].getAttribute("singleton");
        }
        return "true".equals(singleton);
    }

    private Manifest getJarManifest(URL bundleUrl) {
        InputStream stream;
        try {
            stream = bundleUrl.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
        ZipInputStream zipStream = new ZipInputStream(stream);
        try {
            ZipEntry zipEntry;
            do {
                if ((zipEntry = zipStream.getNextEntry()) != null) continue;
                return null;
            } while (!zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest(zipStream);
            return manifest;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
    }

    private Manifest getFileManifest(File file) {
        block14: {
            try {
                if (file.isFile()) break block14;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            Manifest manifest = new Manifest(stream);
            return manifest;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
    }

    private Manifest getGeneratedManifest(BundleInfo info, File configDir) {
        String manifestName = String.valueOf(info.getSymbolicName()) + '_' + info.getVersion() + ".MF";
        File file = new File(configDir, "org.eclipse.osgi/manifests/" + manifestName);
        return this.getFileManifest(file);
    }

    private void initRequiredExecutionEnvironments() {
        String[] executionEnvironments;
        Dictionary[] currentPlatformProperties = this.platformAdmin.getState(false).getPlatformProperties();
        String execEnv = null;
        Dictionary d = null;
        if (currentPlatformProperties.length == 1) {
            d = currentPlatformProperties[0];
            execEnv = (String)d.get(ORG_OSGI_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (execEnv == null) {
            return;
        }
        String[] stringArray = executionEnvironments = execEnv.split(",");
        int n = executionEnvironments.length;
        int n2 = 0;
        while (n2 < n) {
            String executionEnvironment = stringArray[n2];
            this.requiredExecutionEnvironment.add(executionEnvironment);
            ++n2;
        }
        this.initialRequiredExecutionEnvironmentSize = this.requiredExecutionEnvironment.size();
    }

    private void addRequiredExecutionEnvironments(BundleDescription bundleDescription) {
        String[] executionEnvironments;
        String[] stringArray = executionEnvironments = bundleDescription.getExecutionEnvironments();
        int n = executionEnvironments.length;
        int n2 = 0;
        while (n2 < n) {
            String executionEnvironment = stringArray[n2];
            this.requiredExecutionEnvironment.add(executionEnvironment);
            ++n2;
        }
    }

    private Dictionary getAttributeDictionary(Attributes attributes) {
        Hashtable<String, String> d = new Hashtable<String, String>();
        Set<Map.Entry<Object, Object>> set = attributes.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            Set<String> predefinedAttrs;
            String name = ((Attributes.Name)entry.getKey()).toString();
            String value = (String)entry.getValue();
            if (this.doFilterArbitraryAttributes && (predefinedAttrs = HEADERS_WITH_ARBITRARY_ATTRS.get(name)) != null) {
                value = PlatformConfigurationState.filterArbitraryAttributes(name, value, predefinedAttrs);
            }
            ((Dictionary)d).put(name, value);
        }
        return d;
    }

    private BundleInfo getSystemBundle(BundleInfo[] infos) {
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if (OSGI_ID.equals(info.getSymbolicName())) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    public static String filterArbitraryAttributes(String value) {
        return PlatformConfigurationState.filterArbitraryAttributes("Require-Bundle", value, PREDEFINED_REQUIRE_BUNDLE_ATTRS);
    }

    private static String filterArbitraryAttributes(String name, String value, Set<String> predefinedAttrs) {
        if (value == null) {
            return null;
        }
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)name, (String)value);
        }
        catch (BundleException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        if (elements == null || elements.length == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        ManifestElement[] manifestElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            if (sb.length() != 0) {
                sb.append(',');
            }
            PlatformConfigurationState.filterArbitraryAttributes(sb, element, predefinedAttrs);
            ++n2;
        }
        return sb.toString();
    }

    private static void filterArbitraryAttributes(StringBuilder sb, ManifestElement element, Set<String> predefinedAttrs) {
        String key;
        sb.append(element.getValue());
        Enumeration attrKeys = element.getKeys();
        Enumeration directiveKeys = element.getDirectiveKeys();
        if (attrKeys == null && directiveKeys == null) {
            return;
        }
        if (attrKeys != null) {
            while (attrKeys.hasMoreElements()) {
                key = (String)attrKeys.nextElement();
                if (!predefinedAttrs.contains(key)) continue;
                PlatformConfigurationState.addValues(sb, false, key, element.getAttributes(key));
            }
        }
        if (directiveKeys != null) {
            while (directiveKeys.hasMoreElements()) {
                key = (String)directiveKeys.nextElement();
                PlatformConfigurationState.addValues(sb, true, key, element.getDirectives(key));
            }
        }
    }

    private static void addValues(StringBuilder sb, boolean directive, String key, String[] values) {
        if (values == null) {
            return;
        }
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            sb.append(';').append(key);
            if (directive) {
                sb.append(':');
            }
            sb.append('=');
            if (!directive) {
                sb.append('\"');
            }
            sb.append(value);
            if (!directive) {
                sb.append('\"');
            }
            ++n2;
        }
    }

    protected int getNextBundleId() {
        return this.nextId++;
    }

    private void indent() {
        this.currentIndent = String.valueOf(this.currentIndent) + "  ";
    }

    private void outdent() {
        this.currentIndent = this.currentIndent.substring(2);
    }

    private void dump(String s) {
        System.out.println(String.valueOf(this.currentIndent) + s);
    }

    private void dumpState() {
    }

    private void dumpBundles() {
        BundleDescription[] bundles = this.state.getBundles();
        int unresolvedCount = 0;
        int i = 0;
        while (i < bundles.length) {
            if (!bundles[i].isResolved()) {
                ++unresolvedCount;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Bundles (count=");
        sb.append(String.valueOf(bundles.length));
        if (unresolvedCount != 0) {
            sb.append(", unresolvedCount=");
            sb.append(String.valueOf(unresolvedCount));
        }
        sb.append("):");
        this.dump(sb.toString());
        this.indent();
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            this.dumpBundle(bundle);
            ++n2;
        }
        this.outdent();
    }

    private void dumpUnsatisfiedConstraints() {
        VersionConstraint[] constraints = this.state.getStateHelper().getUnsatisfiedLeaves(this.state.getBundles());
        this.dump("Unsatisfied Constraints (count=" + String.valueOf(constraints.length) + "):");
        this.indent();
        VersionConstraint[] versionConstraintArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            VersionConstraint constraint = versionConstraintArray[n2];
            this.dumpVersionConstraint(constraint);
            ++n2;
        }
        this.outdent();
    }

    private void dumpVersionConstraint(VersionConstraint constraint) {
        StringBuffer sb = new StringBuffer();
        sb.append(constraint.getBundle().getName());
        sb.append(' ');
        if (constraint instanceof BundleSpecification) {
            sb.append("Require-Bundle: ");
            sb.append(constraint.getName());
            sb.append(';');
            sb.append(constraint.getVersionRange());
        } else if (constraint instanceof GenericSpecification) {
            GenericSpecification gs = (GenericSpecification)constraint;
            sb.append(gs.getType());
            sb.append(": ");
            sb.append(gs.getMatchingFilter());
            int resolution = gs.getResolution();
            if ((resolution & 2) != 0) {
                sb.append(";multiple");
            }
            if ((resolution & 1) != 0) {
                sb.append(";optional");
            }
        } else if (constraint instanceof HostSpecification) {
            sb.append("Fragment-Host: ");
            sb.append(constraint.getName());
            sb.append(';');
            sb.append(constraint.getVersionRange());
        } else if (constraint instanceof ImportPackageSpecification) {
            sb.append("Import-Package: ");
            sb.append(constraint.getName());
        }
        this.dump(sb.toString());
    }

    private void dumpBundle(BundleDescription bundle) {
        StringBuffer sb = new StringBuffer();
        sb.append(bundle.getSymbolicName());
        sb.append(';');
        sb.append(bundle.getVersion().toString());
        if (!bundle.isResolved()) {
            String[] environments;
            sb.append(";unresolved");
            String[] stringArray = environments = bundle.getExecutionEnvironments();
            int n = environments.length;
            int n2 = 0;
            while (n2 < n) {
                String environment = stringArray[n2];
                sb.append(';');
                sb.append(environment);
                ++n2;
            }
        }
        this.dump(sb.toString());
        this.indent();
        this.dumpRequiredBundles(bundle);
        this.outdent();
    }

    private void dumpRequiredBundles(BundleDescription bundle) {
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        if (requiredBundles == null || requiredBundles.length == 0) {
            return;
        }
        this.dump("Required bundles (count=" + String.valueOf(requiredBundles.length) + "):");
        this.indent();
        BundleSpecification[] bundleSpecificationArray = requiredBundles;
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            this.dumpBundleSpecification(requiredBundle);
            ++n2;
        }
        this.outdent();
    }

    private void dumpBundleSpecification(BundleSpecification requiredBundle) {
        StringBuffer sb = new StringBuffer();
        sb.append(requiredBundle.getName());
        sb.append(';');
        sb.append(requiredBundle.getVersionRange().toString());
        if (requiredBundle.isExported()) {
            sb.append(";exported");
        }
        if (requiredBundle.isOptional()) {
            sb.append(";optional");
        }
        if (!requiredBundle.isResolved()) {
            sb.append(";unresolved");
        }
        this.dump(sb.toString());
    }
}

