/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.eclipse.qualification.JavaSystemProperties;
import com.ibm.cic.agent.internal.eclipse.qualification.PPNewProfileQualificationOperation;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.eclipseAdapter.update.configurator.ConfigurationActivator;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.preferences.PPSettings;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class NewProfileQualificationOperation {
    private static final Logger log = Logger.getLogger(NewProfileQualificationOperation.class);
    private final Profile profile;
    private final String exeSuffix = PPSettings.getPolicy().getExeSuffix();
    private ConfigurationEditor configEditor = null;
    private String existingEclipseWs;
    private String existingEclipseOs;
    private String existingEclipseArch;

    public NewProfileQualificationOperation(Profile profile) {
        this.profile = profile;
        this.existingEclipseWs = profile.getWS();
        this.existingEclipseOs = profile.getOS();
        this.existingEclipseArch = profile.getArch();
    }

    public IStatus qualifyNewProfile() {
        IStatus status = Status.OK_STATUS;
        String contextId = this.profile.getData("eclipseContext");
        if (contextId == null) {
            return status;
        }
        String eclipseLocation = this.profile.getEclipseLocation();
        if (eclipseLocation == null) {
            return status;
        }
        if (!this.profile.hasDifferentEclipseAndInstall()) {
            return status;
        }
        File eclipseDir = new File(eclipseLocation);
        File configDir = new File(eclipseDir, "configuration");
        status = this.checkForExistingEclipse(eclipseDir, configDir);
        if (!status.isOK()) {
            return status;
        }
        if (this.configEditor != null) {
            status = this.determineEclipseProperties(eclipseDir, this.configEditor);
            if (!status.isOK()) {
                return status;
            }
            this.profile.setProfileKind("existingEclipse");
            log.info("assuming profile " + this.profile.getProfileId() + " is potentially an existing eclipse installation");
            this.determineJreProperties(this.configEditor, eclipseDir);
            InstallContext eclipseContext = this.profile.findInstallContext(contextId);
            if (eclipseContext == null) {
                eclipseContext = new InstallContext((Object)this.profile.getRootContext(), contextId, "eclipse", "");
                eclipseContext.addAdaptorTypes(new String[]{"eclipse", "native"});
            }
            eclipseContext.setLocalProperty("installLocation", (Object)eclipseLocation);
            eclipseContext.setLocalProperty("configLocation", (Object)configDir.getPath());
        }
        return status;
    }

    public IStatus determineEclipseProperties() {
        IStatus status = Status.OK_STATUS;
        String contextId = this.profile.getData("eclipseContext");
        if (contextId == null) {
            return status;
        }
        String eclipseLocation = this.profile.getEclipseLocation();
        if (eclipseLocation == null) {
            return status;
        }
        File eclipseDir = new File(eclipseLocation);
        File configDir = new File(eclipseDir, "configuration");
        try {
            this.configEditor = new ConfigurationEditor(configDir, PlatformUtils.getLauncherLocation((File)eclipseDir), null);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        File platformXmlFile = new File(configDir, "org.eclipse.update/platform.xml");
        long lastTimestamp = 0L;
        try {
            lastTimestamp = Long.parseLong(this.profile.getData("platformXMLtimestamp"));
        }
        catch (NumberFormatException numberFormatException) {}
        long curTimestamp = platformXmlFile.lastModified();
        if (this.configEditor != null) {
            if (lastTimestamp != curTimestamp && !(status = this.determineEclipseProperties(eclipseDir, this.configEditor)).isOK()) {
                return status;
            }
            status = this.determineJreProperties(this.configEditor, eclipseDir);
            if (!status.isOK()) {
                return status;
            }
        }
        this.profile.setData("platformXMLtimestamp", String.valueOf(curTimestamp));
        return status;
    }

    public String getExistingEclipseWs() {
        return this.existingEclipseWs;
    }

    public String getExistingEclipseOs() {
        return this.existingEclipseOs;
    }

    public String getExistingEclipseArch() {
        return this.existingEclipseArch;
    }

    private IStatus checkForExistingEclipse(File eclipseDir, File configDir) {
        IStatus status = Status.OK_STATUS;
        if (!configDir.isDirectory()) {
            return status;
        }
        File configIni = new File(configDir, "config.ini");
        if (!configIni.isFile()) {
            return status;
        }
        try {
            this.configEditor = new ConfigurationEditor(configDir, PlatformUtils.getLauncherLocation((File)eclipseDir), null);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return status;
    }

    private String getJreVersion(String javaExeLocation) {
        String jreVersion = "";
        try {
            String[] cmdArray = new String[]{javaExeLocation, "-version"};
            StringWriter out = new StringWriter(512);
            StringWriter err = new StringWriter();
            int status = PlatformUtils.runProcess((String[])cmdArray, null, null, (Writer)out, (Writer)err);
            if (status == 0) {
                String outString = out.toString();
                String errString = err.toString();
                if (outString.length() > 0 && errString.length() > 0) {
                    jreVersion = String.valueOf(outString) + '\n' + errString;
                } else if (outString.length() > 0) {
                    jreVersion = outString;
                } else if (errString.length() > 0) {
                    jreVersion = errString;
                }
                if (jreVersion.length() > 0) {
                    log.info(jreVersion);
                    if (jreVersion.indexOf(10) > 0) {
                        jreVersion = jreVersion.substring(0, jreVersion.indexOf(10));
                    }
                    if (jreVersion.indexOf(13) > 0) {
                        jreVersion = jreVersion.substring(0, jreVersion.indexOf(13));
                    }
                }
            }
        }
        catch (Throwable e) {
            ExceptionUtil.debugLog((Throwable)e);
        }
        return jreVersion;
    }

    private String invokeJavaExe(ArrayList cmdList) {
        String[] cmdArray = cmdList.toArray(new String[cmdList.size()]);
        StringWriter out = new StringWriter(512);
        StringWriter err = new StringWriter();
        int status = PlatformUtils.runProcess((String[])cmdArray, null, null, (Writer)out, (Writer)err);
        String outString = out.toString();
        String errString = err.toString();
        if (status != 0 || outString.length() == 0 || errString.length() != 0) {
            log.error(NLS.bind((String)Messages.NewProfileQualificationOperation_existingJreInvocationFailed, (Object[])new Object[]{cmdArray[0], status, errString}));
            log.info("command args: " + cmdList.toString());
            return "";
        }
        return outString;
    }

    private IStatus determineJreProperties(ConfigurationEditor editor, File eclipseDir) {
        String[] properties;
        String vmLocation = editor.getVMLocation();
        ArrayList vmArgs = editor.getVMArgList();
        File adapterLocation = this.getAdapterLocation();
        String javaExeLocation = this.getJavaExeLocation(eclipseDir, vmLocation, adapterLocation);
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(javaExeLocation);
        cmdList.addAll(vmArgs);
        cmdList.add("-classpath");
        cmdList.add(adapterLocation.getPath());
        cmdList.add(JavaSystemProperties.class.getName());
        String outString = this.invokeJavaExe(cmdList);
        if (outString.length() == 0) {
            log.warning(Messages.NewProfileQualificationOperation_retryingJreInvocation, new Object[]{javaExeLocation});
            cmdList.removeAll(vmArgs);
            outString = this.invokeJavaExe(cmdList);
        }
        if (outString.length() == 0) {
            return new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", NLS.bind((String)Messages.NewProfileQualificationOperation_existingJVMIncompatibilty, (Object[])new Object[]{this.getJreVersion(javaExeLocation), javaExeLocation, eclipseDir}));
        }
        HashSet<String> javaProperties = new HashSet<String>(Arrays.asList(JavaSystemProperties.JAVA_SYSTEM_PROPERTIES));
        javaProperties.addAll(Arrays.asList(JavaSystemProperties.NON_STANDARD_JAVA_SYSTEM_PROPERTIES));
        String[] stringArray = properties = outString.split("\n");
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            String[] nameAndValue = property.split("=", 2);
            if (nameAndValue.length == 2) {
                String name = nameAndValue[0];
                String value = nameAndValue[1].trim();
                if (javaProperties.contains(name)) {
                    this.profile.setData("existing.jre.for.eclipse.ide." + name, value);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private String getJavaExeLocation(File eclipseDir, String vmLocation, File adapterLocation) {
        String javaExeLocation;
        File vmFile;
        String exeSimpleName = "java" + this.exeSuffix;
        if (vmLocation == null) {
            vmFile = new File(eclipseDir, "jre/bin");
        } else {
            vmFile = new File(vmLocation);
            if (!vmFile.isAbsolute()) {
                vmFile = new File(eclipseDir, vmLocation);
                try {
                    vmFile = vmFile.getCanonicalFile();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        File javaExe = NewProfileQualificationOperation.getJavaExecutable(vmFile, exeSimpleName);
        if (javaExe == null && (javaExeLocation = PPNewProfileQualificationOperation.getPolicy().useExeOnPath(exeSimpleName, adapterLocation)) != null) {
            return javaExeLocation;
        }
        if (javaExe == null) {
            javaExe = new File(eclipseDir, "jre/bin/" + exeSimpleName);
        }
        try {
            javaExeLocation = javaExe.getCanonicalPath();
        }
        catch (IOException iOException) {
            javaExeLocation = javaExe.getPath();
        }
        return javaExeLocation;
    }

    public static File getJavaExecutable(File vmLocation, String javaExeName) {
        File possibleJavaExe;
        if (vmLocation == null) {
            return null;
        }
        assert (vmLocation.isAbsolute());
        File javaExecutable = null;
        javaExecutable = vmLocation.isDirectory() ? ((possibleJavaExe = new File(vmLocation, javaExeName)).isFile() ? possibleJavaExe : ((possibleJavaExe = new File(vmLocation, "bin" + File.separator + javaExeName)).isFile() ? possibleJavaExe : NewProfileQualificationOperation.getJavaExecutable(vmLocation.getParentFile(), javaExeName))) : NewProfileQualificationOperation.getJavaExecutable(vmLocation.getParentFile(), javaExeName);
        return javaExecutable;
    }

    private File getAdapterLocation() {
        File outputDir;
        File adapterLocation = new File(PlatformUtils.getInstallLocation((Bundle)ConfigurationActivator.getBundleContext().getBundle()));
        if (adapterLocation.isDirectory() && (outputDir = new File(adapterLocation, "bin")).isDirectory()) {
            adapterLocation = outputDir;
        }
        return adapterLocation;
    }

    private IStatus determineEclipseProperties(File eclipseDir, ConfigurationEditor editor) {
        Properties productProperties;
        String platformFeatureId = NewProfileQualificationOperation.getPlatformFeatureId();
        Version version = editor.findFeatureVersion(platformFeatureId);
        if (version != null) {
            this.profile.setData("existing.eclipse.ide.platform.version", version.toString());
        }
        if ((productProperties = this.findProductProperties(eclipseDir)) != null) {
            this.setEclipseProductProperties(productProperties);
        }
        this.determineEclipsePlatformProperties(editor);
        return Status.OK_STATUS;
    }

    static String getPlatformFeatureId() {
        String featureId = System.getProperty("eclipse.ide.platform.feature.id", "org.eclipse.platform");
        return featureId;
    }

    private Properties findProductProperties(File eclipseDir) {
        File productFile = new File(eclipseDir, ".eclipseproduct");
        if (!productFile.isFile()) {
            return null;
        }
        Properties props = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(productFile);
                props.load(stream);
            }
            catch (IOException iOException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException2) {
                        return null;
                    }
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return props;
    }

    private void setEclipseProductProperties(Properties productProperties) {
        String productVersion;
        String productName;
        String productId = productProperties.getProperty("id");
        if (productId != null) {
            this.profile.setData("existing.eclipseproduct.id", productId);
        }
        if ((productName = productProperties.getProperty("name")) != null) {
            this.profile.setData("existing.eclipseproduct.name", productName);
        }
        if ((productVersion = productProperties.getProperty("version")) != null) {
            this.profile.setData("existing.eclipseproduct.version", productVersion);
        }
    }

    private void determineEclipsePlatformProperties(ConfigurationEditor editor) {
        String[] segments;
        int i;
        Properties properties = editor.getProperties();
        String ws = properties.getProperty("osgi.ws");
        String os = properties.getProperty("osgi.os");
        String arch = properties.getProperty("osgi.arch");
        if (ws != null && os != null && arch != null) {
            this.existingEclipseWs = ws;
            this.existingEclipseOs = os;
            this.existingEclipseArch = arch;
            return;
        }
        String launcherLibraryId = this.findLauncherLibraryId(editor);
        if (launcherLibraryId != null && (i = (segments = launcherLibraryId.split("\\.")).length) > 3) {
            this.existingEclipseArch = segments[--i];
            this.existingEclipseOs = segments[--i];
            this.existingEclipseWs = segments[--i];
        }
    }

    private String findLauncherLibraryId(ConfigurationEditor editor) {
        ArrayList args = editor.getProgramArgumentList();
        int i = args.indexOf("--launcher.library");
        if (i >= 0 && ++i < args.size()) {
            File launcherLibraryLocation = new File((String)args.get(i));
            String launcherLibrary = launcherLibraryLocation.getName();
            Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)launcherLibrary);
            String id = (String)idAndVersion[0];
            return id;
        }
        List launcherLibraryBundleIds = editor.findLauncherLibraryBundleIds();
        if (launcherLibraryBundleIds.size() == 1) {
            return (String)launcherLibraryBundleIds.get(0);
        }
        return null;
    }
}

