/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.pages.licensePanel;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ConPager {
    private final int width;
    private final int height;
    private List<Page> pages;
    private String text;
    private Locale locale;

    public ConPager() {
        this(80, 20);
    }

    public ConPager(int width, int height) {
        this.width = width;
        this.height = height;
        this.pages = new ArrayList<Page>();
    }

    public void setText(Locale locale, String text) {
        this.locale = locale;
        this.text = text;
        this.pages = new ArrayList<Page>();
        new Paginate();
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public List<String> getLinesOfPage(int pageNumber) {
        ArrayList<String> lines = new ArrayList<String>(this.height);
        Page page = this.pages.get(pageNumber - 1);
        LineOffsets[] lineOffsetsArray = page.lines;
        int n = page.lines.length;
        int n2 = 0;
        while (n2 < n) {
            LineOffsets line = lineOffsetsArray[n2];
            lines.add(this.text.substring(line.start, line.end));
            ++n2;
        }
        return Collections.unmodifiableList(lines);
    }

    private class LineOffsets {
        public int start;
        public int end;

        public LineOffsets(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "[" + ConPager.this.text.substring(this.start, this.end) + "]";
        }
    }

    private static class Page {
        public LineOffsets[] lines;

        public Page(LineOffsets[] lines) {
            this.lines = lines;
        }
    }

    private class Paginate {
        private final ArrayList<LineOffsets> lines;
        private final BreakIterator lb;
        private final BreakIterator cb;
        public static final char CR = '\r';
        public static final char LF = '\n';

        public Paginate() {
            this.lb = BreakIterator.getLineInstance((Locale)ConPager.this.locale);
            this.cb = BreakIterator.getCharacterInstance((Locale)ConPager.this.locale);
            this.lines = new ArrayList(ConPager.this.height);
            List<LineOffsets> hardLines = this.getHardLines();
            for (LineOffsets line : hardLines) {
                if (this.countCharacters(line.toString()) <= ConPager.this.width) {
                    this.addLine(line);
                    continue;
                }
                this.paginateLine(line);
            }
            if (this.lines.size() > 0) {
                ConPager.this.pages.add(new Page(this.lines.toArray(new LineOffsets[this.lines.size()])));
            }
        }

        private void paginateLine(LineOffsets longLine) {
            String strLongLine = longLine.toString();
            this.lb.setText(strLongLine);
            LineOffsets previousCandidate = new LineOffsets(longLine.start, longLine.start);
            int pos = 0;
            int loc = -1;
            loc = this.lb.first();
            while (loc != -1) {
                String line = strLongLine.substring(pos, loc);
                if (this.countCharacters(line) > ConPager.this.width) {
                    LineOffsets lineToAdd = null;
                    lineToAdd = previousCandidate.end != previousCandidate.start ? previousCandidate : new LineOffsets(longLine.start + pos, longLine.start + loc - 1);
                    pos = lineToAdd.end - longLine.start;
                    previousCandidate = new LineOffsets(longLine.start + pos, longLine.start + pos);
                    this.addLine(lineToAdd);
                } else {
                    previousCandidate.start = longLine.start + pos;
                    previousCandidate.end = loc > pos ? longLine.start + loc - 1 : longLine.start + pos;
                }
                loc = this.lb.next();
            }
            if (longLine.start + pos < longLine.end) {
                this.addLine(new LineOffsets(longLine.start + pos, longLine.end));
            }
        }

        private void addLine(LineOffsets line) {
            if (this.lines.size() == ConPager.this.height) {
                ConPager.this.pages.add(new Page(this.lines.toArray(new LineOffsets[this.lines.size()])));
                this.lines.clear();
            }
            this.lines.add(line);
        }

        private List<LineOffsets> getHardLines() {
            int len = ConPager.this.text.length();
            LinkedList<LineOffsets> lineOffsets = new LinkedList<LineOffsets>();
            int start = 0;
            int i = 0;
            while (i < len) {
                char c = ConPager.this.text.charAt(i);
                if (c == '\r') {
                    int nl = i;
                    if (i + 1 < len && (c = ConPager.this.text.charAt(i + 1)) == '\n') {
                        ++i;
                    }
                    lineOffsets.add(new LineOffsets(start, nl));
                    start = i + 1;
                } else if (c == '\n') {
                    lineOffsets.add(new LineOffsets(start, i));
                    start = i + 1;
                }
                ++i;
            }
            if (start < len) {
                lineOffsets.add(new LineOffsets(start, len));
            }
            return lineOffsets;
        }

        private int countCharacters(String line) {
            this.cb.setText(line);
            int count = 0;
            int loc = this.cb.first();
            while (loc != -1) {
                ++count;
                loc = this.cb.next();
            }
            return count;
        }
    }
}

