/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.eclipse.internals.update.configurator;

import com.ibm.cic.eclipse.internals.update.configurator.Utils;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ConfigurationActivator
implements BundleActivator {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String INSTALL_LOCATION = "osgi.installLocation";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    public static String OPTION_DEBUG = String.valueOf(PI_CONFIGURATOR) + "/debug";
    public static boolean DEBUG = false;
    private static BundleContext context;

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.loadOptions();
        this.acquireFrameworkLogService();
    }

    public void stop(BundleContext ctx) throws Exception {
        Utils.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshPackages(Bundle[] bundles, BundleContext bundlleContext) {
        if (bundles == null || bundles.length == 0) {
            return;
        }
        ServiceReference packageAdminRef = bundlleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)bundlleContext.getService(packageAdminRef)) == null) {
            return;
        }
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        bundlleContext.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (true) {
                if (flag[0]) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    break;
                }
                try {
                    flag.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            bundlleContext.removeFrameworkListener(listener);
            bundlleContext.ungetService(packageAdminRef);
            return;
        }
    }

    private void loadOptions() {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    private void acquireFrameworkLogService() throws Exception {
        ServiceReference logServiceReference = context.getServiceReference(FrameworkLog.class.getName());
        if (logServiceReference == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(logServiceReference);
    }
}

