/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.AIXSystemDumpSettingsChecker;
import com.ibm.java.diagnostics.collector.CommandLineDumpOptionChecker;
import com.ibm.java.diagnostics.collector.DCUlimitCheck;
import com.ibm.java.diagnostics.collector.DumpDescriptor;
import com.ibm.java.diagnostics.collector.DumpEvent;
import com.ibm.java.diagnostics.collector.EnvVarChecker;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.SystemPropertyChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticsConfigChecker {
    private Logger logger;
    private DumpEvent de;
    private String lineSep;
    private DumpDescriptor[] dda;

    public DiagnosticsConfigChecker(DumpEvent de, DumpDescriptor[] dda, Logger logger) {
        this.de = de;
        this.logger = logger;
        if (dda != null) {
            DumpDescriptor[] ddaCopy = new DumpDescriptor[dda.length];
            System.arraycopy(dda, 0, ddaCopy, 0, dda.length);
            this.dda = ddaCopy;
        } else {
            this.dda = null;
        }
        this.lineSep = System.getProperty("line.separator");
    }

    public void check() {
        this.logger.fine("Java Diagnostics Collector running Diagnostics Config Check for event " + this.de.getEvent());
        this.doUlimitCheck();
        this.doAIXSystemDumpSettingsCheck();
        this.doEnvVarCheck();
        this.doCommandLineOptionCheck();
    }

    private void doCommandLineOptionCheck() {
        this.logger.config(Messages.getString("DiagnosticsConfigChecker.0"));
        DumpDescriptor javadump = null;
        for (DumpDescriptor d : this.dda) {
            if (d == null || d.getDumpType() != DumpDescriptor.DumpType.JAVA) continue;
            javadump = d;
        }
        if (javadump != null) {
            Collection<String> options = this.collectCommandLineOptions(javadump.getFile());
            this.reportCmdLineOptionCheck(options);
            this.reportSystemPropertyCheck(options);
        } else {
            this.logger.config(Messages.getString("DiagnosticsConfigChecker.1"));
        }
    }

    private void reportSystemPropertyCheck(Collection<String> options) {
        Map<String, String> systemPropertyMap = this.getSystemPropertyMapFromCmdLine(options);
        SystemPropertyChecker sPChk = new SystemPropertyChecker(this.logger, systemPropertyMap);
        this.logger.config(Messages.getString("DiagnosticsConfigChecker.2") + this.lineSep + sPChk.getConfigReport() + this.lineSep);
        if (sPChk.riskFound()) {
            String warningReport = sPChk.getWarningReport();
            StringBuffer sb = new StringBuffer(Messages.getString("DiagnosticsConfigChecker.3") + this.lineSep);
            sb.append(warningReport);
            this.logger.warning(sb.toString());
        }
    }

    private Map<String, String> getSystemPropertyMapFromCmdLine(Collection<String> options) {
        Hashtable<String, String> pMap = new Hashtable<String, String>();
        if (options == null) {
            return null;
        }
        for (String o : options) {
            if (o == null || !o.startsWith("-D")) continue;
            String pName = null;
            String pVal = null;
            int eq = o.indexOf("=");
            if (eq > 2 && eq < o.length() - 1) {
                pName = o.substring(2, eq);
                pVal = o.substring(eq + 1);
                if (pVal.startsWith("\"") && pVal.endsWith("\"")) {
                    pVal = pVal.substring(1, pVal.length() - 1);
                }
            }
            if (pName == null || pVal == null) continue;
            pMap.put(pName, pVal);
        }
        return pMap;
    }

    private void reportCmdLineOptionCheck(Collection<String> options) {
        CommandLineDumpOptionChecker chk = new CommandLineDumpOptionChecker(this.logger, options);
        Level priority = chk.getReportPriority();
        if (priority == null) {
            priority = Level.CONFIG;
        }
        String report = chk.getReport();
        StringBuffer sb = new StringBuffer(Messages.getString("DiagnosticsConfigChecker.4") + this.lineSep);
        sb.append(report);
        this.logger.log(priority, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> collectCommandLineOptions(File javacore) {
        if (javacore == null) {
            this.logger.fine("null passed to getCustomDumpTargets");
            return null;
        }
        if (!javacore.exists()) {
            return null;
        }
        if (!javacore.canRead()) {
            String msg = MessageFormat.format("{0}{1} {2} {3} {4}", "Java Diagnostics Collector", Messages.getString("DiagnosticsConfigChecker.5"), javacore.getAbsolutePath(), Messages.getString("DiagnosticsConfigChecker.6"), System.getProperty("user.name"));
            this.logger.warning(msg);
            return null;
        }
        this.logger.fine("Search java dump for command line options: " + javacore.getPath());
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(javacore));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String msg = MessageFormat.format("{0}{1} {2}", "Java Diagnostics Collector", Messages.getString("DiagnosticsConfigChecker.7"), javacore.getAbsolutePath());
            this.logger.warning(msg);
            return null;
        }
        try {
            String line = null;
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                String msg = MessageFormat.format("{0}{1} {2} {3}", "Java Diagnostics Collector", Messages.getString("DiagnosticsConfigChecker.8"), javacore.getAbsolutePath(), e.getLocalizedMessage());
                this.logger.warning(msg);
            }
            HashSet<String> options = new HashSet<String>();
            while (line != null) {
                String opt = this.getOptionFromJavacoreLine(line);
                if (opt != null) {
                    options.add(opt);
                }
                try {
                    line = br.readLine();
                }
                catch (IOException e) {
                    this.logger.log(Level.FINE, "Java Diagnostics Collector: IOException while trying to read a line from " + javacore.getAbsolutePath(), e);
                }
            }
            HashSet<String> hashSet = options;
            return hashSet;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, "Java Diagnostics Collector: IOException while trying to close " + javacore.getAbsolutePath(), e);
            }
        }
    }

    private String getOptionFromJavacoreLine(String line) {
        String option = null;
        if (line != null && line.startsWith("2CIUSERARG") && line.contains("-")) {
            String trimmedLine = line.trim();
            int start = trimmedLine.indexOf("-");
            option = trimmedLine.substring(start);
        }
        return option;
    }

    private void doUlimitCheck() {
        DCUlimitCheck ulimitCheck = new DCUlimitCheck(this.logger);
        if (ulimitCheck.appliesToPlatform()) {
            Level priority = ulimitCheck.getUlimitReportPriority();
            String report = ulimitCheck.getReport();
            this.logger.log(priority, report);
        }
    }

    private void doAIXSystemDumpSettingsCheck() {
        AIXSystemDumpSettingsChecker aixCheck = new AIXSystemDumpSettingsChecker(this.logger);
        if (aixCheck.appliesToPlatform()) {
            Level priority = aixCheck.getReportPriority();
            String report = aixCheck.getReport();
            this.logger.log(priority, report);
        }
    }

    private void doEnvVarCheck() {
        EnvVarChecker envCheck = new EnvVarChecker(this.logger);
        this.logger.config(envCheck.getConfigReport());
        if (envCheck.riskFound()) {
            this.logger.warning(envCheck.getWarningReport());
        }
        this.logger.config(Messages.getString("DiagnosticsConfigChecker.9") + this.lineSep + this.lineSep + envCheck.getEnvVarList());
    }
}

