/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;
    private int c;
    private static final byte[] d;
    private static final String[] z;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        int n2;
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException(z[2]);
        }
        byte[] byArray = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        if (byArray != null) {
            if (byArray.length != 8) {
                throw new InvalidParameterSpecException(z[1]);
            }
            this.a = (byte[])byArray.clone();
        }
        if ((n2 = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()) < 1 || n2 > 1024) {
            throw new InvalidParameterSpecException(z[0]);
        }
        this.c = n2;
        this.b = n2 >= 256 ? n2 : this.a(n2);
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        byte[] byArray2;
        block8: {
            byArray2 = null;
            try {
                DerValue derValue = new DerValue(byArray);
                if (derValue.getTag() == 4) {
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(z[8]);
                    }
                    this.b = this.a(32);
                    this.c = 32;
                    break block8;
                }
                if (derValue.getTag() == 48) {
                    int n2 = derValue.getData().getInteger().intValue();
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(z[10]);
                    }
                    if (n2 < 1 || n2 > 1024) {
                        throw new IOException(z[12]);
                    }
                    this.c = n2 >= 256 ? n2 : this.b(n2);
                    this.b = n2;
                    break block8;
                }
                throw new IOException(z[7] + derValue.getTag() + z[9]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(z[11]);
            }
        }
        if (byArray2.length != 8) {
            throw new IOException(z[1]);
        }
        this.a = byArray2;
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName(z[6]);
            if (clazz2.isAssignableFrom(clazz)) {
                if (this.a == null) {
                    return new RC2ParameterSpec(this.c);
                }
                return new RC2ParameterSpec(this.c, this.a);
            }
            throw new InvalidParameterSpecException(z[2]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[5] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.c == 32) {
            derOutputStream.putOctetString(this.a);
        } else {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.putOctetString(this.a);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String string = z[4];
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.a);
        string = string + "]";
        return z[3] + BigInteger.valueOf(this.c).toString() + "\n" + string;
    }

    private int a(int n2) {
        byte by = d[n2];
        if (by >= 0) {
            return by;
        }
        return by + 256;
    }

    private int b(int n2) throws IOException {
        int n3;
        for (n3 = 1; n3 < 256; ++n3) {
            int n4;
            int n5 = d[n3];
            int n6 = n4 = n5 >= 0 ? n5 : n5 + 256;
            if (n2 == n4) break;
        }
        if (n3 < 256) {
            return n3;
        }
        throw new IOException(z[13]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "2\u0015~\u0001\u0001\u0003\u001an\u0001B\u001c\u0016aD\u0011\u001e\t}D\u000b\u0004Sv\u000b\u0016W\u001avD\u0016\u001f\u00168\u0016\u0003\u0019\u0014}D\r\u0011S)DOWB(VVW\u0011q\u0010\u0011Y";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block25: {
                int n4;
                int n5;
                block24: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block24;
                    n5 = n5;
                    if (n5 <= n4) break block25;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 119;
                            break;
                        }
                        case 1: {
                            n6 = 115;
                            break;
                        }
                        case 2: {
                            n6 = 24;
                            break;
                        }
                        case 3: {
                            n6 = 100;
                            break;
                        }
                        default: {
                            n6 = 98;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ">%8\n\r\u0003S D\u0000\u000e\u0007}\u0017B\u001b\u001cv\u0003";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ">\u001dy\u0014\u0012\u0005\u001ch\u0016\u000b\u0016\u0007}D\u0012\u0016\u0001y\t\u0007\u0003\u0016jD\u0011\u0007\u0016{\r\u0004\u001e\u0010y\u0010\u000b\u0018\u001d";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2\u0015~\u0001\u0001\u0003\u001an\u0001B\u001c\u0016aD\u0000\u001e\u0007k^h";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "}S8DB>%\"n9";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\"\u001dk\u0011\u0012\u0007\u001cj\u0010\u0007\u0013Sh\u0005\u0010\u0016\u001e}\u0010\u0007\u0005Sk\u0014\u0007\u0014\u001a~\r\u0001\u0016\u0007q\u000b\fMS";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001d\u0012n\u0005\u001aY\u0010j\u001d\u0012\u0003\u001c6\u0017\u0012\u0012\u001066!E#y\u0016\u0003\u001a\u0016l\u0001\u0010$\u0003}\u0007";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "%0*D2\u0016\u0001y\t\u0007\u0003\u0016j\u0017B\u0007\u0012j\u0017\u000b\u0019\u00148\u0001\u0010\u0005\u001cj^B\u0003\u0012\u007fD";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ">%8\u0014\u0003\u0005\u0000q\n\u0005W\u0016j\u0016\r\u0005I8\u0001\u001a\u0003\u0001yD\u0006\u0016\u0007y";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "W\u001dw\u0010B\u0004\u0006h\u0014\r\u0005\u0007}\u0000";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "%0*D2\u0016\u0001y\t\u0007\u0003\u0016j\u0017B\u0007\u0012j\u0017\u000b\u0019\u00148\u0001\u0010\u0005\u001cj^B2\u000bl\u0016\u0003W\u0017y\u0010\u0003";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "%0*2\u0007\u0005\u0000q\u000b\fW\u001f}\n\u0005\u0003\u001b8\u0010\r\u0018Sz\r\u0005";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "%0*2\u0007\u0005\u0000q\u000b\fW\u001akD\f\u0018\u00078\r\fW\u0007p\u0001B\u0005\u0012v\u0003\u0007W\u001c~DSW^8UREG6";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "%0*2\u0007\u0005\u0000q\u000b\fW\u0010y\n\f\u0018\u00078\u0006\u0007W\u0015w\u0011\f\u0013Sq\nB\u0003\u001b}D\u0016\u0005\u0012v\u0017\u000e\u0016\u0007q\u000b\fW\u0007y\u0006\u000e\u0012]";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        d = new byte[]{-67, 86, -22, -14, -94, -15, -84, 42, -80, -109, -47, -100, 27, 51, -3, -48, 48, 4, -74, -36, 125, -33, 50, 75, -9, -53, 69, -101, 49, -69, 33, 90, 65, -97, -31, -39, 74, 77, -98, -38, -96, 104, 44, -61, 39, 95, -128, 54, 62, -18, -5, -107, 26, -2, -50, -88, 52, -87, 19, -16, -90, 63, -40, 12, 120, 36, -81, 35, 82, -63, 103, 23, -11, 102, -112, -25, -24, 7, -72, 96, 72, -26, 30, 83, -13, -110, -92, 114, -116, 8, 21, 110, -122, 0, -124, -6, -12, 127, -118, 66, 25, -10, -37, -51, 20, -115, 80, 18, -70, 60, 6, 78, -20, -77, 53, 17, -95, -120, -114, 43, -108, -103, -73, 113, 116, -45, -28, -65, 58, -34, -106, 14, -68, 10, -19, 119, -4, 55, 107, 3, 121, -119, 98, -58, -41, -64, -46, 124, 106, -117, 34, -93, 91, 5, 93, 2, 117, -43, 97, -29, 24, -113, 85, 81, -83, 31, 11, 94, -123, -27, -62, 87, 99, -54, 61, 108, -76, -59, -52, 112, -78, -111, 89, 13, 71, 32, -56, 79, 88, -32, 1, -30, 22, 56, -60, 111, 59, 15, 101, 70, -66, 126, 45, 123, -126, -7, 64, -75, 29, 115, -8, -21, 38, -57, -121, -105, 37, 84, -79, 40, -86, -104, -99, -91, 100, 109, 122, -44, 16, -127, 68, -17, 73, -42, -82, 46, -35, 118, 92, 47, -89, 28, -55, 9, 105, -102, -125, -49, 41, 57, -71, -23, 76, -1, 67, -85};
    }
}

