/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.PKCS5DerivedKeySpec;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class PKCS5DerivedKey
implements SecretKey {
    static final long serialVersionUID = 463050993315590179L;
    private String IBM_PROVIDER = z[4];
    private byte[] key;
    private byte[] pwd;
    private byte[] salt;
    private int iCount;
    private int keyLen;
    private String encrFunction;
    private String algorithm;
    private Mac prf;
    private static final String[] z;

    public PKCS5DerivedKey(PKCS5DerivedKeySpec pKCS5DerivedKeySpec) throws InvalidKeySpecException {
        char[] cArray = pKCS5DerivedKeySpec.getPassword();
        this.pwd = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            this.pwd[i2] = (byte)(cArray[i2] & 0x7F);
        }
        Arrays.fill(cArray, ' ');
        this.salt = pKCS5DerivedKeySpec.getSalt();
        this.iCount = pKCS5DerivedKeySpec.getIterationCount();
        this.keyLen = pKCS5DerivedKeySpec.getKeyLength();
        this.encrFunction = pKCS5DerivedKeySpec.getEncryptionFunction();
        this.algorithm = pKCS5DerivedKeySpec.getEncryptionFunction();
        this.key = this.encrFunction.equals(z[2]) || this.encrFunction.equals(z[0]) || this.encrFunction.equals(z[3]) ? this.a() : this.b();
        if (this.key == null) {
            throw new InvalidKeySpecException(z[1]);
        }
    }

    private byte[] a() {
        MessageDigest messageDigest;
        byte[] byArray = new byte[this.pwd.length + this.salt.length];
        System.arraycopy(this.pwd, 0, byArray, 0, this.pwd.length);
        System.arraycopy(this.salt, 0, byArray, this.pwd.length, this.salt.length);
        try {
            messageDigest = MessageDigest.getInstance(this.encrFunction, this.IBM_PROVIDER);
        }
        catch (Exception exception) {
            try {
                messageDigest = MessageDigest.getInstance(this.encrFunction);
            }
            catch (Exception exception2) {
                return null;
            }
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        for (int i2 = 1; i2 < this.iCount; ++i2) {
            messageDigest.update(byArray2);
            byArray2 = messageDigest.digest();
        }
        Arrays.fill(byArray, (byte)0);
        byte[] byArray3 = new byte[this.keyLen];
        System.arraycopy(byArray2, 0, byArray3, 0, this.keyLen);
        return byArray3;
    }

    private byte[] b() throws InvalidKeySpecException {
        try {
            this.prf = Mac.getInstance(this.encrFunction);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchAlgorithmException);
            throw invalidKeySpecException;
        }
        byte[] byArray = new byte[this.keyLen];
        int n2 = this.keyLen;
        try {
            int n3 = this.prf.getMacLength();
            int n4 = (n2 + n3 - 1) / n3;
            int n5 = n2 - (n4 - 1) * n3;
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n3];
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.pwd, this.prf.getAlgorithm());
            this.prf.init(secretKeySpec);
            byte[] byArray4 = new byte[4];
            for (int i2 = 1; i2 <= n4; ++i2) {
                this.prf.update(this.salt);
                byArray4[3] = (byte)i2;
                byArray4[2] = (byte)(i2 >> 8 & 0xFF);
                byArray4[1] = (byte)(i2 >> 16 & 0xFF);
                byArray4[0] = (byte)(i2 >> 24 & 0xFF);
                this.prf.update(byArray4);
                this.prf.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                for (int i3 = 2; i3 <= this.iCount; ++i3) {
                    this.prf.update(byArray2);
                    this.prf.doFinal(byArray2, 0);
                    for (int i4 = 0; i4 < byArray2.length; ++i4) {
                        int n6 = i4;
                        byArray3[n6] = (byte)(byArray3[n6] ^ byArray2[i4]);
                    }
                }
                if (i2 == n4) {
                    System.arraycopy(byArray3, 0, byArray, (i2 - 1) * n3, n5);
                    continue;
                }
                System.arraycopy(byArray3, 0, byArray, (i2 - 1) * n3, n3);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(z[6]);
        }
        return byArray;
    }

    protected void finalize() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (this.pwd != null) {
            Arrays.fill(this.pwd, (byte)0);
            this.pwd = null;
        }
    }

    public synchronized byte[] getEncodedKey() {
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOctetString(this.key);
            derOutputStream.putOctetString(this.pwd);
            derOutputStream.putOctetString(this.salt);
            derOutputStream.putInteger(BigInteger.valueOf(this.iCount));
            derOutputStream.putInteger(BigInteger.valueOf(this.keyLen));
            derOutputStream.putPrintableString(this.encrFunction);
        }
        catch (IOException iOException) {
            return null;
        }
        return derOutputStream.toByteArray();
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    public String getEncryptionFunction() {
        return new String(this.encrFunction);
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getFormat() {
        return z[5];
    }

    public int hashCode() {
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < this.key.length; ++n2) {
            n3 += this.key[n2] * n2;
        }
        for (n2 = 1; n2 < this.salt.length; ++n2) {
            n3 += this.salt[n2] * n2;
        }
        n3 ^= this.iCount;
        n3 ^= this.keyLen;
        return n3 ^= this.getEncryptionFunction().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        byte[] byArray = secretKey.getEncoded();
        boolean bl = Arrays.equals(this.getEncoded(), byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "c\u001d\u0012";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 46;
                            break;
                        }
                        case 1: {
                            n6 = 89;
                            break;
                        }
                        case 2: {
                            n6 = 39;
                            break;
                        }
                        case 3: {
                            n6 = 94;
                            break;
                        }
                        default: {
                            n6 = 119;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "e<^~\u0012@:U'\u0007Z0H0WO5@1\u0005G-O3W@6S~\u0011A,I:";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "c\u001d\u0015";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "}\u0011fo";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "g\u001bj\u00144k";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "~\u0012d\rBq\u001db\f>x\u001cc\u0001<k\u0000";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "k+U1\u0005\u000e=B,\u001eX0I9W~\u001bl\u001a1\u001cyL;\u000e]";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

