/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.xc;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class ECPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.ECPrivateKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962695L;
    private BigInteger s;
    private ECParameterSpec params;
    private static final String[] z;

    public ECPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public ECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.s = bigInteger;
        this.params = eCParameterSpec;
        AlgorithmParameters algorithmParameters = xc.a(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, algorithmParameters);
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            byte[] byArray = xc.a(bigInteger.toByteArray());
            derOutputStream.putOctetString(byArray);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    protected void parseKeyBits() throws IOException {
        try {
            Object object;
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException(z[1]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            int n2 = derInputStream2.getInteger().intValue();
            if (n2 != 1) {
                throw new IOException(z[4]);
            }
            byte[] byArray = derInputStream2.getOctetString();
            this.s = new BigInteger(1, byArray);
            while (derInputStream2.available() != 0) {
                object = derInputStream2.getDerValue();
                if (object.isContextSpecific((byte)0) || object.isContextSpecific((byte)1)) continue;
                throw new IOException(z[3] + object);
            }
            object = this.algid.getAlgParameters();
            if (object == null) {
                throw new IOException(z[0]);
            }
            this.params = ((AlgorithmParameters)object).getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException iOException) {
            throw new IOException(z[2]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[2]);
        }
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0000l\u0014L\u001b(N]FT5NFI\u0019 [QZ\u0007eBA[\u0000eMQ\b\u0011+L[L\u0011!\u000f]FT1GQ\b\u0015)H[Z\u001d1GY\b\u001d!JZ\\\u001d#FQZ";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                block15: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block15;
                    n5 = n5;
                    if (n5 <= n4) break block16;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 69;
                            break;
                        }
                        case 1: {
                            n6 = 47;
                            break;
                        }
                        case 2: {
                            n6 = 52;
                            break;
                        }
                        case 3: {
                            n6 = 40;
                            break;
                        }
                        default: {
                            n6 = 116;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000b@@\b\u0015e|qy!\u0000awm";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\fABI\u0018,K\u0014m7e_FA\u0002$[Q\b\u001f V";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0010AQP\u0004 L@M\u0010eYUD\u0001 \u0015\u0014";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0013JF[\u001d*A\u0014E\u00016[\u0014J\u0011e\u001e";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

