/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.wc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[3]);
        }
        this.a = n2;
        this.b = secureRandom;
        this.c = null;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
                if (this.c == null) {
                    throw new InvalidAlgorithmParameterException(z[1]);
                }
                this.b = secureRandom;
                this.a = this.c.getCurve().getField().getFieldSize();
                return;
            }
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        this.c = (ECParameterSpec)algorithmParameterSpec;
        this.initialize(this.c.getCurve().getField().getFieldSize(), secureRandom);
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c);
            ECPublicKey eCPublicKey = new ECPublicKey(ECUtils.b(bigInteger, this.c.getGenerator(), this.c.getCurve()), this.c);
            KeyPair keyPair = new KeyPair(eCPublicKey, eCPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                ECFieldFp eCFieldFp = new ECFieldFp(wc.a);
                Object var2_6 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, wc.E.mod(wc.a), wc.c);
                this.c = new ECParameterSpec(ellipticCurve, wc.f, wc.b, 1);
                break;
            }
            case 224: {
                ECFieldFp eCFieldFp = new ECFieldFp(wc.g);
                Object var2_7 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, wc.E.mod(wc.g), wc.i);
                this.c = new ECParameterSpec(ellipticCurve, wc.l, wc.h, 1);
                break;
            }
            case 256: {
                ECFieldFp eCFieldFp = new ECFieldFp(wc.m);
                Object var2_8 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, wc.E.mod(wc.m), wc.o);
                this.c = new ECParameterSpec(ellipticCurve, wc.r, wc.n, 1);
                break;
            }
            case 384: {
                ECFieldFp eCFieldFp = new ECFieldFp(wc.s);
                Object var2_9 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, wc.E.mod(wc.s), wc.u);
                this.c = new ECParameterSpec(ellipticCurve, wc.x, wc.t, 1);
                break;
            }
            case 521: {
                ECFieldFp eCFieldFp = new ECFieldFp(wc.y);
                Object var2_10 = null;
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, wc.E.mod(wc.y), wc.A);
                this.c = new ECParameterSpec(ellipticCurve, wc.D, wc.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0016\u0011&zL<&\u0019L{>=\u000fFD";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 95;
                            break;
                        }
                        case 1: {
                            n6 = 83;
                            break;
                        }
                        case 2: {
                            n6 = 107;
                            break;
                        }
                        case 3: {
                            n6 = 41;
                            break;
                        }
                        default: {
                            n6 = 41;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001c&\u0019_L\u007f=\nDL\u007f=\u0004]\t-6\bFN1:\u0011LM\u007f<\u0019\tG0'KZ\\/#\u0004[]:7";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000f2\u0019HD,s\u0006\\Z+s\tL\t6=\u0018]H10\u000e\tF9s.jy>!\nDL+6\u0019zY:0KF[\u007f\u0016(nL1\u0003\n[H26\u001fL[\f#\u000eJ";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000f!\u0002DL\u007f \u0002SL\u007f>\u001eZ]\u007f1\u000e\tF16KFOesZ\u0010\u001bssY\u001b\u001dssY\u001c\u001fssX\u0011\u001dss^\u001b\u0018";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

