/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import java.io.File;
import java.security.spec.AlgorithmParameterSpec;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.crypto.enc.dom.DOMEncryptContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    private DOMUtils() {
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element createElement(Document doc, String tag, String nsURI, String prefix) {
        String qName = prefix == null ? tag : prefix + ":" + tag;
        return doc.createElementNS(nsURI, qName);
    }

    public static void setAttribute(Element elem, String name, String value) {
        if (value == null) {
            return;
        }
        if (name.startsWith("xml:")) {
            elem.setAttributeNS("http://www.w3.org/XML/1998/namespace", name, value);
        } else {
            elem.setAttributeNS(null, name, value);
        }
    }

    public static void setAttributeID(Element elem, String name, String value) {
        if (value == null) {
            return;
        }
        elem.setAttributeNS(null, name, value);
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getLastChildElement(Node node) {
        Node child;
        for (child = node.getLastChild(); child != null && child.getNodeType() != 1; child = child.getPreviousSibling()) {
        }
        return (Element)child;
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling;
        for (sibling = node.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    public static String getAttributeValue(Element elem, String name) {
        Attr attr = elem.getAttributeNodeNS(null, name);
        return attr == null ? null : attr.getValue();
    }

    public static Map getAttributes(Node node) {
        HashMap<String, String> hm = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int len = namedNodeMap.getLength();
        for (int i = 0; i < len; ++i) {
            Attr att = (Attr)namedNodeMap.item(i);
            String name = att.getName();
            String value = att.getValue();
            hm.put(name, value);
        }
        return hm;
    }

    public static Set nodeSet(NodeList nl) {
        return new NodeSet(nl);
    }

    public static String getNSPrefix(XMLCryptoContext context, String nsURI) {
        if (context != null) {
            return context.getNamespacePrefix(nsURI, context.getDefaultNamespacePrefix());
        }
        return null;
    }

    public static String getEncryptionPrefix(DOMEncryptContext context) {
        return DOMUtils.getNSPrefix((XMLCryptoContext)context, "http://www.w3.org/2001/04/xmlenc#");
    }

    public static String getSignaturePrefix(XMLCryptoContext context) {
        return DOMUtils.getNSPrefix(context, "http://www.w3.org/2000/09/xmldsig#");
    }

    public static void removeAllChildren(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            node.removeChild(children.item(i));
        }
    }

    public static boolean nodesEqual(Node thisNode, Node otherNode) {
        if (thisNode == otherNode) {
            return true;
        }
        return thisNode.getNodeType() == otherNode.getNodeType();
    }

    public static void appendChild(Node parent, Node child) {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        if (child.getOwnerDocument() != ownerDoc) {
            parent.appendChild(ownerDoc.importNode(child, true));
        } else {
            parent.appendChild(child);
        }
    }

    public static boolean paramsEqual(AlgorithmParameterSpec spec1, AlgorithmParameterSpec spec2) {
        if (spec1 == spec2) {
            return true;
        }
        if (spec1 instanceof XPathFilter2ParameterSpec && spec2 instanceof XPathFilter2ParameterSpec) {
            return DOMUtils.paramsEqual((XPathFilter2ParameterSpec)spec1, (XPathFilter2ParameterSpec)spec2);
        }
        if (spec1 instanceof ExcC14NParameterSpec && spec2 instanceof ExcC14NParameterSpec) {
            return DOMUtils.paramsEqual((ExcC14NParameterSpec)spec1, (ExcC14NParameterSpec)spec2);
        }
        if (spec1 instanceof XPathFilterParameterSpec && spec2 instanceof XPathFilterParameterSpec) {
            return DOMUtils.paramsEqual((XPathFilterParameterSpec)spec1, (XPathFilterParameterSpec)spec2);
        }
        if (spec1 instanceof XSLTTransformParameterSpec && spec2 instanceof XSLTTransformParameterSpec) {
            return DOMUtils.paramsEqual((XSLTTransformParameterSpec)spec1, (XSLTTransformParameterSpec)spec2);
        }
        return false;
    }

    private static boolean paramsEqual(XPathFilter2ParameterSpec spec1, XPathFilter2ParameterSpec spec2) {
        List<XPathType> types = spec1.getXPathList();
        List<XPathType> otypes = spec2.getXPathList();
        if (types.size() != otypes.size()) {
            return false;
        }
        for (int i = 0; i < types.size(); ++i) {
            XPathType type = types.get(i);
            XPathType otype = otypes.get(i);
            if (type.getExpression().equals(otype.getExpression()) && type.getFilter() == otype.getFilter()) continue;
            return false;
        }
        return true;
    }

    private static boolean paramsEqual(ExcC14NParameterSpec spec1, ExcC14NParameterSpec spec2) {
        return spec1.getPrefixList().equals(spec2.getPrefixList());
    }

    private static boolean paramsEqual(XPathFilterParameterSpec spec1, XPathFilterParameterSpec spec2) {
        return spec1.getXPath().equals(spec2.getXPath());
    }

    private static boolean paramsEqual(XSLTTransformParameterSpec spec1, XSLTTransformParameterSpec spec2) {
        XMLStructure ostylesheet = spec2.getStylesheet();
        if (!(ostylesheet instanceof DOMStructure)) {
            return false;
        }
        Node ostylesheetElem = ((DOMStructure)ostylesheet).getNode();
        XMLStructure stylesheet = spec1.getStylesheet();
        Node stylesheetElem = ((DOMStructure)stylesheet).getNode();
        return DOMUtils.nodesEqual(stylesheetElem, ostylesheetElem);
    }

    public static void writeDoc(Node doc, String filename) throws Exception {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static Node getFirstChild2(Node node) {
        Node ret = node.getFirstChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node first = ret.getFirstChild();
            if (first == null) {
                ret = DOMUtils.getNextSibling2(ret);
                break;
            }
            ret = first;
        }
        return ret;
    }

    public static Node getNextSibling2(Node node) {
        Node ret = node.getNextSibling();
        if (ret == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtils.getNextSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node first = ret.getFirstChild();
                if (first == null) {
                    ret = DOMUtils.getNextSibling2(ret);
                    break;
                }
                ret = first;
            }
        }
        return ret;
    }

    public static String getTextContent(Node node) {
        Node child = node.getFirstChild();
        StringBuffer sb = new StringBuffer();
        if (child == null) {
            return null;
        }
        if (child.getNodeType() == 3) {
            String text = child.getNodeValue();
            sb.append(text);
        }
        Node sibling = child;
        while ((sibling = sibling.getNextSibling()) != null) {
            if (sibling.getNodeType() != 3) continue;
            String text = sibling.getNodeValue();
            sb.append(text);
        }
        return sb.toString();
    }

    static class NodeSet
    extends AbstractSet {
        private NodeList nl;

        public NodeSet(NodeList nl) {
            this.nl = nl;
        }

        public int size() {
            return this.nl.getLength();
        }

        public Iterator iterator() {
            return new Iterator(){
                int index = 0;

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return NodeSet.this.nl.item(this.index++);
                }

                public boolean hasNext() {
                    return this.index < NodeSet.this.nl.getLength();
                }
            };
        }
    }
}

