/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.AbstractInstallAdaptor;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEngine;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IP2Generator;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.p2.P2EclipseQualificationOperation;
import com.ibm.cic.agent.internal.core.p2.P2Engine;
import com.ibm.cic.agent.internal.core.p2.P2Generator;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class P2InstallAdaptor
extends AbstractInstallAdaptor
implements IInstallAdaptor,
IAdaptable {
    public Object getAdapter(Class adapter) {
        if (IAgentEngine.class.equals((Object)adapter)) {
            return P2Engine.getInstance();
        }
        if (IP2Generator.Factory.class.equals((Object)adapter)) {
            return P2Generator.Factory.INSTANCE;
        }
        return null;
    }

    public IStatus complete(InstallContext context, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public String getId() {
        return "p2Eclipse";
    }

    public IStatus initialize(InstallContext context) {
        return Status.CANCEL_STATUS;
    }

    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus postInstall(InstallContext context, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus preInstall(InstallContext context, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus preInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus qualify(AgentJob[] jobs, InstallContextTree rootContext, Profile profile, IProgressMonitor monitor) {
        P2Engine.getInstance().setQualificationHistory(null);
        if (!this.isP2Content(jobs) || !AgentUserOptions.CIC_AGENT_P2_ENABLED.isSet()) {
            return Status.OK_STATUS;
        }
        this.markP2Units(rootContext);
        if (!profile.isExistingEclipseProfile()) {
            return Status.OK_STATUS;
        }
        String contextId = profile.getData("eclipseContext");
        InstallContextTree contextTree = rootContext.findSubContext(contextId);
        if (contextTree == null) {
            return Status.OK_STATUS;
        }
        P2EclipseQualificationOperation op = new P2EclipseQualificationOperation(jobs, profile, contextId, contextTree);
        return op.qualify(monitor);
    }

    private void markP2Units(InstallContextTree rootContext) {
        List trees = rootContext.getFullTree();
        for (InstallContextTree tree : trees) {
            for (InstallableUnitPair pair : tree.getOriginalPairs()) {
                IInstallableUnit to;
                if (!this.shouldMarkAsP2Pair(pair)) continue;
                IInstallableUnit from = pair.getFrom();
                if (from != null) {
                    from.setAdapterId("p2Eclipse");
                }
                if ((to = pair.getTo()) == null) continue;
                to.setAdapterId("p2Eclipse");
            }
        }
    }

    private boolean shouldMarkAsP2Pair(InstallableUnitPair pair) {
        IInstallableUnit unit = pair.getLatest();
        String adapterId = unit.getAdapterId();
        if (!"eclipse".equals(adapterId)) {
            return false;
        }
        Collection artifacts = unit.getAdapterData().getArtifacts();
        return artifacts.size() != 0;
    }

    private boolean isP2Content(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            if (this.isP2Content((IContent)offeringOrFix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isP2Content(IContent content) {
        IContentRepository repository = RepositoryUtils.getContentRepository((IContent)content);
        return repository != null && repository.containsP2Repository(null);
    }

    public IStatus restart(InstallContext context) {
        return Status.CANCEL_STATUS;
    }
}

