/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.IP2Generator;
import com.ibm.cic.agent.internal.core.p2.Messages;
import com.ibm.cic.agent.internal.core.p2.P2FilterQuery;
import com.ibm.cic.agent.internal.core.p2.P2Services;
import com.ibm.cic.agent.internal.core.p2.Utils;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectableNode;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.NoTaskNameProgressMonitor;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.p2EclipseAdapterData.IP2EclipseAdapterData;
import com.ibm.cic.common.p2EclipseAdapterData.IP2ReferenceData;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.internal.P2MatchQuery;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

class P2Generator
implements IP2Generator {
    private static final Logger log = Logger.getLogger();
    private static final Logger tlog = Logger.getLogger((String)"SelectorExpander.timing");
    private static final String IM_P2_PROFILE_ID = "com.ibm.cic.im.profile";
    private static final String IM_P2_PROFILE = "com.ibm.cic.im.generated";
    private static final String ROOT_UNITS_PROPERTY = "cic.root.units";
    private static int lastIndex = 0;
    private final P2Generator parent;
    private final File p2DataArea;
    private final P2Services p2Services;
    private final IMetadataRepositoryManager repoMan;
    private final com.ibm.cic.agent.core.api.IProfile cicProfile;
    private final IContextState contextState;
    private final IdMapping idMapping;
    private final Set<IIdentity> allSEIds;
    private final List<org.eclipse.equinox.p2.metadata.IInstallableUnit> p2IUs;
    private final List<org.eclipse.equinox.p2.metadata.IInstallableUnit> rootP2IUs = new ArrayList<org.eclipse.equinox.p2.metadata.IInstallableUnit>();
    private final Map<IOfferingOrFix, URI> addedRepos;
    private final List<URI> loadedRepos = new ArrayList<URI>();
    private final MapSet<String, Version> unitIdToVersionsMap = MapSet.newHash();
    private URI repoLocation = null;

    private P2Generator(P2Generator parent, com.ibm.cic.agent.core.api.IProfile cicProfile, IContextState contextState) throws CoreException {
        this.parent = parent;
        if (parent == null) {
            lastIndex = 0;
            this.p2DataArea = P2Generator.getDefaultP2DataAreaDir();
            this.p2Services = new P2Services(this.p2DataArea);
            this.addedRepos = new HashMap<IOfferingOrFix, URI>();
        } else {
            this.p2DataArea = parent.p2DataArea;
            this.p2Services = parent.p2Services;
            this.addedRepos = parent.addedRepos;
        }
        this.idMapping = new IdMapping(lastIndex++);
        this.cicProfile = cicProfile;
        this.contextState = contextState;
        Collection allSEs = contextState.getShareableEntities();
        this.p2IUs = new ArrayList<org.eclipse.equinox.p2.metadata.IInstallableUnit>(allSEs.size());
        this.allSEIds = new HashSet<IIdentity>(allSEs.size());
        for (IShareableEntity se : allSEs) {
            this.allSEIds.add(se.getIdentity());
        }
        this.repoMan = this.p2Services.getMetadataRepoMan();
        if (this.isRoot()) {
            IProfile[] profiles;
            Utils.removeAllRepositories(this.repoMan);
            FileUtil.rm_r((File)this.getTempRepoDir(), (boolean)true);
            new File(this.p2DataArea, "org.eclipse.equinox.p2.engine/profileRegistry").mkdirs();
            IProfileRegistry profileRegistry = this.p2Services.getProfileRegistry();
            IProfile[] iProfileArray = profiles = profileRegistry.getProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                IProfile profile = iProfileArray[n2];
                if (CommonDef.True.equals(profile.getProperty(IM_P2_PROFILE))) {
                    String id = profile.getProfileId();
                    log.warning(Messages.P2Generator_Cleaning_Up_Left_Over_Profile, new Object[]{id});
                    profileRegistry.removeProfile(id);
                }
                ++n2;
            }
        }
    }

    public String toString() {
        return "P2Generator for " + this.contextState.getFullId();
    }

    public void addOffering(IOffering offering, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        this.addP2Repo((IOfferingOrFix)offering, spm.next());
        IAssembly asm = offering.getAssembly();
        this.addRootUnit((IContent)offering, Collections.singletonMap(asm.getIdentity(), VersionUtil.getDefaultTolerance((org.osgi.framework.Version)asm.getVersion())), spm.next());
    }

    public void addFix(IFix fix, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        this.addP2Repo((IOfferingOrFix)fix, spm.next());
        IAssembly asm = fix.getAssembly();
        List children = asm.getChildren();
        LinkedHashMap<IIdentity, org.eclipse.osgi.service.resolver.VersionRange> requires = new LinkedHashMap<IIdentity, org.eclipse.osgi.service.resolver.VersionRange>(children.size());
        for (ISelectableNode child : children) {
            IIncludedShareableEntity ise;
            if (!(child instanceof IIncludedShareableEntity) || !this.allSEIds.contains((ise = (IIncludedShareableEntity)child).getIdentity())) continue;
            requires.put(ise.getIdentity(), ise.getTolerance());
        }
        this.addRootUnit((IContent)asm, requires, spm.next());
    }

    public void cleanup() {
        if (this.repoLocation != null) {
            if (!this.repoMan.removeRepository(this.repoLocation)) {
                log.warning(Messages.P2Generator_Failed_To_Remove_Repository, new Object[]{this.repoLocation});
            }
            this.repoLocation = null;
        }
        this.unloadRepositories();
        this.unitIdToVersionsMap.clear();
        if (this.isRoot()) {
            File p2TempDir = this.getTempRepoDir();
            if (CommonDef.True.equalsIgnoreCase(log.getAttr("keepRepo"))) {
                log.info("P2 repo preserved in {0}", new Object[]{p2TempDir});
            } else {
                FileUtil.rm_r((File)p2TempDir, (boolean)true);
                p2TempDir.getParentFile().delete();
            }
        }
        if (this.parent == null) {
            this.p2Services.dispose();
        }
    }

    public Map<String, org.osgi.framework.Version> getProvisioningPlanMap(Collection<IShareableEntity> parentSEs, IProgressMonitor monitor) throws CoreException {
        tlog.start(tlog.debug("Generating units for {0}", new Object[]{this.contextState}));
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 1, 1, 17});
        SplitProgressMonitor pm = new SplitProgressMonitor(spm.next(), parentSEs.size());
        for (IShareableEntity se : parentSEs) {
            this.addRootUnit((IContent)se, this.contextState.getTolerances(se), pm.next());
        }
        Collection ses = this.contextState.getShareableEntities();
        pm = new SplitProgressMonitor(spm.next(), ses.size());
        for (IShareableEntity se : ses) {
            this.addUnit((IContent)se, P2Generator.omitP2IuDependencies(se), this.contextState.getTolerances(se), this.contextState.getIUs((IShareableItem)se), pm.next());
        }
        Set entries = this.contextState.getFragmentMap().entrySet();
        pm = new SplitProgressMonitor(spm.next(), entries.size());
        for (Map.Entry entry : entries) {
            ISuFragment fragment = (ISuFragment)entry.getKey();
            IShareableUnit su = (IShareableUnit)Collections.max((Collection)entry.getValue(), Comparators.CONTENT_COMPARATOR);
            List ius = this.contextState.getSelectedIUs(su, fragment);
            if (ius.isEmpty()) continue;
            this.addUnit((IContent)fragment, P2Generator.omitP2IuDependencies((IShareableEntity)su), Collections.singletonMap(su.getIdentity(), fragment.getTargetTolerance()), ius, pm.next());
        }
        tlog.stop();
        this.unloadRepositories();
        this.writeToRepo();
        if (!this.unitIdToVersionsMap.isEmpty()) {
            this.loadFilteredP2Repos(spm.next());
        }
        this.logIuCounts();
        tlog.start(tlog.debug("Get provisioning plan for {0}", new Object[]{this.contextState}));
        try {
            ProfileChangeRequest request = new ProfileChangeRequest(this.createP2Profile());
            request.addInstallableUnits(this.rootP2IUs.toArray(new org.eclipse.equinox.p2.metadata.IInstallableUnit[this.rootP2IUs.size()]));
            IProvisioningPlan plan = this.p2Services.getPlanner().getProvisioningPlan((IProfileChangeRequest)request, null, (IProgressMonitor)new NoTaskNameProgressMonitor(spm.next()));
            this.throwError(plan.getStatus());
            tlog.stop();
            Map<String, org.osgi.framework.Version> map = this.getPlanMap(plan);
            return map;
        }
        finally {
            this.repoMan.removeRepository(this.repoLocation);
            this.repoLocation = null;
            this.p2Services.getProfileRegistry().removeProfile(this.getP2ProfileId());
        }
    }

    private static boolean omitP2IuDependencies(IShareableEntity se) {
        return Boolean.valueOf(se.getProperty("omitP2IuDependencies"));
    }

    private static File getDefaultP2DataAreaDir() {
        return new File(CicCommonSettings.getApplicationDataLocation(), "p2");
    }

    private void throwError(IStatus status) throws CoreException {
        if (!status.isOK()) {
            if (!this.isRoot()) {
                status = Statuses.ST.createMultiStatus(9001, status, Messages.P2Generator_In_Installation_Context, new Object[]{this.contextState.getIdentity()});
            }
            throw new CoreException((IStatus)Statuses.ST.createMultiStatus(9001, status, null, new Object[0]));
        }
    }

    private Map<String, org.osgi.framework.Version> getPlanMap(IProvisioningPlan plan) {
        Set added = plan.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
        tlog.debug("{0} p2 units in plan for {1}", new Object[]{added.size(), this.contextState.getFullId()});
        LinkedHashMap<String, org.osgi.framework.Version> result = new LinkedHashMap<String, org.osgi.framework.Version>(added.size());
        for (org.eclipse.equinox.p2.metadata.IInstallableUnit iuToAdd : added) {
            String seId = this.idMapping.mapSE(iuToAdd);
            if (seId != null) {
                result.put(seId, CicP2Model.toOSGiVersion((Version)iuToAdd.getVersion()));
                continue;
            }
            String sfId = this.idMapping.mapSF(iuToAdd);
            if (sfId == null) continue;
            result.put(sfId, CicP2Model.toOSGiVersion((Version)iuToAdd.getVersion()));
        }
        this.logPlan(result);
        return result;
    }

    private void logPlan(Map<String, org.osgi.framework.Version> planMap) {
        if (!log.isDebugLoggable()) {
            return;
        }
        log.debug("Plan for {0}", new Object[]{this.contextState.getFullId()});
        for (Map.Entry<String, org.osgi.framework.Version> entry : new TreeMap<String, org.osgi.framework.Version>(planMap).entrySet()) {
            log.debug("  {0}: {1}", new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    private IProfile createP2Profile() throws ProvisionException {
        String env = "osgi.os=" + Utils.getOS(this.cicProfile) + ",osgi.ws=" + Utils.getWS(this.cicProfile) + ",osgi.arch=" + Utils.getOSArch(this.cicProfile);
        return this.p2Services.getProfileRegistry().addProfile(this.getP2ProfileId(), (Map)new HashMap<String, String>(4, env){
            {
                this.put("org.eclipse.equinox.p2.environments", string);
                this.put("org.eclipse.equinox.p2.name", P2Generator.this.getP2ProfileId());
                this.put("org.eclipse.update.install.features", CommonDef.True);
                this.put(P2Generator.IM_P2_PROFILE, CommonDef.True);
            }
        });
    }

    private void writeToRepo() throws ProvisionException {
        File dir = this.getTempRepoDir();
        log.debug("Writing p2 units to: {0}", new Object[]{dir});
        tlog.start(tlog.debug("Writing P2 units to temp repo"));
        FileUtil.makeDirectories((File)dir);
        this.repoLocation = dir.toURI();
        IMetadataRepository repository = this.repoMan.createRepository(this.repoLocation, this.getP2ProfileId(), "org.eclipse.equinox.p2.metadata.repository.simpleRepository", Collections.singletonMap(ROOT_UNITS_PROPERTY, Util.toString(this.rootP2IUs, (Util.Formatter)new Util.Formatter(){

            protected String format(Object object) {
                return ((org.eclipse.equinox.p2.metadata.IInstallableUnit)object).getId();
            }
        })));
        repository.addInstallableUnits(this.p2IUs);
        tlog.stop();
    }

    private File getTempRepoDir() {
        File dir = new File(String.valueOf(this.p2DataArea.getPath()) + "temp/" + this.cicProfile.getProfileId());
        return this.isRoot() ? dir : new File(dir, this.getP2ProfileId());
    }

    private boolean isRoot() {
        return this.contextState.isRoot();
    }

    private String getP2ProfileId() {
        return IM_P2_PROFILE_ID + (this.isRoot() ? "" : String.valueOf('/') + this.contextState.getFullId());
    }

    private void addP2Repo(IOfferingOrFix offeringOrFix, IProgressMonitor monitor) throws CoreException {
        if (!this.addedRepos.containsKey(offeringOrFix)) {
            URI uri = this.exportP2Repo(offeringOrFix, false, monitor);
            this.addedRepos.put(offeringOrFix, uri);
        }
    }

    private URI exportP2Repo(IOfferingOrFix offeringOrFix, boolean filter, IProgressMonitor monitor) throws CoreException {
        File file;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(1, 2);
        IContentRepository repository = RepositoryUtils.getContentRepository((IContent)offeringOrFix);
        if (repository == null || !repository.containsP2Repository(pm.next())) {
            return null;
        }
        String repoName = offeringOrFix.getIdentity().getId();
        if (filter) {
            repoName = String.valueOf(repoName) + ".IBMIM.filtered";
        }
        if ((file = new File(this.getTempRepoDir(), repoName)).exists()) {
            FileUtil.rm_r((File)file, (boolean)true);
        }
        IStatus status = repository.exportP2Repository(new File(file, "content.xml"), pm.next());
        StatusUtil.throwIfError((IStatus)status);
        return file.toURI();
    }

    private void loadAddedP2Repos(IProgressMonitor monitor) throws CoreException {
        Collection<URI> repos = this.addedRepos.values();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, repos.size());
        for (URI repo : repos) {
            if (repo == null) continue;
            this.repoMan.loadRepository(repo, pm.next());
            this.loadedRepos.add(repo);
        }
        assert (!this.loadedRepos.isEmpty());
    }

    private void loadFilteredP2Repos(IProgressMonitor monitor) throws CoreException {
        tlog.start(tlog.debug("Filtering repos"));
        Set<Map.Entry<IOfferingOrFix, URI>> entries = this.addedRepos.entrySet();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, entries.size() * 2);
        for (Map.Entry<IOfferingOrFix, URI> entry : entries) {
            IOfferingOrFix offeringOrFix = entry.getKey();
            if (entry.getValue() == null) continue;
            URI filteredRepo = this.exportP2Repo(offeringOrFix, true, monitor);
            IMetadataRepository p2Repo = this.repoMan.loadRepository(filteredRepo, spm.next());
            this.loadedRepos.add(filteredRepo);
            P2FilterQuery query = new P2FilterQuery(this.unitIdToVersionsMap);
            IQueryResult result = p2Repo.query((IQuery)query, spm.next());
            p2Repo.removeInstallableUnits((Collection)result.toUnmodifiableSet());
        }
        tlog.stop();
    }

    private void unloadRepositories() {
        for (URI repo : this.loadedRepos) {
            if (this.repoMan.removeRepository(repo)) continue;
            log.warning(Messages.P2Generator_Failed_To_Remove_Repository, new Object[]{repo});
        }
        this.loadedRepos.clear();
    }

    private void addRootUnit(IContent content, Map<IIdentity, org.eclipse.osgi.service.resolver.VersionRange> requires, IProgressMonitor monitor) throws CoreException {
        MapSet fragments = this.contextState.getSuFragments();
        if (!fragments.isEmpty()) {
            requires = new HashMap<IIdentity, org.eclipse.osgi.service.resolver.VersionRange>(requires);
            for (IIdentity id : fragments.keySet()) {
                requires.put(id, org.eclipse.osgi.service.resolver.VersionRange.emptyRange);
            }
        }
        this.rootP2IUs.add(this.addUnit(content, false, requires, Collections.EMPTY_LIST, monitor));
    }

    private org.eclipse.equinox.p2.metadata.IInstallableUnit addUnit(IContent content, boolean omitP2IuDependencies, Map<IIdentity, org.eclipse.osgi.service.resolver.VersionRange> requires, List<IInstallableUnit> ius, IProgressMonitor monitor) throws CoreException {
        if (this.p2IUs.isEmpty()) {
            log.debug("P2 IUs generated in {0}", new Object[]{this.contextState.getFullId()});
        }
        log.debug("  {0} {1}:", new Object[]{content.getIdentity(), content.getVersion()});
        MapSet fragments = this.contextState.getSuFragments();
        ArrayList<IRequirement> requiredCapabilities = new ArrayList<IRequirement>(requires.size() + ius.size());
        for (Map.Entry<IIdentity, org.eclipse.osgi.service.resolver.VersionRange> entry : requires.entrySet()) {
            String mappedId;
            boolean optional;
            IIdentity id = entry.getKey();
            if (this.allSEIds.contains(id)) {
                optional = false;
                mappedId = this.idMapping.mapSE(id);
            } else {
                if (!fragments.contains((Object)id)) continue;
                optional = true;
                mappedId = this.idMapping.mapSF(id);
            }
            org.eclipse.osgi.service.resolver.VersionRange tolerance = entry.getValue();
            log.debug("    {0} {1}", new Object[]{id, tolerance});
            requiredCapabilities.add((IRequirement)P2Generator.createRequiredCapability(mappedId, tolerance, optional));
        }
        for (IInstallableUnit iu : ius) {
            if (!iu.getAdapterId().equals("p2Eclipse")) continue;
            IP2EclipseAdapterData adapterData = (IP2EclipseAdapterData)iu.getAdapterData();
            IP2ReferenceData[] p2Units = adapterData.getP2References();
            if (this.loadedRepos.isEmpty() && p2Units.length != 0) {
                this.loadAddedP2Repos(monitor);
            }
            IP2ReferenceData[] iP2ReferenceDataArray = p2Units;
            int n = p2Units.length;
            int n2 = 0;
            while (n2 < n) {
                IP2ReferenceData p2Unit = iP2ReferenceDataArray[n2];
                org.eclipse.equinox.p2.metadata.IInstallableUnit unit = Utils.findP2Unit(log, (IQueryable<org.eclipse.equinox.p2.metadata.IInstallableUnit>)this.repoMan, p2Unit);
                if (unit != null) {
                    IRequiredCapability installReq;
                    this.unitIdToVersionsMap.add((Object)p2Unit.getId(), (Object)CicP2Model.fromOSGiVersion((org.osgi.framework.Version)p2Unit.getVersion()));
                    if (!omitP2IuDependencies && (installReq = Utils.determineInstallRequirement(p2Unit.getForceInstall(), unit, p2Unit.getVersion(), true)) != null) {
                        requiredCapabilities.add((IRequirement)installReq);
                    }
                }
                ++n2;
            }
            log.debug("    {0}", new Object[]{iu.getIdentity()});
        }
        org.eclipse.equinox.p2.metadata.IInstallableUnit unit = this.createIU(content, requiredCapabilities);
        this.p2IUs.add(unit);
        return unit;
    }

    private org.eclipse.equinox.p2.metadata.IInstallableUnit createIU(IContent content, List<IRequirement> requiredCapabilities) {
        MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
        desc.setId(this.idMapping.map(content));
        desc.setVersion(P2Generator.toP2Version(content.getVersion()));
        desc.setSingleton(true);
        desc.addProvidedCapabilities(Collections.singletonList(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)desc.getId(), (Version)desc.getVersion())));
        desc.addRequirements(requiredCapabilities);
        Information info = content.getInformation();
        if (info != null) {
            desc.setProperty("org.eclipse.equinox.p2.name", info.getName());
            desc.setProperty("org.eclipse.equinox.p2.description", info.getDescription());
            desc.setProperty("org.eclipse.equinox.p2.provider", info.getProvider());
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
    }

    private static IRequiredCapability createRequiredCapability(String id, org.eclipse.osgi.service.resolver.VersionRange tolerance, boolean optional) {
        if (VersionUtil.isEmptyRange((org.eclipse.osgi.service.resolver.VersionRange)tolerance)) {
            tolerance = VersionUtil.UNSPECIFIED_TOLERANCE;
        }
        return (IRequiredCapability)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)CicP2Model.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)tolerance), null, (boolean)optional, (boolean)false, (boolean)true);
    }

    private static Version toP2Version(org.osgi.framework.Version version) {
        return Version.createOSGi((int)version.getMajor(), (int)version.getMinor(), (int)version.getMicro(), (String)version.getQualifier());
    }

    private void logIuCounts() throws ProvisionException {
        if (!tlog.isDebugLoggable()) {
            return;
        }
        URI[] uRIArray = this.repoMan.getKnownRepositories(0);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            IuCountQuery query = new IuCountQuery();
            this.repoMan.loadRepository(uri, null).query((IQuery)query, null);
            tlog.debug("{0} units in {1}", new Object[]{query.count, uri});
            ++n2;
        }
    }

    /* synthetic */ P2Generator(P2Generator p2Generator, com.ibm.cic.agent.core.api.IProfile iProfile, IContextState iContextState, P2Generator p2Generator2) throws CoreException {
        this(p2Generator, iProfile, iContextState);
    }

    static class Factory
    implements IP2Generator.Factory {
        static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public IP2Generator create(IP2Generator parent, com.ibm.cic.agent.core.api.IProfile cicProfile, IContextState contextState) throws CoreException {
            return new P2Generator((P2Generator)parent, cicProfile, contextState, null);
        }
    }

    private static class IdMapping {
        private static final String OFFERING_PREFIX = "OFFERING.";
        private static final String FIX_PREFIX = "FIX.";
        private static final String SE_PREFIX = "SE.";
        private static final String SF_PREFIX = "SF.";
        private final String sePrefix;
        private final String sfPrefix;

        IdMapping(int index) {
            this.sePrefix = SE_PREFIX + index + '.';
            this.sfPrefix = SF_PREFIX + index + '.';
        }

        String map(IContent content) {
            String prefix;
            String string = content instanceof IOffering ? OFFERING_PREFIX : (content instanceof IFix ? FIX_PREFIX : (content instanceof ISuFragment ? this.sfPrefix : (prefix = content instanceof IShareableEntity ? this.sePrefix : null)));
            assert (prefix != null) : content;
            return String.valueOf(prefix) + content.getIdentity().getId();
        }

        String mapSE(IIdentity seId) {
            return String.valueOf(this.sePrefix) + seId.getId();
        }

        String mapSF(IIdentity fragmentId) {
            return String.valueOf(this.sfPrefix) + fragmentId.getId();
        }

        String mapSE(org.eclipse.equinox.p2.metadata.IInstallableUnit iu) {
            return IdMapping.mapItem(this.sePrefix, iu);
        }

        String mapSF(org.eclipse.equinox.p2.metadata.IInstallableUnit iu) {
            return IdMapping.mapItem(this.sfPrefix, iu);
        }

        private static String mapItem(String prefix, org.eclipse.equinox.p2.metadata.IInstallableUnit iu) {
            if (iu == null) {
                return null;
            }
            String id = iu.getId();
            return id.startsWith(prefix) ? id.substring(prefix.length()) : null;
        }
    }

    private static class IuCountQuery
    extends P2MatchQuery {
        int count = 0;

        private IuCountQuery() {
        }

        public boolean isMatch(Object candidate) {
            ++this.count;
            return false;
        }
    }
}

