/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IVariableProvider;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.internal.core.p2.P2Configuration;
import com.ibm.cic.agent.internal.core.p2.P2Services;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;

public class P2EclipseVariableProvider
implements IVariableProvider {
    private static final Logger log = Logger.getLogger(P2EclipseVariableProvider.class);
    private static final String BUNDLE_LOCATION = "bundleLocation";
    private static final String BUNDLE_CLASSIFIER = "osgi.bundle";

    public String substitute(SubstitutionOperation operation, String variableName, String variableArg) {
        if (operation == null) {
            return null;
        }
        if (variableName.equals(BUNDLE_LOCATION)) {
            return this.getBundleLocation(operation, variableArg);
        }
        return null;
    }

    private String getBundleLocation(SubstitutionOperation operation, String variableArg) {
        P2Services p2Services;
        P2Configuration p2Configuration;
        String configLocation;
        if (variableArg == null) {
            return null;
        }
        InstallContext context = operation.getInstallContext();
        String string = configLocation = context == null ? null : context.getLocation("configLocation");
        if (configLocation == null) {
            context = this.getDefaultEclipseContext(operation.getProfile());
        }
        if (context == null || !context.isP2Managed()) {
            return null;
        }
        try {
            p2Configuration = new P2Configuration(context);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return null;
        }
        String profileId = p2Configuration.getP2ProfileId();
        File p2DataArea = p2Configuration.getP2DataArea();
        try {
            p2Services = new P2Services(p2DataArea);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return null;
        }
        try {
            IProfileRegistry profileRegistry = p2Services.getProfileRegistry();
            IProfile profile = profileRegistry.getProfile(profileId);
            IQuery query = QueryUtil.createIUQuery((String)variableArg, null);
            IQueryResult queryResult = profile.available(query, null);
            if (queryResult.isEmpty()) {
                return null;
            }
            IInstallableUnit p2unit = (IInstallableUnit)queryResult.iterator().next();
            File cacheLocation = CacheManager.getDefaultInstance().getCacheLocation();
            File cachePluginsDir = new File(cacheLocation, "plugins");
            File installPluginsDir = null;
            if (context.getEnclosingProfile().isExistingEclipseProfile()) {
                String installLocation = context.getLocation("installLocation");
                installPluginsDir = new File(installLocation, "plugins");
            }
            Collection artifacts = p2unit.getArtifacts();
            for (IArtifactKey key : artifacts) {
                File result = null;
                if (installPluginsDir != null) {
                    result = this.getBundleLocation(installPluginsDir, key);
                }
                if (result == null) {
                    result = this.getBundleLocation(cachePluginsDir, key);
                }
                if (result == null) continue;
                String string2 = FileUtil.getCanonicalPath((File)result);
                return string2;
            }
            return null;
        }
        finally {
            p2Services.dispose();
        }
    }

    private File getBundleLocation(File pluginsDir, IArtifactKey key) {
        String classifier = key.getClassifier();
        if (!BUNDLE_CLASSIFIER.equals(classifier)) {
            return null;
        }
        String id = key.getId();
        Version ver = key.getVersion();
        String artifactName = String.valueOf(id) + '_' + ver.toString();
        File result = new File(pluginsDir, artifactName);
        if (!result.isDirectory() && !(result = new File(pluginsDir, artifactName = String.valueOf(artifactName) + CicConstants.getJarFileDotExt())).exists()) {
            return null;
        }
        return result;
    }

    private InstallContext getDefaultEclipseContext(Profile profile) {
        String contextId = profile.getData("eclipseContext");
        return profile.findInstallContext(contextId);
    }
}

