/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.stacks;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.healthcenter.stacks.CallSiteTreeData;
import com.ibm.java.diagnostics.healthcenter.stacks.CallStack;
import com.ibm.java.diagnostics.healthcenter.stacks.StackEntry;
import com.ibm.java.diagnostics.healthcenter.stacks.StackLabels;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTableData;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTraceDataPoint;
import java.util.ArrayList;

public class StackData
extends DataImpl {
    private final ArrayList<StackEntry> entries = new ArrayList();
    private static final DataFactory factory = DataFactory.getFactory();
    private AxisPair axes;

    public static StackData getStackData(Data data) {
        StackData stackData = null;
        if (data != null) {
            stackData = StackData.getStackData((DataBuilder)data);
        }
        return stackData;
    }

    public static StackData getStackData(DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(StackLabels.STACK_DATA);
        if (!(dataBuilder2 instanceof StackData)) {
            dataBuilder.removeData(StackLabels.STACK_DATA);
            dataBuilder2 = null;
        }
        return (StackData)dataBuilder2;
    }

    public static StackData createStackData(DataBuilder dataBuilder, AxisPair axisPair) {
        StackData stackData = StackData.getStackData(dataBuilder);
        if (stackData == null) {
            stackData = new StackData(axisPair);
            dataBuilder.addData(stackData);
        }
        return stackData;
    }

    protected StackData(AxisPair axisPair) {
        super(StackLabels.STACK_DATA);
        this.axes = axisPair;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public StackEntry addStackEntry(String string) {
        StackEntry stackEntry = new StackEntry(string);
        int n = this.entries.indexOf(stackEntry);
        if (n >= 0) {
            stackEntry = this.entries.get(n);
        } else {
            this.entries.add(stackEntry);
        }
        return stackEntry;
    }

    public void addStackDataPoint(StackTraceDataPoint stackTraceDataPoint) {
        String string = stackTraceDataPoint.getTriggerID();
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getStacks(string);
        if (twoDimensionalDataBuilder == null) {
            twoDimensionalDataBuilder = factory.createTwoDimensionalData(string, this.axes);
            this.addData(twoDimensionalDataBuilder);
        }
        twoDimensionalDataBuilder.addDataPointBuilder(stackTraceDataPoint);
        CallStack callStack = stackTraceDataPoint.getStack();
        if (callStack != null && callStack.getStackSize() > 0) {
            StackEntry stackEntry = stackTraceDataPoint.getStack().getStackEntry(0);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)twoDimensionalDataBuilder.getTopLevelData(stackEntry.getEntry());
            if (twoDimensionalDataBuilder2 == null) {
                twoDimensionalDataBuilder2 = factory.createTwoDimensionalData(stackEntry.getEntry(), this.axes);
                twoDimensionalDataBuilder.addData(twoDimensionalDataBuilder2);
            }
            twoDimensionalDataBuilder2.addDataPointBuilder(stackTraceDataPoint);
        }
    }

    public TwoDimensionalDataBuilder getStacks(String string) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)this.getTopLevelData(string);
        return twoDimensionalDataBuilder;
    }

    public static TwoDimensionalDataBuilder findStacks(String string, Data data) {
        StackData stackData = StackData.getStackData(data);
        if (stackData != null) {
            return stackData.getStacks(string);
        }
        return null;
    }

    public static TwoDimensionalDataBuilder findCallSiteCounts(String string, String string2, Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = StackData.findStacks(string, data);
        if (twoDimensionalDataBuilder == null) {
            return null;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)twoDimensionalDataBuilder.getTopLevelData(string2);
        return twoDimensionalDataBuilder2;
    }

    public TwoDimensionalDataBuilder getCallSiteCounts(String string, String string2) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getStacks(string);
        if (twoDimensionalDataBuilder == null) {
            return null;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)twoDimensionalDataBuilder.getTopLevelData(string2);
        return twoDimensionalDataBuilder2;
    }

    public static CallSiteTreeData buildCallSiteTree(String string, String string2, Data data) {
        StackData stackData = StackData.getStackData(data);
        if (stackData == null) {
            return null;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = stackData.getCallSiteCounts(string, string2);
        if (twoDimensionalDataBuilder != null) {
            DataPointBuilder[] dataPointBuilderArray;
            CallSiteTreeData callSiteTreeData = new CallSiteTreeData(string2);
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints()) {
                if (!(dataPointBuilder instanceof StackTraceDataPoint)) continue;
                callSiteTreeData.addCallStack(((StackTraceDataPoint)dataPointBuilder).getStack());
            }
            return callSiteTreeData;
        }
        return null;
    }

    public static StackTraceDataPoint findStackTrace(String string, double d, Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = StackData.findStacks(string, data);
        if (twoDimensionalDataBuilder != null) {
            return (StackTraceDataPoint)twoDimensionalDataBuilder.getDataPoint(d);
        }
        return null;
    }

    public StackTableData getStackTable(String string) {
        DataBuilder dataBuilder = this.getTopLevelData(string);
        if (dataBuilder != null) {
            return (StackTableData)dataBuilder.getTopLevelData(StackLabels.CALL_SITE_COUNTS);
        }
        return null;
    }

    public StackTableData createStackTable(String string) {
        StackTableData stackTableData = null;
        DataBuilder dataBuilder = this.getTopLevelData(string);
        if (dataBuilder != null) {
            dataBuilder.removeData(StackLabels.CALL_SITE_COUNTS);
            stackTableData = new StackTableData(StackLabels.CALL_SITE_COUNTS);
            dataBuilder.addData(stackTableData);
        }
        return stackTableData;
    }
}

