/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.OptionChecker;
import java.text.MessageFormat;
import java.util.Collection;

public class UnwiseOptionChecker
extends OptionChecker {
    private static final String XNOJIT = "-Xnojit";
    private static final String XSAMPLING_EXPIRATION_TIME = "-XsamplingExpirationTime";
    private static final String XINT = "-Xint";
    private static final String XJIT_OFF = "-Xjit:off";
    private String pathSeparator;
    private static final String XBOOTCLASSPATH_PREPEND = "-Xbootclasspath/p:";
    private static final String XBOOTCLASSPATH = "-Xbootclasspath";
    private static final String XBOOTCLASSPATH_REPLACE = "-Xbootclasspath:";
    private static final String XNOLINENUMBERS = "-Xnolinenumbers";
    private static final String XVERIFY_NONE = "-Xverify:none";

    public UnwiseOptionChecker(String string) {
        this.pathSeparator = string;
    }

    @Override
    public Status checkOptions(Collection<String> collection, StructuredStringDataBuilder structuredStringDataBuilder) {
        Status status = Status.HEALTHY;
        for (String string : collection) {
            if (!string.startsWith("-X")) continue;
            status = this.handleXOption(structuredStringDataBuilder, status, string);
        }
        return status;
    }

    private Status handleXOption(StructuredStringDataBuilder structuredStringDataBuilder, Status status, String string) {
        if (XNOLINENUMBERS.equals(string)) {
            structuredStringDataBuilder.addWarning(Messages.getString("UnwiseOptionChecker.xnolinenumbers"));
            status = this.setWarningStatus(status);
        } else if (XVERIFY_NONE.equals(string)) {
            structuredStringDataBuilder.addWarning(Messages.getString("UnwiseOptionChecker.xverifynone"));
            status = this.setWarningStatus(status);
        } else if (string.startsWith(XBOOTCLASSPATH)) {
            status = this.handleBootClassPath(structuredStringDataBuilder, status, string);
        } else if (XJIT_OFF.equals(string) || XINT.equals(string) || XSAMPLING_EXPIRATION_TIME.equals(string) || XNOJIT.equals(string)) {
            String string2 = Messages.getString("UnwiseOptionChecker.no.jit");
            structuredStringDataBuilder.addProblem(MessageFormat.format(string2, string));
            status = Status.PROBLEM;
        } else if ("-Xj9".equals(string)) {
            String string3 = Messages.getString("UnwiseOptionChecker.xj9.is.pointless");
            structuredStringDataBuilder.addWarning(string3);
            status = this.setWarningStatus(status);
        }
        return status;
    }

    private Status handleBootClassPath(StructuredStringDataBuilder structuredStringDataBuilder, Status status, String string) {
        boolean bl = string.startsWith(XBOOTCLASSPATH_REPLACE);
        String[] stringArray = string.split(this.pathSeparator);
        StringBuffer stringBuffer = this.formatColonSeparatedLibraries(stringArray);
        if (stringBuffer.length() == 0) {
            return status;
        }
        if (bl) {
            String string2 = Messages.getString("UnwiseOptionChecker.bootclasspath.replaced");
            String string3 = MessageFormat.format(string2, stringBuffer);
            structuredStringDataBuilder.addWarning(string3);
            status = this.setWarningStatus(status);
        } else {
            boolean bl2 = string.startsWith(XBOOTCLASSPATH_PREPEND);
            String string4 = bl2 ? Messages.getString("UnwiseOptionChecker.prepended") : Messages.getString("UnwiseOptionChecker.appended");
            String string5 = stringArray.length <= 2 ? Messages.getString("UnwiseOptionChecker.bootclasspath.modified.single.library") : Messages.getString("UnwiseOptionChecker.bootclasspath.modified.several.libraries");
            structuredStringDataBuilder.addInformation(MessageFormat.format(string5, stringBuffer, string4));
        }
        return status;
    }

    private StringBuffer formatColonSeparatedLibraries(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().indexOf("ibm") != -1) continue;
            stringBuffer.append(stringArray[i]);
            if (i < stringArray.length - 2) {
                stringBuffer.append(Messages.getString("UnwiseOptionChecker.comma"));
                continue;
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(Messages.getString("UnwiseOptionChecker.and"));
        }
        return stringBuffer;
    }

    private Status setWarningStatus(Status status) {
        if (status != Status.PROBLEM) {
            status = Status.WARNING;
        }
        return status;
    }
}

