/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.cpu.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.cpu.CpuLabels;
import com.ibm.java.diagnostics.healthcenter.cpu.Messages;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(CpuPostProcessor.class);
    private static final String CLASS_NAME = CpuPostProcessor.class.getName();
    private static final Pattern AGENT_VERSION_REGEX = Pattern.compile("(\\d+)\\.(\\d+).(\\d+).(\\d+)");
    private static VMLevelChecker checker = null;

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.CPU);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(CpuLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(CpuLabels.RECOMMENDATION_LABEL);
            this.isAppropriateAgentLevel(dataBuilder, structuredStringDataImpl);
            this.checkForVMLevel(dataBuilder, structuredStringDataImpl);
            this.calculateMeanUsage(subsystemDataBuilder, structuredStringDataImpl);
            this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
            subsystemDataBuilder.addData(structuredStringDataImpl);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void calculateMeanUsage(DataBuilder dataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Object object;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, CpuLabels.CPU_PROCESS);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            object = MessageFormat.format(Messages.getString("cpu.mean.process"), NumberFormatter.prettyString(twoDimensionalDataBuilder.getRawMeanY()), NumberFormatter.prettyString(twoDimensionalDataBuilder.getMaxY().getRawY()));
            structuredStringDataBuilder.addInformation((String)object);
        }
        if ((object = this.getTwoDimensionalData(dataBuilder, CpuLabels.CPU_SYSTEM)) != null && !object.isEmpty()) {
            String string = MessageFormat.format(Messages.getString("cpu.mean.system"), NumberFormatter.prettyString(object.getRawMeanY()), NumberFormatter.prettyString(object.getMaxY().getRawY()));
            structuredStringDataBuilder.addInformation(string);
        }
    }

    private void isAppropriateAgentLevel(DataBuilder dataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        String string;
        Matcher matcher;
        EnvironmentData environmentData;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentData && (environmentData = (EnvironmentData)((Object)dataBuilder2)) != null && (matcher = AGENT_VERSION_REGEX.matcher(string = environmentData.getAgentVersion())).matches() && matcher.groupCount() == 4) {
            int n = -1;
            int n2 = -1;
            try {
                n = Integer.valueOf(matcher.group(1));
                n2 = Integer.valueOf(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                TRACE.log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
            if (n < 2 || n == 2 && n2 < 2) {
                structuredStringDataBuilder.addInformation(Messages.getString("cpu.old.agent"));
            }
        }
    }

    private void checkForVMLevel(DataBuilder dataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentData && (checker = (data = (EnvironmentData)((Object)dataBuilder2)).getVMLevelChecker()) != null && !checker.isSystemCPUAvailable()) {
            structuredStringDataBuilder.addInformation(Messages.getString("cpu.old.java"));
        }
        data = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.CPU);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, CpuLabels.CPU_PROCESS);
        if (checker != null && checker.isSystemCPUAvailable() && twoDimensionalDataBuilder == null) {
            structuredStringDataBuilder.addInformation(Messages.getString("cpu.minimum.process"));
        }
    }

    private TwoDimensionalDataBuilder getTwoDimensionalData(Data data, String string) {
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder) {
            return (TwoDimensionalDataBuilder)data2;
        }
        return null;
    }
}

