/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.cpu.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.cpu.CpuData;
import com.ibm.java.diagnostics.healthcenter.api.cpu.CpuInfo;
import com.ibm.java.diagnostics.healthcenter.api.cpu.impl.CpuInfoImpl;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.cpu.CpuLabels;
import java.util.Date;
import javax.management.Notification;

public class CpuDataImpl
extends HealthCenterDataImpl
implements CpuData {
    private Notification processUseNotify;
    private Notification systemUseNotify;

    public CpuDataImpl(Data data) {
        super(data);
    }

    @Override
    protected String getRecommendationLabel() {
        this.getJvmData();
        return CpuLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.CPU;
    }

    @Override
    public CpuInfo[] getProcessUse() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.CPU);
        CpuInfo[] cpuInfoArray = null;
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, CpuLabels.CPU_PROCESS)) != null) {
            cpuInfoArray = new CpuInfo[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                cpuInfoArray[n] = new CpuInfoImpl(dataPointBuilder.getRawX(), dataPointBuilder.getRawY());
                ++n;
            }
        }
        return cpuInfoArray;
    }

    @Override
    public CpuInfo[] getSystemUse() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.CPU);
        CpuInfo[] cpuInfoArray = null;
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, CpuLabels.CPU_SYSTEM)) != null) {
            cpuInfoArray = new CpuInfo[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                cpuInfoArray[n] = new CpuInfoImpl(dataPointBuilder.getRawX(), dataPointBuilder.getRawY());
                ++n;
            }
        }
        return cpuInfoArray;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    @Override
    public double getMaxSystemUse() {
        return this.getMaxData(JVMLabels.CPU, CpuLabels.CPU_SYSTEM);
    }

    @Override
    public double getMeanSystemUse() {
        return this.getMeanData(JVMLabels.CPU, CpuLabels.CPU_SYSTEM);
    }

    @Override
    public double getMinSystemUse() {
        return this.getMinData(JVMLabels.CPU, CpuLabels.CPU_SYSTEM);
    }

    @Override
    public double getMaxProcessUse() {
        return this.getMaxData(JVMLabels.CPU, CpuLabels.CPU_PROCESS);
    }

    @Override
    public double getMeanProcessUse() {
        return this.getMeanData(JVMLabels.CPU, CpuLabels.CPU_PROCESS);
    }

    @Override
    public double getMinProcessUse() {
        return this.getMinData(JVMLabels.CPU, CpuLabels.CPU_PROCESS);
    }

    static /* synthetic */ long access$000(CpuDataImpl cpuDataImpl) {
        return cpuDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        Date processTime;
        Date systemTime;
        long count = 0L;
        long delay = CpuDataImpl.access$000(CpuDataImpl.this);

        public Updater(long l) {
            if (l >= CpuDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                this.processTime = new Date();
                this.systemTime = new Date();
                if (CpuDataImpl.this.getProcessUse() != null && CpuDataImpl.this.getProcessUse().length > 0 && CpuDataImpl.this.getProcessUse()[CpuDataImpl.this.getProcessUse().length - 1].getTime() != this.processTime.getTime()) {
                    CpuDataImpl.this.processUseNotify = new Notification(null, CpuDataImpl.this, this.count++);
                    CpuDataImpl.this.processUseNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.threads.ProcessUseData");
                    CpuDataImpl.this.sendNotification(CpuDataImpl.this.processUseNotify);
                }
                if (CpuDataImpl.this.getSystemUse() != null && CpuDataImpl.this.getSystemUse().length > 0 && CpuDataImpl.this.getSystemUse()[CpuDataImpl.this.getSystemUse().length - 1].getTime() != this.systemTime.getTime()) {
                    CpuDataImpl.this.systemUseNotify = new Notification(null, CpuDataImpl.this, this.count++);
                    CpuDataImpl.this.systemUseNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.threads.SystemUseData");
                    CpuDataImpl.this.sendNotification(CpuDataImpl.this.systemUseNotify);
                }
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

