/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.CommandResult;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.IpStreamHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingCommandRunner {
    private static final int SIGTERM_RC = 143;
    private ArrayList<String> command;
    private String commandLabel;
    private Logger logger;
    private ProcessBuilder pb;

    public BlockingCommandRunner(ArrayList<String> arrayList, String string, boolean bl, Logger logger) {
        this.command = arrayList;
        this.commandLabel = string;
        this.logger = logger;
        this.pb = new ProcessBuilder(arrayList);
        this.pb.redirectErrorStream(bl);
    }

    private void logCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.command) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        this.logger.fine("Running command: " + stringBuffer.toString());
    }

    public CommandResult runCommand(int n, boolean bl) {
        this.logCommand();
        Process process = null;
        int n2 = -1;
        try {
            process = this.pb.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.logger.log(Level.FINE, "IOException when starting process for: " + this.commandLabel, iOException);
            n2 = -1;
        }
        if (process == null) {
            return new CommandResult(null, null, n2, false);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        IpStreamHandler ipStreamHandler = new IpStreamHandler(stringBuffer, this.commandLabel, process.getInputStream(), true, bl, this.logger);
        IpStreamHandler ipStreamHandler2 = new IpStreamHandler(stringBuffer2, this.commandLabel, process.getErrorStream(), false, bl, this.logger);
        Thread thread = new Thread(ipStreamHandler);
        Thread thread2 = new Thread(ipStreamHandler2);
        thread.start();
        thread2.start();
        boolean bl2 = false;
        for (int i = 0; i <= n; ++i) {
            try {
                n2 = process.exitValue();
                this.logger.fine(this.commandLabel + ": return code: " + n2);
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.log(Level.FINE, "Interrupted waiting for " + this.commandLabel + " process", interruptedException);
                }
                if (i + 1 < n) continue;
                this.logger.fine("Timed out waiting for command to complete: " + this.commandLabel);
                this.logger.fine("Requesting to terminate process for: " + this.commandLabel);
                process.destroy();
                try {
                    n2 = process.exitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException2) {
                    n2 = 143;
                    this.logger.log(Level.FINE, "IllegalThreadStateException trying to get rc after destroying " + this.commandLabel + " process", illegalThreadStateException2);
                }
                bl2 = true;
                continue;
            }
        }
        try {
            thread.join(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.FINE, "Interrupted waiting for " + this.commandLabel + " stdout", interruptedException);
        }
        try {
            thread2.join(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.FINE, "Interrupted waiting for " + this.commandLabel + " stderr", interruptedException);
        }
        return new CommandResult(stringBuffer.toString(), stringBuffer2.toString(), n2, bl2);
    }
}

