/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.impl.data.Type;
import com.ibm.java.diagnostics.common.util.cache.LeastRecentlyUsedCache;

public class ObjectType
extends Type {
    private static final String ESCAPED_DOT = "\\.";
    private String unqualifiedClassName;
    private static final String SEMICOLON = ";";
    private static final String L = "L";
    private static final LeastRecentlyUsedCache<String, ObjectType> CACHE = new LeastRecentlyUsedCache();

    private ObjectType(String string) {
        super(ObjectType.constructNiceName(string));
    }

    private static String constructNiceName(String string) {
        if (string.startsWith(L) && string.endsWith(SEMICOLON)) {
            return string.substring(1, string.length() - 1).replace('/', '.');
        }
        return string.replace('/', '.');
    }

    @Override
    public String getUnqualifiedName() {
        if (this.unqualifiedClassName == null) {
            String string = this.toString();
            int n = string.lastIndexOf(46);
            if (n < 0) {
                n = string.lastIndexOf("/");
            }
            this.unqualifiedClassName = n > 0 ? string.substring(n + 1) : string;
        }
        return this.unqualifiedClassName;
    }

    public static ObjectType getType(String string) {
        ObjectType objectType = CACHE.get(string);
        if (objectType == null) {
            objectType = new ObjectType(string);
            CACHE.put(string, objectType);
        }
        return objectType;
    }

    @Override
    public String getAbbreviatedName() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getName().split(ESCAPED_DOT);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i].charAt(0));
            stringBuffer.append('.');
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }
}

