/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.datamodel.impl.data.MethodNode;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ObjectType;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaMethod
implements Method {
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final String PRIMITIVE = "[BCDFIJSZ]";
    private static final String REFERENCE_TYPE = "L[^;]*;";
    private static final String PRIMITIVE_ARRAY_TYPE = "\\[+[BCDFIJSZ]";
    private static final String REFERENCE_ARRAY_TYPE = "\\[+L[^;]*;";
    private static final String TYPE = "(?:L[^;]*;)|[BCDFIJSZ]|(?:\\[+[BCDFIJSZ])|(?:\\[+L[^;]*;)";
    private static final Pattern PATTERN = Pattern.compile("(?:L[^;]*;)|[BCDFIJSZ]|(?:\\[+[BCDFIJSZ])|(?:\\[+L[^;]*;)");
    private static final String COMMA = ", ";
    private static final String DOT = ".";
    private static final String UNKNOWN_NAME = Messages.getString("Method.unknown.method.template");
    private static final String SIGNATURE_START = "(";
    private static final String SIGNATURE_END = ")";
    private static final String PRETTY_NAME_APPEND_STRING = "()";
    private ObjectType clazz;
    private String methodName;
    private Type[] signaturePart;
    private final long uniqueID;
    private boolean methodNameKnown = false;
    private String fullyQualifiedName;
    private String idString = null;

    public JavaMethod(long l) {
        this.uniqueID = l;
    }

    public JavaMethod(String string, String string2, String string3, long l) {
        this(l);
        this.setName(string, string2, string3);
    }

    public void setName(String string, String string2, String string3) {
        if (this.clazz == null && string != null) {
            this.clazz = ObjectType.getType(string);
            this.methodName = string2.trim();
            this.signaturePart = this.parseSignature(string3);
            this.fullyQualifiedName = null;
            this.methodNameKnown = true;
        }
    }

    private Type[] parseSignature(String string) {
        int n = string.lastIndexOf(SIGNATURE_END);
        if (n < 0) {
            n = string.length();
        }
        String string2 = string.substring(1, n);
        Matcher matcher = PATTERN.matcher(string2);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (matcher.find()) {
            String string3 = matcher.group(0);
            Type type = Type.getType(string3);
            arrayList.add(type);
        }
        return arrayList.toArray(EMPTY_TYPE_ARRAY);
    }

    public String getClassName() {
        if (this.clazz != null) {
            return this.clazz.toString();
        }
        return null;
    }

    @Override
    public String getMethodName() {
        if (this.methodName == null) {
            this.methodName = MessageFormat.format(UNKNOWN_NAME, Long.toHexString(this.uniqueID));
        }
        return this.methodName;
    }

    public String getMethodSignature() {
        if (this.signaturePart != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(SIGNATURE_START);
            for (int i = 0; i < this.signaturePart.length; ++i) {
                Type type = this.signaturePart[i];
                stringBuilder.append(type.toString());
                if (i >= this.signaturePart.length - 1) continue;
                stringBuilder.append(COMMA);
            }
            stringBuilder.append(SIGNATURE_END);
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.fullyQualifiedName == null) {
            this.fullyQualifiedName = this.clazz == null ? MessageFormat.format(UNKNOWN_NAME, this.getUniqueId()) : this.clazz + DOT + this.methodName + this.getMethodSignature();
        }
        return this.fullyQualifiedName;
    }

    @Override
    public boolean isNameKnown() {
        return this.methodNameKnown;
    }

    @Override
    public String getUniqueId() {
        if (this.idString == null) {
            this.idString = Long.toHexString(this.uniqueID);
        }
        return this.idString;
    }

    @Override
    public long getUniqueIdAsNumber() {
        return this.uniqueID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)object;
            return this.uniqueID == javaMethod.uniqueID;
        }
        if (object instanceof MethodNode) {
            Method method = ((MethodNode)object).getMethod();
            return this.equals(method);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.uniqueID;
    }

    @Override
    public String getShortName() {
        if (this.isNameKnown()) {
            return this.getUnqualifiedClassName() + DOT + this.getMethodName() + PRETTY_NAME_APPEND_STRING;
        }
        return this.getName();
    }

    public static String getShortName(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(SIGNATURE_START);
        if (n3 >= 0) {
            string = string.substring(0, n3) + PRETTY_NAME_APPEND_STRING;
        }
        if ((n2 = string.lastIndexOf(DOT)) > 0 && (n = string.lastIndexOf(DOT, n2 - 1)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String getUnqualifiedClassName() {
        if (this.clazz != null) {
            return this.clazz.getUnqualifiedName();
        }
        return null;
    }

    @Override
    public String getName(boolean bl, boolean bl2, boolean bl3) {
        if (this.isNameKnown()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                if (bl) {
                    stringBuilder.append(this.clazz.getName());
                } else {
                    stringBuilder.append(this.clazz.getUnqualifiedName());
                }
                stringBuilder.append(DOT);
            }
            stringBuilder.append(this.methodName);
            if (bl3) {
                stringBuilder.append(SIGNATURE_START);
                for (int i = 0; i < this.signaturePart.length; ++i) {
                    Type type = this.signaturePart[i];
                    if (bl) {
                        stringBuilder.append(type.getName());
                    } else {
                        stringBuilder.append(type.getUnqualifiedName());
                    }
                    if (i >= this.signaturePart.length - 1) continue;
                    stringBuilder.append(COMMA);
                }
                stringBuilder.append(SIGNATURE_END);
            }
            return stringBuilder.toString();
        }
        return this.getMethodName();
    }

    @Override
    public String getName(int n) {
        String string = this.getName();
        if (string.length() <= n || !this.isNameKnown()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.clazz.getName());
        stringBuilder.append(DOT);
        stringBuilder.append(this.methodName);
        this.addAbbreviatedSignature(stringBuilder);
        if (stringBuilder.length() >= n) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(this.clazz.getAbbreviatedName());
            stringBuilder.append(DOT);
            stringBuilder.append(this.methodName);
            this.addAbbreviatedSignature(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void addAbbreviatedSignature(StringBuilder stringBuilder) {
        stringBuilder.append(SIGNATURE_START);
        for (int i = 0; i < this.signaturePart.length; ++i) {
            Type type = this.signaturePart[i];
            stringBuilder.append(type.getAbbreviatedName());
            if (i >= this.signaturePart.length - 1) continue;
            stringBuilder.append(COMMA);
        }
        stringBuilder.append(SIGNATURE_END);
    }

    public String toString() {
        return this.getName();
    }
}

