/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

public class ECParameters
extends AlgorithmParametersSpi
implements AlgorithmStatus {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private static final String[] z;

    @Override
    public boolean isFipsApproved() {
        return true;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (SelfTest.isFipsRunnable()) {
            return this.a();
        }
        throw new FIPSRuntimeException();
    }

    protected byte[] a() throws IOException {
        byte[] byArray = this.encodeECParameters();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected AlgorithmParameterSpec a(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName(z[8]);
            if (clazz2.isAssignableFrom(clazz)) {
                return new ECParameterSpec(this.b, this.c, this.d, this.a);
            }
            throw new InvalidParameterSpecException(z[7]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[6] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.a(algorithmParameterSpec);
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidParameterSpecException(z[3]);
        }
        this.b = ((ECParameterSpec)algorithmParameterSpec).getCurve();
        this.c = ((ECParameterSpec)algorithmParameterSpec).getGenerator();
        this.d = ((ECParameterSpec)algorithmParameterSpec).getOrder();
        this.a = ((ECParameterSpec)algorithmParameterSpec).getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.a(byArray);
    }

    protected void a(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.decodeECParameters(byArray);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        if (SelfTest.isFipsRunnable()) {
            return this.b();
        }
        throw new FIPSRuntimeException();
    }

    protected String b() {
        return z[17] + this.b.getA() + z[14] + this.b.getB() + z[12] + this.b.getField().getFieldSize() + z[16] + ECUtils.a(this.c) + z[13] + this.d.toString() + z[15] + this.a + "\n";
    }

    protected static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[10], z[11]);
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[6] + generalSecurityException);
        }
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n2 = ellipticCurve.getField().getFieldSize();
        int n3 = n2 + 7 >> 3;
        byte[] byArray = ECParameters.b(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = ECParameters.b(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n3 || byArray2.length > n3) {
            throw new RuntimeException(z[9]);
        }
        byte[] byArray3 = new byte[1 + (n3 << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, n3 - byArray.length + 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[1]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[0]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    static byte[] b(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static DerValue encodeEllipticCurve(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.b(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.b(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[18] + iOException);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[20]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = byArray3 == null ? new EllipticCurve(eCField, bigInteger, bigInteger2) : new EllipticCurve(eCField, bigInteger, bigInteger2, byArray3);
            return ellipticCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[19] + iOException);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[2] + iOException);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[20]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[21]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[22] + iOException);
        }
    }

    public byte[] encodeECParameters() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            if (eCNamedCurve != null) {
                return eCNamedCurve.a();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[24]);
            }
            DerValue derValue = ECParameters.encodePrimeFieldType((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.encodeEllipticCurve(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[23] + iOException);
        }
    }

    public static ECParameterSpec decodeECParameters(byte[] byArray) throws IOException {
        boolean bl = false;
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                if (derValue.getTag() == 6) {
                    String string = derValue.getOID().toString();
                    return ECNamedCurve.getECParameterSpec(string);
                }
                throw new IOException(z[5]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            int n2 = derInputStream2.getInteger().intValue();
            DerValue derValue2 = derInputStream2.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.decodePrimeFieldType(derValue2);
            DerValue derValue3 = derInputStream2.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.decodeEllipticCurve(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream2.getOctetString();
            ECPoint eCPoint = ECParameters.decodePoint(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream2.getBigInteger();
            int n3 = 0;
            if (derInputStream2.available() != 0) {
                bl = true;
                n3 = derInputStream2.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[4] + iOException);
        }
    }

    public static ECNamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = ECNamedCurve.b();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                String string = entry.getKey();
                ECParameterSpec eCParameterSpec2 = entry.getValue();
                BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                byte[] byArray = eCParameterSpec2.getCurve().getSeed();
                byte[] byArray2 = eCParameterSpec.getCurve().getSeed();
                if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4) || n2 != n3) continue;
                if (byArray != null || byArray2 != null) {
                    if (byArray == null && byArray2 != null || byArray != null && byArray2 == null) continue;
                    if (byArray != null && byArray2 != null) {
                        if (byArray.length != byArray2.length) continue;
                        boolean bl = true;
                        for (int i2 = 0; i2 < byArray.length; ++i2) {
                            if (byArray[i2] == byArray2[i2]) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator()) || !eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder()) || eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) continue;
                ECNamedCurve eCNamedCurve = new ECNamedCurve(string);
                return eCNamedCurve;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "y>\u000by>\t5\rr9\t?\rcjD0\u0016t\"\t7\u000br&Mq\u0011~0L";
        int n3 = -1;
        block32: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block36: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block36;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block37;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 41;
                                break;
                            }
                            case 1: {
                                n9 = 81;
                                break;
                            }
                            case 2: {
                                n9 = 98;
                                break;
                            }
                            case 3: {
                                n9 = 23;
                                break;
                            }
                            default: {
                                n9 = 74;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "f?\u000enj\\?\u0001x'Y#\u0007d9L5Bg%@?\u00167,F#\u000fv>\t\"\u0017g:F#\u0016r.";
                    n3 = 0;
                    continue block32;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "l)\u0001r:]8\ryj@?Br$J>\u0006r\u001a[8\u000fr\f@4\u000es\u001eP!\u0007?c\u0013q";
                    n3 = 1;
                    continue block32;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "`?\u0003g:[>\u0012e#H%\u00077:H#\u0003z/]4\u001079Y4\u0001~,@2\u0003c#F?";
                    n3 = 2;
                    continue block32;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "l)\u0001r:]8\ryj@?Bs/J>\u0006r\u000fj\u0001\u0003e+D4\u0016r8ZyK-j";
                    n3 = 3;
                    continue block32;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "g>\u00167+\t\u0002'F\u001fl\u001f!RjF#Bv$\t\u001e+S";
                    n3 = 4;
                    continue block32;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "|?\u0011b:Y>\u0010c/Mq\u0012v8H<\u0007c/[q\u0011g/J8\u0004~)H%\u000bx$\u0013q";
                    n3 = 5;
                    continue block32;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "`?\u0003g:[>\u0012e#H%\u00077:H#\u0003z/]4\u00107\u0019Y4\u0001~,@2\u0003c#F?";
                    n3 = 6;
                    continue block32;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "C0\u0014vdZ4\u0001b8@%\u001b99Y4\u00019\u000fj\u0001\u0003e+D4\u0016r8z!\u0007t";
                    n3 = 7;
                    continue block32;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "y>\u000by>\t2\rx8M8\fv>L\"Bs%\t?\rcjD0\u0016t\"\t7\u000br&Mq\u0011~0L";
                    n3 = 8;
                    continue block32;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "l\u0012";
                    n3 = 9;
                    continue block32;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "`\u0013/]\tl";
                    n3 = 10;
                    continue block32;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "#Xkd#S4X7";
                    n3 = 11;
                    continue block32;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "#X\re.L#X7@ X";
                    n3 = 12;
                    continue block32;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "#Xkup\t";
                    n3 = 13;
                    continue block32;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "#X\u0001x,H2\u0016x8\u0013q";
                    n3 = 14;
                    continue block32;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "#X\u0005r$L#\u0003c%[kB\u001dC ";
                    n3 = 15;
                    continue block32;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "#X\u0001b8_4X7@ X\u0003-j";
                    n3 = 16;
                    continue block32;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "l)\u0001r:]8\ryj@?Br$J>\u0006r\u000fE=\u000bg>@2!b8_4J>p\t";
                    n3 = 17;
                    continue block32;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "l)\u0001r:]8\ryj@?Bs/J>\u0006r\u000fE=\u000bg>@2!b8_4J>p\t";
                    n3 = 18;
                    continue block32;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "g>\u00167+\t\u0002'F\u001fl\u001f!R";
                    n3 = 19;
                    continue block32;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "`?\u0001x8[4\u0001cjf\u0018&7/G2\rb$]4\u0010r.\t5\u0017e#G6Bs/J>\u0006r\u001a[8\u000fr\f@4\u000es\u001eP!\u00079";
                    n3 = 20;
                    continue block32;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "l)\u0001r:]8\ryj@?Bs/J>\u0006r\u001a[8\u000fr\f@4\u000es\u001eP!\u0007?c\u0013q";
                    n3 = 21;
                    continue block32;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "l)\u0001r:]8\ryj@?Br$J>\u0006r\u000fj\u0001\u0003e+D4\u0016r8ZyK-j";
                    n3 = 22;
                    continue block32;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "l\u0012$~/E5$%'\t4\ft%\\?\u0016r8L5B~$\t4\ft%M4'T\u001aH#\u0003z/]4\u0010db\u0000\u007fB7\u000fj\u0017\u000br&M\u0017Pzj@\"By%]q\u0001b8[4\fc&Pq\u0011b:Y>\u0010c/M\u007f";
                    n3 = 23;
                    continue block32;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

