/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public final class TCPMsgRfc2510 {
    public static final byte MSG_REQ = 0;
    public static final byte POLL_REP = 1;
    public static final byte POLL_REQ = 2;
    public static final byte NEG_POLL_REP = 3;
    public static final byte PARTIAL_MSG_REP = 4;
    public static final byte FINAL_MSG_REP = 5;
    public static final byte ERROR_MSG_REP = 6;
    private byte flag;
    private byte[] value;
    private static final byte[] zero = new byte[1];

    public TCPMsgRfc2510(byte by, byte[] byArray) {
        this.setMessage(by, byArray);
    }

    public TCPMsgRfc2510(InputStream inputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n = new BigInteger(1, byArray).intValue();
        byte[] byArray2 = new byte[1];
        inputStream.read(byArray2);
        this.flag = byArray2[0];
        this.value = new byte[n - 1];
        inputStream.read(this.value);
    }

    public byte getFlag() {
        return this.flag;
    }

    public int getLength() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length + 1;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return (byte[])this.value.clone();
    }

    private void read(InputStream inputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n = new BigInteger(1, byArray).intValue();
        byte[] byArray2 = new byte[1];
        inputStream.read(byArray2);
        this.flag = byArray2[0];
        this.value = new byte[n - 1];
        inputStream.read(this.value);
    }

    private void setMessage(byte by, byte[] byArray) {
        if (by < 0 || by > 6) {
            throw new IllegalArgumentException("TCPMsgRfc2510 error : invalid flag");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("TCPMsgRfc2510 error : invalid value");
        }
        this.flag = by;
        this.value = byArray;
    }

    public void write(OutputStream outputStream) throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(this.value.length + 1).abs();
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 4 && byArray[0] != 0) {
            throw new IOException("TCPMsgRfc2510 error : data overflow");
        }
        if (byArray.length > 4) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 1, byArray2, 0, 0);
            byArray = byArray2;
        }
        int n = 4 - byArray.length;
        while (n > 0) {
            outputStream.write(zero);
            --n;
        }
        outputStream.write(byArray);
        byte[] byArray3 = new byte[]{this.flag};
        outputStream.write(byArray3);
        outputStream.write(this.value);
    }
}

