/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Map;
import javax.inject.Named;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.MakeHandlersGo;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.handlers.CommandProxy;
import org.eclipse.ui.internal.handlers.HandlerActivation;

public class E4HandlerProxy
implements IHandlerListener {
    public HandlerActivation activation = null;
    private Command command;
    private IHandler handler;

    public E4HandlerProxy(Command command, IHandler handler) {
        this.command = command;
        this.handler = handler;
        handler.addHandlerListener((IHandlerListener)this);
    }

    @CanExecute
    public boolean canExecute(IEclipseContext context, @Optional IEvaluationContext staticContext, MApplication application) {
        if (this.handler instanceof IHandler2) {
            IEvaluationContext ctx = staticContext;
            if (ctx == null) {
                ctx = new ExpressionContext(application.getContext());
            }
            ((IHandler2)this.handler).setEnabled((Object)ctx);
        }
        return this.handler.isEnabled();
    }

    @Execute
    public Object execute(IEclipseContext context, @Optional @Named(value="parmMap::") Map parms, @Optional Event trigger, @Optional IEvaluationContext staticContext) throws ExecutionException, NotHandledException {
        Activator.trace((String)"/trace/commands", (String)("execute " + this.command + " and " + this.handler + " with: " + context), null);
        IEvaluationContext appContext = staticContext;
        if (appContext == null) {
            appContext = new ExpressionContext(context);
        }
        ExecutionEvent event = new ExecutionEvent(this.command, parms, (Object)trigger, (Object)appContext);
        if (this.handler != null && this.handler.isHandled()) {
            try {
                Object returnValue = this.handler.execute(event);
                CommandProxy.firePostExecuteSuccess(this.command, returnValue);
                return returnValue;
            }
            catch (ExecutionException exception) {
                CommandProxy.firePostExecuteFailure(this.command, exception);
                throw exception;
            }
        }
        NotHandledException e = new NotHandledException("There is no handler to execute for command " + this.command.getId());
        CommandProxy.fireNotHandled(this.command, e);
        throw e;
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public void handlerChanged(HandlerEvent handlerEvent) {
        IEclipseContext appContext;
        IHandler handler = this.command.getHandler();
        if (handler instanceof MakeHandlersGo && HandlerServiceImpl.lookUpHandler((IEclipseContext)(appContext = ((Workbench)PlatformUI.getWorkbench()).getApplication().getContext()), (String)this.command.getId()) == this) {
            ((MakeHandlersGo)handler).fireHandlerChanged(handlerEvent);
        }
    }
}

