/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core;

import com.ibm.cic.common.logging.Logger;
import com.ibm.ws.pak.core.PakMessages;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;

public class PakData {
    private Properties m_pInstallProperties = new Properties();
    private String m_sOperation = null;
    private String m_sPakName = null;
    private String m_sLogLocation = null;

    public void initialize(String pakFileName, String pakLocation, String metadataLocation, String installLocation, String logLocation, String backupPakLocation, String allowBackup, String productId, String nifRegistryInstallType, String operation, String gaVersion, String pathToProductProvidersXML, Properties optionalProperties) throws Exception {
        String errMsg = this.validateRequiredData(pakFileName, pakLocation, installLocation, productId, operation);
        if (errMsg != null) {
            Logr.warn((String)errMsg);
            throw new Exception(errMsg);
        }
        pakLocation = this.fixPath(pakLocation);
        installLocation = this.fixPath(installLocation);
        this.m_sLogLocation = this.fixPath(logLocation);
        this.m_sOperation = operation;
        if (metadataLocation != null) {
            metadataLocation = this.fixPath(metadataLocation);
            this.m_pInstallProperties.put("metadata.dir", metadataLocation);
        }
        this.m_pInstallProperties.put("installSource", pakLocation);
        this.m_pInstallProperties.put("updiProductBean.installLocation", installLocation);
        this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.customProperties,installLocation", installLocation);
        if (nifRegistryInstallType == null) {
            nifRegistryInstallType = operation.toLowerCase();
        }
        this.m_pInstallProperties.put("nifregistryInstallType", nifRegistryInstallType);
        this.m_pInstallProperties.put("pakengineoperation", operation);
        String sBackupPakRelivePath = backupPakLocation;
        if (sBackupPakRelivePath == null || sBackupPakRelivePath.equals("")) {
            sBackupPakRelivePath = "/properties/version/nif/backup/";
        }
        sBackupPakRelivePath = this.fixPath(sBackupPakRelivePath);
        String sBackupPath = this.removeExtraSlashInPath(String.valueOf(installLocation) + File.separatorChar + sBackupPakRelivePath);
        String sUninstallPakFullPath = this.removeExtraSlashInPath(String.valueOf(sBackupPath) + File.separatorChar + pakFileName);
        this.m_pInstallProperties.put("backuppath", sBackupPath);
        if (operation.equals("INSTALL")) {
            String installPakPath = this.removeExtraSlashInPath(String.valueOf(pakLocation) + File.separatorChar + pakFileName);
            this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.selectedMaintenancePackages", installPakPath);
            this.m_sPakName = installPakPath;
        } else if (operation.equals("UNINSTALL")) {
            if (!new File(sUninstallPakFullPath).exists()) {
                String sMsg = PakMessages.bind((String)PakMessages.PAK_PAKDATA_REQUIRED_DATA_INVALID_LOCATION, (Object)sUninstallPakFullPath);
                Logr.debug((String)sMsg);
                Logger.getGlobalLogger().info(sMsg);
            }
            this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.selectedMaintenancePackages", sUninstallPakFullPath);
            this.m_sPakName = sUninstallPakFullPath;
        }
        if (allowBackup == null || allowBackup.equals("")) {
            allowBackup = Boolean.TRUE.toString();
        }
        this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.backup", allowBackup);
        this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.customProperties,productType", productId);
        this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.customProperties,primaryPakName", pakFileName);
        this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.customProperties,nifProductID", productId);
        if (gaVersion != null && !gaVersion.equals("")) {
            this.m_pInstallProperties.put("productgaversion", gaVersion);
        }
        if (pathToProductProvidersXML != null && !pathToProductProvidersXML.equals("")) {
            this.m_pInstallProperties.put("productProvidersXML", pathToProductProvidersXML);
        }
        this.m_pInstallProperties.put("wsglobalinstallconstantsProductBean.customProperties,enableFailureRecovery", Boolean.TRUE.toString());
        if (optionalProperties != null && !optionalProperties.isEmpty()) {
            Enumeration<Object> keys = optionalProperties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = optionalProperties.getProperty(key);
                this.m_pInstallProperties.put(key, value);
            }
        }
    }

    private String validateRequiredData(String pakFileName, String pakLocation, String installLocation, String productId, String operation) {
        String sMessage = null;
        if (pakFileName == null || pakFileName.equals("")) {
            sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_MISSING_REQUIRED_DATA, (Object)"pakFileName");
        } else if (pakLocation == null || pakLocation.equals("")) {
            sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_MISSING_REQUIRED_DATA, (Object)"pakLocation");
        } else if (installLocation == null || installLocation.equals("")) {
            sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_MISSING_REQUIRED_DATA, (Object)"installLocation");
        } else if (productId == null || productId.equals("")) {
            sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_MISSING_REQUIRED_DATA, (Object)"productId");
        } else if (operation == null || operation.equals("")) {
            sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_MISSING_REQUIRED_DATA, (Object)"operation");
        } else if (!operation.equals("INSTALL") && !operation.equals("UNINSTALL")) {
            sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_UNKNOWN_OPERATION, (Object)operation);
        } else {
            File file = new File(this.fixPath(String.valueOf(pakLocation) + File.separatorChar + pakFileName));
            if (!file.exists() && operation.equals("INSTALL")) {
                sMessage = PakMessages.bind((String)PakMessages.PAK_PAKDATA_REQUIRED_DATA_INVALID_LOCATION, (Object)file.getAbsolutePath());
            }
        }
        return sMessage;
    }

    private String fixPath(String s) {
        if (s == null) {
            return null;
        }
        String retVal = s;
        if (File.separatorChar == '/') {
            retVal = retVal.replace('\\', File.separatorChar);
        }
        if (File.separatorChar == '\\') {
            retVal = retVal.replace('/', File.separatorChar);
        }
        return retVal;
    }

    private String removeExtraSlashInPath(String inPath) {
        String outPath = inPath;
        while (outPath.indexOf("//") >= 0) {
            outPath = this.replaceToken(outPath, "//", "/");
        }
        while (outPath.indexOf("\\\\") >= 0) {
            outPath = this.replaceToken(outPath, "\\\\", "\\");
        }
        return outPath;
    }

    private String replaceToken(String inLine, String token, String replacement) {
        StringBuffer sb = new StringBuffer();
        int index1 = 0;
        int index2 = 0;
        while ((index2 = inLine.indexOf(token, index1)) >= 0) {
            sb.append(inLine.substring(index1, index2));
            sb.append(replacement);
            index1 = index2 + token.length();
        }
        sb.append(inLine.substring(index1));
        return sb.toString();
    }

    public Properties getInstallProperties() {
        return this.m_pInstallProperties;
    }

    public String getPakName() {
        return this.m_sPakName;
    }

    public String getLogLocation() {
        return this.m_sLogLocation;
    }

    public String getOperation() {
        return this.m_sOperation;
    }
}

