/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import java.util.StringTokenizer;

public class PackageComponent
implements FlexlmConstants {
    private String name;
    private FlexlmVersion version;
    private int count;

    public PackageComponent(String string) throws FlexlmException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        this.name = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.version = new FlexlmVersion(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                this.count = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmException(-82, 4039);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public FlexlmVersion getVersion() {
        return this.version;
    }

    public String getVersionString() {
        return this.version != null ? this.version.toString() : null;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        String string = this.name;
        if (this.version != null) {
            string = string + ":" + this.version;
            if (this.count != 0) {
                string = string + ":" + this.count;
            }
        }
        return string;
    }
}

