/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.util.StringTokenizer;

public class FlexlmVersion
implements FlexlmConstants,
FlexlmInternalConstants,
Comparable {
    private String versionString;
    private int whole;
    private int fraction;
    private int cryptFraction;
    private boolean matchAnyVersion;

    public FlexlmVersion(String string) throws FlexlmException {
        boolean bl = true;
        this.versionString = string;
        if (string.equalsIgnoreCase("ANYVER")) {
            this.matchAnyVersion = true;
        } else {
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 2) {
                bl = false;
            }
            try {
                this.whole = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmException(-77, 4046);
            }
            if (bl) {
                String string3 = stringTokenizer.nextToken();
                string2 = new String(string3);
                while (string3.length() < 5) {
                    string3 = new String(string3 + "0");
                }
                try {
                    this.fraction = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmException(-77, 4047);
                }
            } else {
                this.fraction = 0;
                string2 = "00000";
            }
            if (this.fraction == 0) {
                this.cryptFraction = 0;
            } else {
                while (string2.endsWith("0")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                try {
                    this.cryptFraction = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmException(-77, 4051);
                }
                this.cryptFraction *= 10;
                for (int i = 0; i < 3 - string2.length(); ++i) {
                    this.cryptFraction *= 10;
                }
            }
        }
    }

    public int compareTo(Object object) {
        if (this.matchAnyVersion) {
            return 0;
        }
        FlexlmVersion flexlmVersion = (FlexlmVersion)object;
        if (this.whole < flexlmVersion.getWhole()) {
            return -1;
        }
        if (this.whole > flexlmVersion.getWhole()) {
            return 1;
        }
        if (this.fraction < flexlmVersion.getFraction()) {
            return -1;
        }
        if (this.fraction > flexlmVersion.getFraction()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(FlexlmVersion flexlmVersion) {
        return this.compareTo(flexlmVersion) == 0;
    }

    public int getWhole() {
        return this.whole;
    }

    public int getFraction() {
        return this.fraction;
    }

    public int getCryptFraction() {
        return this.cryptFraction;
    }

    public String toString() {
        return this.versionString;
    }
}

