/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.fulfillstatus;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.fulfillstatus.Deduction;
import com.macrovision.flexlm.fulfillstatus.DetailedFulfillment;
import com.macrovision.flexlm.fulfillstatus.Fulfillment;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.PrintStream;
import java.util.Vector;

public class StatusHandle
implements FlexlmConstants,
FlexlmInternalConstants {
    public static final int ACTIVATION = 0;
    public static final int ACTIVATION_OVERDRAFT = 1;
    public static final int CONCURRENT = 2;
    public static final int CONCURRENT_OVERDRAFT = 3;
    public static final int HYBRID = 4;
    public static final int HYBRID_OVERDRAFT = 5;
    private static final int COUNTS_SIZE = 6;
    public static final int DEDUCTION_TYPE_ACTIVATION = 1;
    public static final int DEDUCTION_TYPE_TRANSFER = 2;
    public static final int DEDUCTION_TYPE_REPAIR = 3;
    private Vector fulfillments = new Vector();
    private Fulfillment curFulfillment = null;

    public int getNumFulfillments() throws FlexlmException {
        return this.fulfillments.size();
    }

    public void selectFirstFulfillment() throws FlexlmException {
        this.curFulfillment = this.fulfillments.size() > 0 ? (Fulfillment)this.fulfillments.get(0) : null;
    }

    public void selectNextFulfillment() throws FlexlmException {
        if (this.curFulfillment != null) {
            try {
                this.curFulfillment = (Fulfillment)this.fulfillments.get(this.fulfillments.indexOf(this.curFulfillment) + 1);
            }
            catch (Throwable throwable) {
                this.curFulfillment = null;
            }
        }
    }

    public void selectPrevFulfillment() throws FlexlmException {
        if (this.curFulfillment != null) {
            try {
                this.curFulfillment = (Fulfillment)this.fulfillments.get(this.fulfillments.indexOf(this.curFulfillment) - 1);
            }
            catch (Throwable throwable) {
                this.curFulfillment = null;
            }
        }
    }

    public void selectLastFulfillment() throws FlexlmException {
        try {
            this.curFulfillment = (Fulfillment)this.fulfillments.lastElement();
        }
        catch (Throwable throwable) {
            this.curFulfillment = null;
        }
    }

    public void selectNthFulfillment(int n) throws FlexlmException {
        try {
            this.curFulfillment = (Fulfillment)this.fulfillments.get(n);
        }
        catch (Throwable throwable) {
            this.curFulfillment = null;
        }
    }

    public int getFulfillmentVersion() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getVersionNumber();
        }
        throw new FlexlmException(-42, 8022);
    }

    public String getFulfillmentId() throws FlexlmException {
        if (this.curFulfillment != null) {
            return this.curFulfillment.getFulfillmentId();
        }
        throw new FlexlmException(-42, 8023);
    }

    public String getEntitlementId() throws FlexlmException {
        if (this.curFulfillment != null) {
            return this.curFulfillment.getEntitlementId();
        }
        throw new FlexlmException(-42, 8024);
    }

    public String getProductId() throws FlexlmException {
        if (this.curFulfillment != null) {
            return this.curFulfillment.getProductId();
        }
        throw new FlexlmException(-42, 8025);
    }

    public String getSuiteId() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getSuiteId();
        }
        throw new FlexlmException(-42, 8048);
    }

    public String getExpirationDate() throws FlexlmException {
        if (this.curFulfillment != null) {
            return this.curFulfillment.getExpirationDate();
        }
        throw new FlexlmException(-42, 8026);
    }

    public String getOriginalExpirationDate() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getOriginalExpirationDate();
        }
        throw new FlexlmException(-42, 8027);
    }

    public String getFulfillmentChain() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getFulfillChain();
        }
        throw new FlexlmException(-42, 8028);
    }

    public String getServerChain() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getServerChain();
        }
        throw new FlexlmException(-42, 8049);
    }

    public int getHops() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getHops();
        }
        throw new FlexlmException(-42, 8029);
    }

    public int[] getAvailableCounts() throws FlexlmException {
        if (this.curFulfillment != null) {
            int[] nArray = new int[]{this.curFulfillment.getActivationCount(), this.curFulfillment.getActivationOverdraftCount(), this.curFulfillment.getConcurrentCount(), this.curFulfillment.getConcurrentOverdraftCount(), this.curFulfillment.getHybridCount(), this.curFulfillment.getHybridOverdraftCount()};
            return nArray;
        }
        throw new FlexlmException(-42, 8030);
    }

    public int[] getMaximumCounts() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            int[] nArray = new int[6];
            DetailedFulfillment detailedFulfillment = (DetailedFulfillment)this.curFulfillment;
            nArray[0] = detailedFulfillment.getMaxActivationCount();
            nArray[1] = detailedFulfillment.getMaxActivationOverdraftCount();
            nArray[2] = detailedFulfillment.getMaxConcurrentCount();
            nArray[3] = detailedFulfillment.getMaxConcurrentOverdraftCount();
            nArray[4] = detailedFulfillment.getMaxHybridCount();
            nArray[5] = detailedFulfillment.getMaxHybridOverdraftCount();
            return nArray;
        }
        throw new FlexlmException(-42, 8031);
    }

    public int getRepairsToServe() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getRepairsToServe();
        }
        throw new FlexlmException(-42, 8050);
    }

    public String getMaximumOverdraftDuration() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getMaxOverdraftDuration();
        }
        throw new FlexlmException(-42, 8032);
    }

    public String getFeatureLines() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getFeatureLines();
        }
        throw new FlexlmException(-42, 8033);
    }

    public int getNumDeductions() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            return ((DetailedFulfillment)this.curFulfillment).getNumDeductions();
        }
        throw new FlexlmException(-42, 8034);
    }

    public void selectFirstDeduction() throws FlexlmException {
        if (this.curFulfillment == null || !(this.curFulfillment instanceof DetailedFulfillment)) {
            throw new FlexlmException(-42, 8035);
        }
        ((DetailedFulfillment)this.curFulfillment).selectFirstDeduction();
    }

    public void selectNextDeduction() throws FlexlmException {
        if (this.curFulfillment == null || !(this.curFulfillment instanceof DetailedFulfillment)) {
            throw new FlexlmException(-42, 8036);
        }
        ((DetailedFulfillment)this.curFulfillment).selectNextDeduction();
    }

    public void selectPrevDeduction() throws FlexlmException {
        if (this.curFulfillment == null || !(this.curFulfillment instanceof DetailedFulfillment)) {
            throw new FlexlmException(-42, 8037);
        }
        ((DetailedFulfillment)this.curFulfillment).selectPrevDeduction();
    }

    public void selectLastDeduction() throws FlexlmException {
        if (this.curFulfillment == null || !(this.curFulfillment instanceof DetailedFulfillment)) {
            throw new FlexlmException(-42, 8038);
        }
        ((DetailedFulfillment)this.curFulfillment).selectLastDeduction();
    }

    public void selectNthDeduction(int n) throws FlexlmException {
        if (this.curFulfillment == null || !(this.curFulfillment instanceof DetailedFulfillment)) {
            throw new FlexlmException(-42, 8039);
        }
        ((DetailedFulfillment)this.curFulfillment).selectNthDeduction(n);
    }

    public int getDeductionType() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            Deduction deduction = ((DetailedFulfillment)this.curFulfillment).getCurDeduction();
            if (deduction != null) {
                return deduction.getType();
            }
            throw new FlexlmException(-42, 8051);
        }
        throw new FlexlmException(-42, 8052);
    }

    public String getDeductionDestinationFulfillId() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            Deduction deduction = ((DetailedFulfillment)this.curFulfillment).getCurDeduction();
            if (deduction != null) {
                return deduction.getDestFulfillmentId();
            }
            throw new FlexlmException(-42, 8040);
        }
        throw new FlexlmException(-42, 8041);
    }

    public String getDeductionSystemName() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            Deduction deduction = ((DetailedFulfillment)this.curFulfillment).getCurDeduction();
            if (deduction != null) {
                return deduction.getDestSystemName();
            }
            throw new FlexlmException(-42, 8042);
        }
        throw new FlexlmException(-42, 8043);
    }

    public int[] getDeductionCounts() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            Deduction deduction = ((DetailedFulfillment)this.curFulfillment).getCurDeduction();
            if (deduction != null) {
                int[] nArray = new int[]{deduction.getActivationCount(), deduction.getActivationOverdraftCount(), deduction.getConcurrentCount(), deduction.getConcurrentOverdraftCount(), deduction.getHybridCount(), deduction.getHybridOverdraftCount()};
                return nArray;
            }
            throw new FlexlmException(-42, 8044);
        }
        throw new FlexlmException(-42, 8045);
    }

    public String getDeductionExpirationDate() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            Deduction deduction = ((DetailedFulfillment)this.curFulfillment).getCurDeduction();
            if (deduction != null) {
                return deduction.getExpiration();
            }
            throw new FlexlmException(-42, 8046);
        }
        throw new FlexlmException(-42, 8047);
    }

    public int getDeductionRepairs() throws FlexlmException {
        if (this.curFulfillment != null && this.curFulfillment instanceof DetailedFulfillment) {
            Deduction deduction = ((DetailedFulfillment)this.curFulfillment).getCurDeduction();
            if (deduction != null) {
                return deduction.getRepairs();
            }
            throw new FlexlmException(-42, 8051);
        }
        throw new FlexlmException(-42, 8052);
    }

    public void addFulfillment(Fulfillment fulfillment) throws FlexlmException {
        this.fulfillments.add(fulfillment);
    }

    public void print(PrintStream printStream) throws FlexlmException {
        System.out.println("numFulfills=" + this.getNumFulfillments());
        for (int i = 0; i < this.getNumFulfillments(); ++i) {
            this.selectNthFulfillment(i);
            printStream.println("Fulfillment: " + i);
            printStream.println("version= " + this.getFulfillmentVersion());
            printStream.println("fulfill ID= " + this.getFulfillmentId());
            printStream.println("entitlement ID= " + this.getEntitlementId());
            printStream.println("product ID= " + this.getProductId());
            printStream.println("suite ID= " + this.getSuiteId());
            printStream.println("expiration date= " + this.getExpirationDate());
            printStream.println("orig expire date= " + this.getOriginalExpirationDate());
            printStream.println("fulfill chain= " + this.getFulfillmentChain());
            printStream.println("server chain= " + this.getServerChain());
            printStream.println("hops= " + this.getHops());
            int[] nArray = this.getAvailableCounts();
            printStream.println("activation count= " + nArray[0]);
            printStream.println("concurrent count= " + nArray[2]);
            printStream.println("hybrid count= " + nArray[4]);
            printStream.println("activation OD count= " + nArray[1]);
            printStream.println("concurrent OD count= " + nArray[3]);
            printStream.println("hybrid OD count= " + nArray[5]);
            int[] nArray2 = this.getMaximumCounts();
            printStream.println("max activation count= " + nArray2[0]);
            printStream.println("max concurrent count= " + nArray2[2]);
            printStream.println("max hybrid count= " + nArray2[4]);
            printStream.println("max activation OD count= " + nArray2[1]);
            printStream.println("max concurrent OD count= " + nArray2[3]);
            printStream.println("max hybrid OD count= " + nArray2[5]);
            printStream.println("repairsToServe= " + this.getRepairsToServe());
            printStream.println("max OD duration= " + this.getMaximumOverdraftDuration());
            printStream.println("feature lines= " + this.getFeatureLines());
            printStream.println("numDeductions= " + this.getNumDeductions());
            for (int j = 0; j < this.getNumDeductions(); ++j) {
                printStream.println("Deduction: " + j);
                this.selectNthDeduction(j);
                printStream.println("type= " + this.getDeductionType());
                printStream.println("dest fulfill ID= " + this.getDeductionDestinationFulfillId());
                printStream.println("dest system name= " + this.getDeductionSystemName());
                int[] nArray3 = this.getDeductionCounts();
                printStream.println("deduction activation count= " + nArray3[0]);
                printStream.println("deduction concurrent count= " + nArray3[2]);
                printStream.println("deduction hybrid count= " + nArray3[4]);
                printStream.println("deduction activation OD count= " + nArray3[1]);
                printStream.println("deduction concurrent OD count= " + nArray3[3]);
                printStream.println("deduction hybrid OD count= " + nArray3[5]);
                printStream.println("repairs= " + this.getDeductionRepairs());
            }
        }
    }
}

