/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.asn1;

import com.certicom.ecc.asn1.ECConverter;
import com.certicom.ecc.asn1.Parameters;
import com.certicom.ecc.codec.ECCodec;
import com.trustpoint.asn.AsnException;

public final class ECParamCodec
extends ECCodec {
    public ECParamCodec() {
        super("SECG");
    }

    protected void decode() {
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        Parameters parameters = new Parameters();
        try {
            parameters.decode(byArray, 1);
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot decode curve: " + asnException.getLocalizedMessage());
        }
        Object[] objectArray = ECConverter.toValues(parameters);
        if (objectArray == null || objectArray.length == 1) {
            this.initResult(2);
            this.result[1] = objectArray == null ? "ImplicitlyCA" : objectArray[0];
        } else {
            this.initResult(2 + objectArray.length);
            this.result[1] = "ECParameters";
            int n = 2;
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.result[n] = objectArray[n2];
                ++n;
                ++n2;
            }
        }
        objectArray = null;
    }

    protected void encode() {
        this.initResult(this.outputSize());
        Parameters parameters = ECConverter.toParameters(this.curve);
        try {
            this.result[1] = parameters.encode(2);
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot decode params: " + asnException.getLocalizedMessage());
        }
    }

    protected void initResult(int n) {
        super.initResult(n);
        this.result[0] = "ECParameters";
    }

    public int outputSize() {
        if (this.mode == 1) {
            return super.outputSize() + 1;
        }
        return super.outputSize();
    }
}

