/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.viewers;

import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.policy.ui.Messages;
import com.ibm.cic.licensing.policy.ui.dialogs.ComponentDialog;
import com.ibm.cic.licensing.policy.ui.dialogs.OfferingDialog;
import com.ibm.cic.licensing.policy.ui.dialogs.TableItemEditDialog;
import com.ibm.cic.licensing.policy.ui.viewers.EditableTableViewer;
import com.ibm.cic.licensing.policy.ui.viewers.LicensePolicyViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Version;

public class ComponentMapViewer
extends LicensePolicyViewer {
    protected ComponentOfferingViewer componentOfferingViewer;

    public ComponentMapViewer(Composite parent, EditableTableViewer.IFormAdapter formAdapter) {
        super(parent, formAdapter, 7);
    }

    public ComponentMapViewer(Composite parent) {
        this(parent, null);
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.componentOfferingViewer.setInput(null);
    }

    public void refresh() {
        super.refresh();
        this.componentOfferingViewer.setInput(null);
        this.componentOfferingViewer.refresh();
    }

    protected Control createControl(Composite parent) {
        Composite outerContainer = (Composite)super.createControl(parent);
        this.setReadonlyCheckButtonText(Messages.componentsReadonlyCheckButtonText);
        this.createTable(outerContainer);
        this.componentOfferingViewer = new ComponentOfferingViewer(outerContainer, this);
        this.componentOfferingViewer.setEnabled(false);
        return outerContainer;
    }

    public Object getValue(Object element, String property) {
        LicensePolicyData.ComponentData component = (LicensePolicyData.ComponentData)element;
        if (property.equals(Messages.componentIdColumnTitleText)) {
            return component.getId();
        }
        if (property.equals(Messages.componentVersionColumnTitleText)) {
            return component.getVersion().toString();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        LicensePolicyData.ComponentData component = (LicensePolicyData.ComponentData)item.getData();
        if (property.equals(Messages.componentIdColumnTitleText)) {
            component.setId((String)value);
        } else if (property.equals(Messages.componentVersionColumnTitleText)) {
            component.setVersion(new Version((String)value));
        }
        this.tableViewer.update((Object)component, null);
        this.refresh();
        this.tableViewer.getTable().notifyListeners(13, null);
    }

    protected TableItemEditDialog createNewDialog() {
        return new ComponentDialog(this.getControl().getShell(), Messages.newComponent, null);
    }

    protected TableItemEditDialog createEditDialog(String[] initialValues) {
        return new ComponentDialog(this.getControl().getShell(), Messages.editComponent, initialValues);
    }

    protected Object createNewData(String[] values) {
        LicensePolicyData.ComponentData componentData = new LicensePolicyData.ComponentData(values[0], new Version(values[1]));
        LicensePolicyData.ComponentMapData componentMapData = (LicensePolicyData.ComponentMapData)this.data;
        componentMapData.addComponent(componentData);
        return componentData;
    }

    protected void setDataValues(Object data, String[] values) {
        LicensePolicyData.ComponentData component = (LicensePolicyData.ComponentData)data;
        component.setId(values[0]);
        component.setVersion(new Version(values[1]));
    }

    protected void handleEdit() {
        super.handleEdit();
        this.refresh();
        this.tableViewer.getTable().notifyListeners(13, null);
    }

    protected TableItemEditDialog createOfferingDialog(Shell shell, String title, String[] initialValues) {
        return new OfferingDialog(shell, title, initialValues);
    }

    private void createTable(Composite parent) {
        this.createTable(parent, Messages.componentsLabelText, 10);
        final Table table = this.tableViewer.getTable();
        TableColumn idColumn = new TableColumn(table, 0);
        idColumn.setWidth(0);
        idColumn.setText(Messages.componentIdColumnTitleText);
        TableColumn versionColumn = new TableColumn(table, 0);
        versionColumn.setWidth(this.fontMetrics.getAverageCharWidth() * Math.max(2 * Messages.componentVersionColumnTitleText.length(), 20));
        versionColumn.setText(Messages.componentVersionColumnTitleText);
        this.initializeCellEditors();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditableTableViewer.AbstractTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof LicensePolicyData.ComponentData) {
                    LicensePolicyData.ComponentData componentData = (LicensePolicyData.ComponentData)element;
                    switch (columnIndex) {
                        case 0: {
                            return componentData.getId();
                        }
                        case 1: {
                            return componentData.getVersion().toString();
                        }
                    }
                }
                return null;
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LicensePolicyData.ComponentData d1 = (LicensePolicyData.ComponentData)e1;
                LicensePolicyData.ComponentData d2 = (LicensePolicyData.ComponentData)e2;
                return this.getComparator().compare(d1.toKeyString(), d2.toKeyString());
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = table.getClientArea().width;
                TableColumn nameCol = table.getColumn(0);
                TableColumn versionCol = table.getColumn(1);
                nameCol.setWidth(tableWidth - versionCol.getWidth());
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentMapViewer.this.setComponentViewerInput();
            }
        });
    }

    private void setComponentViewerInput() {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getSelection();
        Object itemData = items.length == 1 ? items[0].getData() : null;
        this.componentOfferingViewer.setInput(itemData);
    }

    protected static class ComponentOfferingViewer
    extends LicensePolicyViewer {
        private final ComponentMapViewer componentMapViewer;

        public ComponentOfferingViewer(Composite parent, ComponentMapViewer componentMapViewer) {
            super(parent, componentMapViewer.formAdapter);
            this.componentMapViewer = componentMapViewer;
        }

        public void setInput(Object input) {
            super.setInput(input);
            this.setEnabled(this.data != null);
        }

        protected Control createControl(Composite parent) {
            Composite outerContainer = (Composite)super.createControl(parent);
            this.createTable(outerContainer);
            return outerContainer;
        }

        protected Button createReadonlyCheckButton(Composite parent) {
            return null;
        }

        public Object getValue(Object element, String property) {
            LicensePolicyData.OfferingData offering = (LicensePolicyData.OfferingData)element;
            if (property.equals(Messages.offeringIdColumnTitleText)) {
                return offering.getId();
            }
            if (property.equals(Messages.offeringVersionColumnTitleText)) {
                return offering.getVersion().toString();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            LicensePolicyData.OfferingData offering = (LicensePolicyData.OfferingData)item.getData();
            if (property.equals(Messages.offeringIdColumnTitleText)) {
                offering.setId((String)value);
            } else if (property.equals(Messages.offeringVersionColumnTitleText)) {
                offering.setVersion(new Version((String)value));
            }
            this.tableViewer.update((Object)offering, null);
        }

        protected TableItemEditDialog createNewDialog() {
            return this.componentMapViewer.createOfferingDialog(this.getControl().getShell(), Messages.newOffering, null);
        }

        protected TableItemEditDialog createEditDialog(String[] initialValues) {
            return this.componentMapViewer.createOfferingDialog(this.getControl().getShell(), Messages.editOffering, initialValues);
        }

        protected Object createNewData(String[] values) {
            LicensePolicyData.OfferingData offeringdata = new LicensePolicyData.OfferingData(values[0], new Version(values[1]), values[2]);
            LicensePolicyData.ComponentData componentData = (LicensePolicyData.ComponentData)this.data;
            componentData.addOffering(offeringdata);
            return offeringdata;
        }

        protected void setDataValues(Object data, String[] values) {
            LicensePolicyData.OfferingData offering = (LicensePolicyData.OfferingData)data;
            offering.setId(values[0]);
            offering.setVersion(new Version(values[1]));
        }

        private void createTable(Composite parent) {
            this.createTable(parent, Messages.offeringsLabelText, 10);
            Table table = this.tableViewer.getTable();
            TableColumn idColumn = new TableColumn(table, 0);
            idColumn.setWidth(0);
            idColumn.setText(Messages.offeringIdColumnTitleText);
            TableColumn versionColumn = new TableColumn(table, 0);
            versionColumn.setWidth(this.fontMetrics.getAverageCharWidth() * Math.max(2 * Messages.offeringVersionColumnTitleText.length(), 20));
            versionColumn.setText(Messages.offeringVersionColumnTitleText);
            this.initializeCellEditors();
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditableTableViewer.AbstractTableLabelProvider(this){
                final /* synthetic */ ComponentOfferingViewer this$1;
                {
                    this.this$1 = componentOfferingViewer;
                }

                public String getColumnText(Object element, int columnIndex) {
                    if (element instanceof LicensePolicyData.OfferingData) {
                        LicensePolicyData.OfferingData offeringData = (LicensePolicyData.OfferingData)element;
                        switch (columnIndex) {
                            case 0: {
                                return offeringData.getId();
                            }
                            case 1: {
                                return offeringData.getVersion().toString();
                            }
                        }
                    }
                    return null;
                }
            });
            table.addControlListener((ControlListener)new ControlAdapter(this, table){
                final /* synthetic */ ComponentOfferingViewer this$1;
                private final /* synthetic */ Table val$table;
                {
                    this.this$1 = componentOfferingViewer;
                    this.val$table = table;
                }

                public void controlResized(ControlEvent e) {
                    int tableWidth = this.val$table.getClientArea().width;
                    TableColumn idCol = this.val$table.getColumn(0);
                    TableColumn versionCol = this.val$table.getColumn(1);
                    idCol.setWidth(tableWidth - versionCol.getWidth());
                }
            });
        }

        public TableViewer getTableViewer() {
            return this.tableViewer;
        }
    }
}

