/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.OptionKey;
import sun.nio.ch.ProviderNet;
import sun.nio.ch.RDMAFdRsocketCache;
import sun.nio.ch.SocketOptionRegistry;

class RDMANet
implements ProviderNet {
    RDMANet() {
    }

    @Override
    public int connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        return RDMANet.connect0(inetAddress, n, RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor));
    }

    @Override
    public void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        RDMANet.bind0(inetAddress, n, RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor));
    }

    @Override
    public void listen(FileDescriptor fileDescriptor, int n) throws IOException {
        RDMANet.listen(n, RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor));
    }

    @Override
    public void shutdown(FileDescriptor fileDescriptor, int n) throws IOException {
        RDMANet.shutdown(fileDescriptor, n, RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor));
    }

    @Override
    public void setSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption, Object object) throws IOException {
        Net.setSocketOption(fileDescriptor, protocolFamily, socketOption, object);
        if (socketOption == StandardSocketOptions.SO_RCVBUF || socketOption == StandardSocketOptions.SO_SNDBUF || socketOption == StandardSocketOptions.SO_REUSEADDR || socketOption == StandardSocketOptions.SO_LINGER || socketOption == StandardSocketOptions.SO_KEEPALIVE || socketOption == ExtendedSocketOption.SO_OOBINLINE) {
            boolean bl;
            int n;
            Class<?> clazz = socketOption.type();
            OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, protocolFamily);
            if (socketOption == StandardSocketOptions.SO_LINGER) {
                n = (Integer)object;
                if (n < 0) {
                    object = -1;
                }
                if (n > 65535) {
                    object = 65535;
                }
            }
            n = clazz == Integer.class ? (Integer)object : ((bl = ((Boolean)object).booleanValue()) ? 1 : 0);
            RDMANet.setIntOption0(optionKey.level(), optionKey.name(), n, RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor));
        }
    }

    @Override
    public Object getSocketOption(FileDescriptor fileDescriptor, ProtocolFamily protocolFamily, SocketOption<?> socketOption) throws IOException {
        if (socketOption == StandardSocketOptions.SO_RCVBUF || socketOption == StandardSocketOptions.SO_SNDBUF || socketOption == StandardSocketOptions.SO_REUSEADDR || socketOption == StandardSocketOptions.SO_LINGER || socketOption == StandardSocketOptions.SO_KEEPALIVE || socketOption == ExtendedSocketOption.SO_OOBINLINE) {
            Class<?> clazz = socketOption.type();
            OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, protocolFamily);
            int n = RDMANet.getIntOption0(optionKey.level(), optionKey.name(), RDMAFdRsocketCache.getMatchingRsocket(fileDescriptor));
            if (clazz == Integer.class) {
                return n;
            }
            return n == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return Net.getSocketOption(fileDescriptor, protocolFamily, socketOption);
    }

    static native int connect0(InetAddress var0, int var1, long var2) throws IOException;

    static native void bind0(InetAddress var0, int var1, long var2) throws IOException;

    static native void close0(long var0) throws IOException;

    static native void listen(int var0, long var1) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1, long var2) throws IOException;

    static native int getIntOption0(int var0, int var1, long var2) throws IOException;

    static native void setIntOption0(int var0, int var1, int var2, long var3) throws IOException;
}

