/*
 * Decompiled with CFR 0.152.
 */
package sun.instrument;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import sun.instrument.TransformerManager;

public class InstrumentationImpl
implements Instrumentation {
    private final TransformerManager mTransformerManager = new TransformerManager(false);
    private TransformerManager mRetransfomableTransformerManager = null;
    private final long mNativeAgent;
    private final boolean mEnvironmentSupportsRedefineClasses;
    private volatile boolean mEnvironmentSupportsRetransformClassesKnown;
    private volatile boolean mEnvironmentSupportsRetransformClasses;
    private final boolean mEnvironmentSupportsNativeMethodPrefix;

    private InstrumentationImpl(long l, boolean bl, boolean bl2) {
        this.mNativeAgent = l;
        this.mEnvironmentSupportsRedefineClasses = bl;
        this.mEnvironmentSupportsRetransformClassesKnown = false;
        this.mEnvironmentSupportsRetransformClasses = false;
        this.mEnvironmentSupportsNativeMethodPrefix = bl2;
    }

    @Override
    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.addTransformer(classFileTransformer, false);
    }

    @Override
    public synchronized void addTransformer(ClassFileTransformer classFileTransformer, boolean bl) {
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in addTransformer");
        }
        if (bl) {
            if (!this.isRetransformClassesSupported()) {
                throw new UnsupportedOperationException("adding retransformable transformers is not supported in this environment");
            }
            if (this.mRetransfomableTransformerManager == null) {
                this.mRetransfomableTransformerManager = new TransformerManager(true);
            }
            this.mRetransfomableTransformerManager.addTransformer(classFileTransformer);
            if (this.mRetransfomableTransformerManager.getTransformerCount() == 1) {
                this.setHasRetransformableTransformers(this.mNativeAgent, true);
            }
        } else {
            this.mTransformerManager.addTransformer(classFileTransformer);
            if (this.mTransformerManager.getTransformerCount() == 1) {
                this.setHasTransformers(this.mNativeAgent, true);
            }
        }
    }

    @Override
    public synchronized boolean removeTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in removeTransformer");
        }
        TransformerManager transformerManager = this.findTransformerManager(classFileTransformer);
        if (transformerManager != null) {
            transformerManager.removeTransformer(classFileTransformer);
            if (transformerManager.getTransformerCount() == 0) {
                if (transformerManager.isRetransformable()) {
                    this.setHasRetransformableTransformers(this.mNativeAgent, false);
                } else {
                    this.setHasTransformers(this.mNativeAgent, false);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isModifiableClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null passed as 'theClass' in isModifiableClass");
        }
        return this.isModifiableClass0(this.mNativeAgent, clazz);
    }

    @Override
    public boolean isRetransformClassesSupported() {
        if (!this.mEnvironmentSupportsRetransformClassesKnown) {
            this.mEnvironmentSupportsRetransformClasses = this.isRetransformClassesSupported0(this.mNativeAgent);
            this.mEnvironmentSupportsRetransformClassesKnown = true;
        }
        return this.mEnvironmentSupportsRetransformClasses;
    }

    @Override
    public void retransformClasses(Class<?>[] classArray) {
        if (!this.isRetransformClassesSupported()) {
            throw new UnsupportedOperationException("retransformClasses is not supported in this environment");
        }
        this.retransformClasses0(this.mNativeAgent, classArray);
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return this.mEnvironmentSupportsRedefineClasses;
    }

    @Override
    public void redefineClasses(ClassDefinition[] classDefinitionArray) throws ClassNotFoundException {
        if (!this.isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("redefineClasses is not supported in this environment");
        }
        if (classDefinitionArray == null) {
            throw new NullPointerException("null passed as 'definitions' in redefineClasses");
        }
        for (int i = 0; i < classDefinitionArray.length; ++i) {
            if (classDefinitionArray[i] != null) continue;
            throw new NullPointerException("element of 'definitions' is null in redefineClasses");
        }
        if (classDefinitionArray.length == 0) {
            return;
        }
        this.redefineClasses0(this.mNativeAgent, classDefinitionArray);
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return this.getAllLoadedClasses0(this.mNativeAgent);
    }

    @Override
    public Class[] getInitiatedClasses(ClassLoader classLoader) {
        return this.getInitiatedClasses0(this.mNativeAgent, classLoader);
    }

    @Override
    public long getObjectSize(Object object) {
        if (object == null) {
            throw new NullPointerException("null passed as 'objectToSize' in getObjectSize");
        }
        return this.getObjectSize0(this.mNativeAgent, object);
    }

    @Override
    public void appendToBootstrapClassLoaderSearch(JarFile jarFile) {
        this.appendToClassLoaderSearch0(this.mNativeAgent, jarFile.getName(), true);
    }

    @Override
    public void appendToSystemClassLoaderSearch(JarFile jarFile) {
        this.appendToClassLoaderSearch0(this.mNativeAgent, jarFile.getName(), false);
    }

    @Override
    public boolean isNativeMethodPrefixSupported() {
        return this.mEnvironmentSupportsNativeMethodPrefix;
    }

    @Override
    public synchronized void setNativeMethodPrefix(ClassFileTransformer classFileTransformer, String string) {
        if (!this.isNativeMethodPrefixSupported()) {
            throw new UnsupportedOperationException("setNativeMethodPrefix is not supported in this environment");
        }
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in setNativeMethodPrefix");
        }
        TransformerManager transformerManager = this.findTransformerManager(classFileTransformer);
        if (transformerManager == null) {
            throw new IllegalArgumentException("transformer not registered in setNativeMethodPrefix");
        }
        transformerManager.setNativeMethodPrefix(classFileTransformer, string);
        String[] stringArray = transformerManager.getNativeMethodPrefixes();
        this.setNativeMethodPrefixes(this.mNativeAgent, stringArray, transformerManager.isRetransformable());
    }

    private TransformerManager findTransformerManager(ClassFileTransformer classFileTransformer) {
        if (this.mTransformerManager.includesTransformer(classFileTransformer)) {
            return this.mTransformerManager;
        }
        if (this.mRetransfomableTransformerManager != null && this.mRetransfomableTransformerManager.includesTransformer(classFileTransformer)) {
            return this.mRetransfomableTransformerManager;
        }
        return null;
    }

    private native boolean isModifiableClass0(long var1, Class<?> var3);

    private native boolean isRetransformClassesSupported0(long var1);

    private native void setHasTransformers(long var1, boolean var3);

    private native void setHasRetransformableTransformers(long var1, boolean var3);

    private native void retransformClasses0(long var1, Class<?>[] var3);

    private native void redefineClasses0(long var1, ClassDefinition[] var3) throws ClassNotFoundException;

    private native Class[] getAllLoadedClasses0(long var1);

    private native Class[] getInitiatedClasses0(long var1, ClassLoader var3);

    private native long getObjectSize0(long var1, Object var3);

    private native void appendToClassLoaderSearch0(long var1, String var3, boolean var4);

    private native void setNativeMethodPrefixes(long var1, String[] var3, boolean var4);

    private static void setAccessible(final AccessibleObject accessibleObject, final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                accessibleObject.setAccessible(bl);
                return null;
            }
        });
    }

    private void loadClassAndStartAgent(String string, String string2, String string3) throws Throwable {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        Method method = null;
        NoSuchMethodException noSuchMethodException = null;
        boolean bl = false;
        try {
            method = clazz.getDeclaredMethod(string2, String.class, Instrumentation.class);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        if (method == null) {
            try {
                method = clazz.getDeclaredMethod(string2, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                // empty catch block
            }
        }
        if (method == null) {
            try {
                method = clazz.getMethod(string2, String.class, Instrumentation.class);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException4) {
                // empty catch block
            }
        }
        if (method == null) {
            try {
                method = clazz.getMethod(string2, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException5) {
                throw noSuchMethodException;
            }
        }
        InstrumentationImpl.setAccessible(method, true);
        if (bl) {
            method.invoke(null, string3, this);
        } else {
            method.invoke(null, string3);
        }
        InstrumentationImpl.setAccessible(method, false);
    }

    private void loadClassAndCallPremain(String string, String string2) throws Throwable {
        this.loadClassAndStartAgent(string, "premain", string2);
    }

    private void loadClassAndCallAgentmain(String string, String string2) throws Throwable {
        this.loadClassAndStartAgent(string, "agentmain", string2);
    }

    private byte[] transform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray, boolean bl) {
        TransformerManager transformerManager;
        TransformerManager transformerManager2 = transformerManager = bl ? this.mRetransfomableTransformerManager : this.mTransformerManager;
        if (transformerManager == null) {
            return null;
        }
        return transformerManager.transform(classLoader, string, clazz, protectionDomain, byArray);
    }

    static {
        System.loadLibrary("instrument");
    }
}

