/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public final class LdapURL
extends Uri {
    private boolean useSsl = false;
    private String DN = null;
    private String attributes = null;
    private String scope = null;
    private String filter = null;
    private String extensions = null;

    public LdapURL(String string) throws NamingException {
        try {
            this.init(string);
            this.useSsl = this.scheme.equalsIgnoreCase("ldaps");
            if (!this.scheme.equalsIgnoreCase("ldap") && !this.useSsl) {
                throw new MalformedURLException("Not an LDAP URL: " + string);
            }
            this.parsePathAndQuery();
        }
        catch (MalformedURLException malformedURLException) {
            NamingException namingException = new NamingException("Cannot parse url: " + string);
            namingException.setRootCause(malformedURLException);
            throw namingException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            NamingException namingException = new NamingException("Cannot parse url: " + string);
            namingException.setRootCause(unsupportedEncodingException);
            throw namingException;
        }
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public String getDN() {
        return this.DN;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public static String[] fromList(String string) throws NamingException {
        String[] stringArray = new String[(string.length() + 1) / 2];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public static boolean hasQueryComponents(String string) {
        return string.lastIndexOf(63) != -1;
    }

    static String toUrlString(String string, int n, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = string != null ? string : "";
            if (string3.indexOf(58) != -1 && string3.charAt(0) != '[') {
                string3 = "[" + string3 + "]";
            }
            String string5 = n != -1 ? ":" + n : "";
            String string6 = string2 != null ? "/" + UrlUtil.encode(string2, "UTF8") : "";
            return bl ? "ldaps://" + string3 + string5 + string6 : "ldap://" + string3 + string5 + string6;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 encoding unavailable");
        }
    }

    private void parsePathAndQuery() throws MalformedURLException, UnsupportedEncodingException {
        int n;
        int n2;
        if (this.path.equals("")) {
            return;
        }
        String string = this.DN = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        if (this.DN.length() > 0) {
            this.DN = URLDecoder.decode(this.DN, "UTF8");
        }
        if (this.query == null) {
            return;
        }
        int n3 = this.query.indexOf(63, 1);
        if (n3 < 0) {
            this.attributes = this.query.substring(1);
            return;
        }
        if (n3 != 1) {
            this.attributes = this.query.substring(1, n3);
        }
        if ((n2 = this.query.indexOf(63, n3 + 1)) < 0) {
            this.scope = this.query.substring(n3 + 1);
            return;
        }
        if (n2 != n3 + 1) {
            this.scope = this.query.substring(n3 + 1, n2);
        }
        if ((n = this.query.indexOf(63, n2 + 1)) < 0) {
            this.filter = this.query.substring(n2 + 1);
        } else {
            if (n != n2 + 1) {
                this.filter = this.query.substring(n2 + 1, n);
            }
            this.extensions = this.query.substring(n + 1);
            if (this.extensions.length() > 0) {
                this.extensions = URLDecoder.decode(this.extensions, "UTF8");
            }
        }
        if (this.filter != null && this.filter.length() > 0) {
            this.filter = URLDecoder.decode(this.filter, "UTF8");
        }
    }
}

