/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

public class InternalSHA {
    private int[] W = new int[80];
    private long count = 0L;
    private final int countmax = 64;
    private final int countmask = 63;
    private int AA;
    private int BB;
    private int CC;
    private int DD;
    private int EE;
    private final int round1_kt = 1518500249;
    private final int round2_kt = 1859775393;
    private final int round3_kt = -1894007588;
    private final int round4_kt = -899497514;

    InternalSHA() {
        this.reset();
    }

    void update(byte by) {
        int n = ((int)this.count & 0x3F) >>> 2;
        int n2 = (~((int)this.count) & 3) << 3;
        this.W[n] = this.W[n] & ~(255 << n2) | (by & 0xFF) << n2;
        if (((int)this.count & 0x3F) == 63) {
            this.computeBlock();
        }
        ++this.count;
    }

    void update(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        while (n2 > 0 && ((int)this.count & 3) != 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 >= 4) {
            int n3 = ((int)this.count & 0x3F) >> 2;
            this.W[n3] = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            this.count += 4L;
            if (((int)this.count & 0x3F) == 0) {
                this.computeBlock();
            }
            n2 -= 4;
            n += 4;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            --n2;
            ++n;
        }
    }

    void reset() {
        this.AA = 1732584193;
        this.BB = -271733879;
        this.CC = -1732584194;
        this.DD = 271733878;
        this.EE = -1009589776;
        for (int i = 0; i < 80; ++i) {
            this.W[i] = 0;
        }
        this.count = 0L;
    }

    byte[] digest() {
        byte[] byArray = new byte[20];
        long l = this.count << 3;
        this.update((byte)-128);
        while ((int)(this.count & 0x3FL) != 56) {
            this.update((byte)0);
        }
        this.W[14] = (int)(l >>> 32);
        this.W[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.count += 8L;
        this.computeBlock();
        byArray[0] = (byte)(this.AA >>> 24);
        byArray[1] = (byte)(this.AA >>> 16);
        byArray[2] = (byte)(this.AA >>> 8);
        byArray[3] = (byte)(this.AA >>> 0);
        byArray[4] = (byte)(this.BB >>> 24);
        byArray[5] = (byte)(this.BB >>> 16);
        byArray[6] = (byte)(this.BB >>> 8);
        byArray[7] = (byte)(this.BB >>> 0);
        byArray[8] = (byte)(this.CC >>> 24);
        byArray[9] = (byte)(this.CC >>> 16);
        byArray[10] = (byte)(this.CC >>> 8);
        byArray[11] = (byte)(this.CC >>> 0);
        byArray[12] = (byte)(this.DD >>> 24);
        byArray[13] = (byte)(this.DD >>> 16);
        byArray[14] = (byte)(this.DD >>> 8);
        byArray[15] = (byte)(this.DD >>> 0);
        byArray[16] = (byte)(this.EE >>> 24);
        byArray[17] = (byte)(this.EE >>> 16);
        byArray[18] = (byte)(this.EE >>> 8);
        byArray[19] = (byte)(this.EE >>> 0);
        this.reset();
        return byArray;
    }

    private void computeBlock() {
        int n;
        int n2;
        for (n2 = 16; n2 <= 79; ++n2) {
            n = this.W[n2 - 3] ^ this.W[n2 - 8] ^ this.W[n2 - 14] ^ this.W[n2 - 16];
            this.W[n2] = n << 1 | n >>> 31;
        }
        int n3 = this.AA;
        int n4 = this.BB;
        int n5 = this.CC;
        int n6 = this.DD;
        int n7 = this.EE;
        for (n2 = 0; n2 < 20; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | ~n4 & n6) + n7 + this.W[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 < 40; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + this.W[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 < 60; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 & n5 | n4 & n6 | n5 & n6) + n7 + this.W[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 < 80; ++n2) {
            n = (n3 << 5 | n3 >>> 27) + (n4 ^ n5 ^ n6) + n7 + this.W[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n3;
            n3 = n;
        }
        this.AA += n3;
        this.BB += n4;
        this.CC += n5;
        this.DD += n6;
        this.EE += n7;
    }
}

