/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ComputedCalls;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class DirectHandle
extends MethodHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    DirectHandle(Class definingClass, String methodName, MethodType type, int kind, Class specialCaller) throws NoSuchMethodException, IllegalAccessException {
        super(DirectHandle.directMethodType(type, kind, specialCaller), definingClass, methodName, kind, null);
        assert (kind != 1 || specialCaller != null);
        this.specialCaller = specialCaller;
        this.defc = this.finishMethodInitialization(specialCaller, type);
    }

    public DirectHandle(Method method, int kind, Class specialCaller) throws IllegalAccessException {
        super(DirectHandle.directMethodType(MethodType.methodType(method.getReturnType(), method.getParameterTypes()), kind, specialCaller), method.getDeclaringClass(), method.getName(), kind, null);
        assert (kind != 1 || specialCaller != null);
        this.specialCaller = specialCaller;
        boolean succeed = DirectHandle.setVMSlotAndRawModifiersFromMethod(this, this.definingClass, method, this.kind, specialCaller);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    DirectHandle(MethodHandle other, int kind) {
        super(other.type, other.definingClass, other.name, kind, null);
        if (!(other instanceof DirectHandle)) {
            throw new IllegalArgumentException();
        }
        this.specialCaller = other.specialCaller;
        this.vmSlot = other.vmSlot;
        this.rawModifiers = other.rawModifiers;
        this.defc = other.defc;
    }

    DirectHandle(DirectHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    private static final MethodType directMethodType(MethodType existingType, int kind, Class specialCaller) {
        if (kind == 0) {
            return existingType;
        }
        return existingType.insertParameterTypes(0, specialCaller);
    }

    final void nullCheckIfRequired(Object receiver) throws NullPointerException {
        if (receiver == null && !Modifier.isStatic(this.rawModifiers)) {
            throw new NullPointerException();
        }
    }

    @Override
    protected ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(int argPlaceholder) {
        ComputedCalls.dispatchJ9Method_V(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        ComputedCalls.dispatchJ9Method_V(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final int invokeExact_thunkArchetype_I(int argPlaceholder) {
        return ComputedCalls.dispatchJ9Method_I(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final int invokeExact_thunkArchetype_I(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        return ComputedCalls.dispatchJ9Method_I(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final long invokeExact_thunkArchetype_J(int argPlaceholder) {
        return ComputedCalls.dispatchJ9Method_J(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final long invokeExact_thunkArchetype_J(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        return ComputedCalls.dispatchJ9Method_J(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final float invokeExact_thunkArchetype_F(int argPlaceholder) {
        return ComputedCalls.dispatchJ9Method_F(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final float invokeExact_thunkArchetype_F(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        return ComputedCalls.dispatchJ9Method_F(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final double invokeExact_thunkArchetype_D(int argPlaceholder) {
        return ComputedCalls.dispatchJ9Method_D(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final double invokeExact_thunkArchetype_D(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        return ComputedCalls.dispatchJ9Method_D(this.vmSlot, receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final Object invokeExact_thunkArchetype_L(int argPlaceholder) {
        return ComputedCalls.dispatchJ9Method_L(this.vmSlot, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final Object invokeExact_thunkArchetype_L(Object receiver, int argPlaceholder) {
        this.nullCheckIfRequired(receiver);
        return ComputedCalls.dispatchJ9Method_L(this.vmSlot, receiver, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new DirectHandle(this, newType);
    }
}

