/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.jvm.j9.dump.indexsupport.IParserNode;
import com.ibm.jvm.j9.dump.indexsupport.NodeAbstract;
import com.ibm.jvm.j9.dump.indexsupport.NodeArrayClass;
import com.ibm.jvm.j9.dump.indexsupport.NodeClassInVM;
import com.ibm.jvm.j9.dump.indexsupport.NodeClassLoader;
import com.ibm.jvm.j9.dump.indexsupport.NodeHeap;
import com.ibm.jvm.j9.dump.indexsupport.NodeJavaVMInitArgs;
import com.ibm.jvm.j9.dump.indexsupport.NodeMonitor;
import com.ibm.jvm.j9.dump.indexsupport.NodeRootClass;
import com.ibm.jvm.j9.dump.indexsupport.NodeRootObject;
import com.ibm.jvm.j9.dump.indexsupport.NodeSystemProperties;
import com.ibm.jvm.j9.dump.indexsupport.NodeTrace;
import com.ibm.jvm.j9.dump.indexsupport.NodeVMThread;
import com.ibm.jvm.j9.dump.indexsupport.XMLIndexReader;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class NodeJavaVM
extends NodeAbstract {
    private JavaRuntime _runtime;

    public NodeJavaVM(XMLIndexReader parent, ImageProcess process, ImageAddressSpace addressSpace, String vmVersion, Attributes attributes) {
        long id = NodeJavaVM._longFromString(attributes.getValue("id"));
        ImagePointer vmPointer = addressSpace.getPointer(id);
        this._runtime = new JavaRuntime(process, vmPointer, vmVersion);
        if (process != null) {
            process.addRuntime(this._runtime);
        }
    }

    public IParserNode nodeToPushAfterStarting(String uri, String localName, String qName, Attributes attributes) {
        IParserNode child = null;
        child = qName.equals("systemProperties") ? new NodeSystemProperties(this._runtime, attributes) : (qName.equals("class") ? new NodeClassInVM(this._runtime, attributes) : (qName.equals("arrayclass") ? new NodeArrayClass(this._runtime, attributes) : (qName.equals("classloader") ? new NodeClassLoader(this._runtime, attributes) : (qName.equals("monitor") ? new NodeMonitor(this._runtime, attributes) : (qName.equals("vmthread") ? new NodeVMThread(this._runtime, attributes) : (qName.equals("trace") ? new NodeTrace(this._runtime, attributes) : (qName.equals("heap") ? new NodeHeap(this._runtime, attributes) : (qName.equals("javavminitargs") ? new NodeJavaVMInitArgs(this._runtime, attributes) : (qName.equals("rootobject") ? new NodeRootObject(this._runtime, attributes) : (qName.equals("rootclass") ? new NodeRootClass(this._runtime, attributes) : super.nodeToPushAfterStarting(uri, localName, qName, attributes)))))))))));
        return child;
    }

    public void didFinishParsing() {
        Iterator classLoaders = this._runtime.getJavaClassLoaders();
        while (classLoaders.hasNext()) {
            Object potentialClassLoader = classLoaders.next();
            if (!(potentialClassLoader instanceof JavaClassLoader)) continue;
            JavaClassLoader loader = (JavaClassLoader)potentialClassLoader;
            try {
                com.ibm.dtfj.java.JavaObject potentialLoaderObject = loader.getObject();
                if (null == potentialLoaderObject || !(potentialLoaderObject instanceof JavaObject)) continue;
                JavaObject loaderObject = (JavaObject)potentialLoaderObject;
                loaderObject.setAssociatedClassLoader(loader);
                this._runtime.addSpecialObject(loaderObject);
                Iterator classes = loader.getDefinedClasses();
                while (classes.hasNext()) {
                    Object potentialClass = classes.next();
                    if (!(potentialClass instanceof JavaClass)) continue;
                    JavaClass theClass = (JavaClass)potentialClass;
                    try {
                        com.ibm.dtfj.java.JavaObject potentialClassObject = theClass.getObject();
                        if (null == potentialClassObject || !(potentialClassObject instanceof JavaObject)) continue;
                        JavaObject classObject = (JavaObject)potentialClassObject;
                        classObject.setAssociatedClass(theClass);
                        this._runtime.addSpecialObject(classObject);
                    }
                    catch (CorruptDataException e) {
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
            catch (CorruptDataException e) {
            }
        }
        Iterator monitors = this._runtime.getMonitors();
        while (monitors.hasNext()) {
            JavaMonitor monitor;
            com.ibm.dtfj.java.JavaObject potentialMonitorObject;
            Object potentialMonitor = monitors.next();
            if (!(potentialMonitor instanceof JavaMonitor) || null == (potentialMonitorObject = (monitor = (JavaMonitor)potentialMonitor).getObject()) || !(potentialMonitorObject instanceof JavaObject)) continue;
            JavaObject monitorObject = (JavaObject)potentialMonitorObject;
            monitorObject.setAssociatedMonitor(monitor);
            this._runtime.addSpecialObject(monitorObject);
        }
        Iterator threads = this._runtime.getThreads();
        while (threads.hasNext()) {
            Object potentialThread = threads.next();
            if (!(potentialThread instanceof JavaThread)) continue;
            JavaThread thread = (JavaThread)potentialThread;
            try {
                com.ibm.dtfj.java.JavaObject potentialThreadObject = thread.getObject();
                if (null == potentialThreadObject || !(potentialThreadObject instanceof JavaObject)) continue;
                JavaObject threadObject = (JavaObject)potentialThreadObject;
                threadObject.setAssociatedThread(thread);
                this._runtime.addSpecialObject(threadObject);
            }
            catch (CorruptDataException e) {}
        }
    }
}

