/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.CompressedFileManager;
import com.ibm.dtfj.utils.file.FileSniffer;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.ZipMemoryCacheImageInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileManager
extends CompressedFileManager {
    public ZipFileManager(File file) {
        super(file);
    }

    @Override
    public List<ManagedImageSource> getImageSources() throws IOException {
        ArrayList<ManagedImageSource> candidates = new ArrayList<ManagedImageSource>();
        ZipFile zip = new ZipFile(this.managedFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory() && !this.identifiedCoreFile(zip, entry, candidates) && !this.identifiedJavaCore(zip, entry, candidates) && !this.identifiedPHD(zip, entry, candidates)) continue;
        }
        zip.close();
        return candidates;
    }

    private boolean identifiedCoreFile(ZipFile zip, ZipEntry entry, ArrayList<ManagedImageSource> candidates) throws IOException {
        if (entry.getSize() < 0x1400000L) {
            return false;
        }
        InputStream stream = zip.getInputStream(entry);
        if (FileSniffer.isCoreFile(stream, entry.getSize())) {
            ManagedImageSource candidate = new ManagedImageSource(entry.getName(), ImageSourceType.CORE);
            candidate.setArchive(this.managedFile);
            logger.finer("Identified core file : " + candidate.toURI());
            ZipEntry metadata = zip.getEntry(entry.getName() + ".xml");
            if (metadata != null) {
                ManagedImageSource meta = new ManagedImageSource(metadata.getName(), ImageSourceType.META);
                meta.setArchive(this.managedFile);
                candidate.setMetadata(meta);
                logger.finer("Identified core file metadata : " + meta.toURI());
            }
            candidates.add(candidate);
            return true;
        }
        return false;
    }

    private boolean identifiedJavaCore(ZipFile zip, ZipEntry entry, ArrayList<ManagedImageSource> candidates) throws IOException {
        InputStream stream = zip.getInputStream(entry);
        if (FileSniffer.isJavaCoreFile(stream, entry.getSize())) {
            ManagedImageSource candidate = new ManagedImageSource(entry.getName(), ImageSourceType.JAVACORE);
            candidate.setArchive(this.managedFile);
            candidates.add(candidate);
            logger.finer("Identified javacore file : " + candidate.toURI());
            return true;
        }
        return false;
    }

    private boolean identifiedPHD(ZipFile zip, ZipEntry entry, ArrayList<ManagedImageSource> candidates) throws IOException {
        InputStream stream = zip.getInputStream(entry);
        if (FileSniffer.isPHDFile(stream, entry.getSize())) {
            String[] jcnames;
            ManagedImageSource candidate = new ManagedImageSource(entry.getName(), ImageSourceType.PHD);
            candidate.setArchive(this.managedFile);
            logger.finer("Identified PHD file : " + candidate.toURI());
            for (String jcname : jcnames = this.getJavaCoreNameFromPHD(entry.getName())) {
                if (zip.getEntry(jcname) == null) continue;
                ManagedImageSource meta = new ManagedImageSource(jcname, ImageSourceType.META);
                meta.setArchive(this.managedFile);
                candidate.setMetadata(meta);
                logger.finer("Identified associated javacore file : " + meta.toURI());
                break;
            }
            candidates.add(candidate);
            return true;
        }
        return false;
    }

    @Override
    public void extract(ManagedImageSource file, File todir) throws IOException {
        this.checkDirectoryToExtractTo(todir);
        File extractTo = this.getExtractLocation(file.getName(), todir);
        ZipFile zip = new ZipFile(this.managedFile);
        ZipEntry entry = zip.getEntry(file.getName());
        this.extractEntry(zip, entry, extractTo);
        file.setExtractedTo(extractTo);
        file.incRefCount();
    }

    private File getExtractLocation(String path, File todir) throws IOException {
        File folder = new File(todir.getCanonicalPath());
        String npath = path.replace('\\', '/');
        if (npath.length() > 2 && npath.charAt(1) == ':') {
            npath = npath.substring(2);
        }
        String[] subdirs = npath.split("/");
        for (int i = 0; i < subdirs.length - 1; ++i) {
            if (subdirs[i].length() <= 0) continue;
            folder = new File(folder, subdirs[i]);
            folder.deleteOnExit();
            folder.mkdir();
        }
        File extractTo = new File(folder, subdirs[subdirs.length - 1]);
        extractTo.deleteOnExit();
        return extractTo;
    }

    private void extractEntry(ZipFile zip, ZipEntry entry, File path) throws IOException {
        InputStream in = zip.getInputStream(entry);
        this.extractEntry(in, path);
    }

    @Override
    public ImageInputStream getStream(ManagedImageSource source) throws IOException {
        ZipFile zip = new ZipFile(source.getArchive());
        ZipEntry entry = zip.getEntry(source.getName());
        InputStream is = zip.getInputStream(entry);
        ZipMemoryCacheImageInputStream iis = new ZipMemoryCacheImageInputStream(entry, is, source);
        return iis;
    }

    @Override
    public void extract(File todir) throws IOException {
        ZipFile zip = new ZipFile(this.managedFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File extractTo = this.getExtractLocation(entry.getName(), todir);
            this.extractEntry(zip, entry, extractTo);
        }
    }
}

