/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.ImageSourceType;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagedImageSource {
    private static final Logger logger = Logger.getLogger("com.ibm.dtfj.log");
    private final String name;
    private String path;
    private int refcount = 0;
    private File archive = null;
    private File extractedTo = null;
    private ManagedImageSource metadata = null;
    private final ImageSourceType type;
    private final UUID uuid = UUID.randomUUID();

    public ManagedImageSource(String name, ImageSourceType type) {
        this.name = name;
        this.type = type;
    }

    public ImageSourceType getType() {
        return this.type;
    }

    public boolean hasMetaData() {
        return this.metadata != null;
    }

    public ManagedImageSource getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ManagedImageSource metadata) {
        this.metadata = metadata;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isCompressed() {
        return this.extractedTo == null;
    }

    public String getName() {
        return this.name;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public File getExtractedTo() {
        return this.extractedTo;
    }

    public void setExtractedTo(File extractedTo) {
        this.extractedTo = extractedTo;
    }

    public int getRefCount() {
        return this.refcount;
    }

    public void incRefCount() {
        ++this.refcount;
    }

    public void decRefCount() {
        if (this.refcount > 0) {
            --this.refcount;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ManagedImageSource)) {
            return false;
        }
        ManagedImageSource compareTo = (ManagedImageSource)obj;
        return this.toURI().equals(compareTo.toURI());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getPathToExtractedFile() {
        return this.extractedTo.getAbsolutePath();
    }

    public URI getURIOfExtractedFile() {
        if (this.extractedTo != null) {
            return this.extractedTo.toURI();
        }
        return null;
    }

    public URI toURI() {
        try {
            StringBuilder uri = new StringBuilder();
            if (this.archive != null) {
                uri.append(this.archive.toURI().toString());
                uri.append("#");
                if (this.path != null) {
                    uri.append(this.path);
                    uri.append("/");
                }
                uri.append(this.name);
                String unsafeURI = uri.toString();
                String safeURI = unsafeURI.replace('\\', '/').replace(" ", "%20");
                return new URI(safeURI);
            }
            if (this.path != null) {
                File loc = null;
                loc = this.path.toLowerCase().endsWith(this.name.toLowerCase()) ? new File(this.path) : new File(this.path, this.name);
                return loc.toURI();
            }
        }
        catch (Exception e) {
            String msg = "Error creating URI for managed image source : " + this.name;
            logger.fine(msg);
            logger.log(Level.FINEST, msg, e);
        }
        try {
            return new URI("file://" + this.uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder data = new StringBuilder(this.toURI().toString());
        data.append(" (");
        data.append(this.type.toString());
        data.append(")");
        return data.toString();
    }
}

