/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageModule;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageProcess
implements ImageProcess {
    private Vector fRuntimes;
    private Vector fImageThreads;
    private Vector fLibraries;
    private Properties fProperties;
    private String fCommandLine;
    private String fID;
    private int fPointerSize;
    private ImageModule fExecutable;
    private int fSignal;
    private long fCurrentThreadID = -1L;
    private final JCImageAddressSpace fImageAddressSpace;
    private static String[] names = new String[]{"ZERO", "SIGHUP", "SIGINT", "SIGQUIT", "SIGILL", "SIGTRAP", "SIGABRT", "SIGEMT", "SIGFPE", "SIGKILL", "SIGBUS", "SIGSEGV", "SIGSYS", "SIGPIPE", "SIGALRM", "SIGTERM", "SIGUSR1", "SIGUSR2", "SIGCHLD", "SIGPWR", "SIGWINCH", "SIGURG/BREAK", "SIGPOLL/ABRT", "SIGSTOP", "SIGTSTP", "SIGCONT", "SIGTTIN", "SIGTTOU", "SIGVTALRM", "SIGPROF", "SIGXCPU", "SIGXFSZ", "SIGWAITING", "SIGLWP", "SIGAIO", "SIGFPE_DIV_BY_ZERO", "SIGFPE_INT_DIV_BY_ZERO", "SIGFPE_INT_OVERFLOW"};

    public JCImageProcess(JCImageAddressSpace imageAddressSpace) throws JCInvalidArgumentsException {
        if (imageAddressSpace == null) {
            throw new JCInvalidArgumentsException("An image process must pertain to an image address space");
        }
        this.fImageAddressSpace = imageAddressSpace;
        this.fRuntimes = new Vector();
        this.fImageThreads = new Vector();
        this.fLibraries = new Vector();
        this.fProperties = new Properties();
        this.fCommandLine = null;
        this.fID = null;
        this.fPointerSize = -1;
        this.fExecutable = null;
        this.fSignal = -1;
        imageAddressSpace.addImageProcess(this);
    }

    public String getCommandLine() throws DataUnavailable, CorruptDataException {
        if (this.fCommandLine == null) {
            throw new DataUnavailable("No command line available");
        }
        return this.fCommandLine;
    }

    public ImageThread getCurrentThread() throws CorruptDataException {
        ImagePointer ip;
        JCImageThread currentThread = null;
        if (this.fCurrentThreadID != -1L && (currentThread = this.getImageThread(ip = this.fImageAddressSpace.getPointer(this.fCurrentThreadID))) == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData("Bad native thread ID", ip));
        }
        return currentThread;
    }

    public void addEnvironment(Object key, Object value) {
        this.fProperties.put(key, value);
    }

    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (this.fProperties == null || this.fProperties.size() == 0) {
            throw new DataUnavailable("Environment data not available");
        }
        return this.fProperties;
    }

    public ImageModule getExecutable() throws DataUnavailable, CorruptDataException {
        if (this.fExecutable == null) {
            throw new DataUnavailable("No executable data");
        }
        return this.fExecutable;
    }

    public String getID() throws DataUnavailable, CorruptDataException {
        if (this.fID == null) {
            throw new DataUnavailable("No process ID available");
        }
        return this.fID;
    }

    public Iterator getLibraries() throws DataUnavailable, CorruptDataException {
        if (this.fLibraries.size() == 0) {
            throw new DataUnavailable("No library information available");
        }
        return this.fLibraries.iterator();
    }

    public void addLibrary(JCImageModule module) {
        if (module != null) {
            this.fLibraries.add(module);
        }
    }

    public ImageModule getLibrary(String name) {
        JCImageModule module = null;
        if (name != null) {
            Iterator it = this.fLibraries.iterator();
            while (module == null && it.hasNext()) {
                String foundID;
                JCImageModule foundModule = (JCImageModule)it.next();
                if (foundModule == null || (foundID = foundModule.getInternalName()) == null || !foundID.equals(name)) continue;
                module = foundModule;
            }
        }
        return module;
    }

    public int getPointerSize() {
        return this.fPointerSize;
    }

    public void setPointerSize(int pointerSize) {
        this.fPointerSize = pointerSize;
    }

    public void setSignal(int signal) {
        this.fSignal = signal;
    }

    public void setCommandLine(String commandLine) {
        this.fCommandLine = commandLine;
    }

    public Iterator getRuntimes() {
        return this.fRuntimes.iterator();
    }

    public void addRuntime(JavaRuntime javaRuntime) {
        if (javaRuntime != null) {
            this.fRuntimes.add(javaRuntime);
        }
    }

    private String resolvePlatformName(int num) {
        if (num >= 0 && num < names.length) {
            return names[num];
        }
        return "Signal." + Integer.toString(num);
    }

    public String getSignalName() throws DataUnavailable, CorruptDataException {
        if (this.fSignal == -1) {
            throw new DataUnavailable("No signal name available");
        }
        if (this.fSignal >= 0 && this.fSignal < names.length) {
            return names[this.fSignal];
        }
        return "Signal." + Integer.toString(this.fSignal);
    }

    public int getSignalNumber() throws DataUnavailable, CorruptDataException {
        if (this.fSignal == -1) {
            throw new DataUnavailable("No signal number available");
        }
        return this.fSignal;
    }

    public Iterator getThreads() {
        return this.fImageThreads.iterator();
    }

    public void addImageThread(JCImageThread thread) {
        if (thread != null) {
            this.fImageThreads.add(thread);
        }
    }

    public JCImageThread getImageThread(ImagePointer id) {
        JCImageThread thread = null;
        if (id != null) {
            Iterator it = this.getThreads();
            while (thread == null && it.hasNext()) {
                ImagePointer foundID;
                JCImageThread foundThread = (JCImageThread)it.next();
                if (foundThread == null || (foundID = foundThread.getInternalID()) == null || !foundID.equals(id)) continue;
                thread = foundThread;
            }
        }
        return thread;
    }

    public JCImageAddressSpace getImageAddressSpace() {
        return this.fImageAddressSpace;
    }

    public void setExecutable(ImageModule execMod) {
        this.fExecutable = execMod;
    }

    public void setID(String pid) {
        this.fID = pid;
    }

    public void setCurrentThreadID(long imageThreadID) {
        if (this.fCurrentThreadID == -1L) {
            this.fCurrentThreadID = imageThreadID;
        }
    }

    public Properties getProperties() {
        return new Properties();
    }
}

