/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.j9.BuilderShutdownHook;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageModule;
import com.ibm.dtfj.image.j9.ImagePointer;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.image.j9.ImageRegister;
import com.ibm.dtfj.image.j9.ImageStackFrame;
import com.ibm.dtfj.image.j9.ImageSymbol;
import com.ibm.dtfj.image.j9.ImageThread;
import com.ibm.dtfj.image.j9.ModuleImageSection;
import com.ibm.dtfj.image.j9.PartialProcess;
import com.ibm.dtfj.image.j9.StackImageSection;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;

public class Builder
implements com.ibm.dtfj.corereaders.Builder {
    private IAbstractAddressSpace _memory;
    private Vector _addressSpaces = new Vector();
    private long _environmentAddress;
    private DataUnavailable _executableException;
    private DataUnavailable _libraryException;
    private String _osType;
    private String _cpuType;
    private String _cpuSubType;
    private long _creationTimeMillis;
    private IFileLocationResolver _resolvingAgent;
    private BuilderShutdownHook _fileTracker = new BuilderShutdownHook();

    public Builder(ICoreFileReader core, ClosingFileReader openCoreFile, long environmentAddress, IFileLocationResolver resolvingAgent) {
        this._memory = core.getAddressSpace();
        this._environmentAddress = environmentAddress;
        this._resolvingAgent = resolvingAgent;
        Runtime.getRuntime().addShutdownHook(this._fileTracker);
        this._fileTracker.addFile(openCoreFile);
    }

    public Builder(ICoreFileReader core, ImageInputStream stream, long environmentAddress, IFileLocationResolver resolvingAgent) {
        this._memory = core.getAddressSpace();
        this._environmentAddress = environmentAddress;
        this._resolvingAgent = resolvingAgent;
    }

    public Object buildProcess(Object addressSpace, String pid, String commandLine, Properties environment, Object currentThread, Iterator threads, Object executable, Iterator libraries, int addressSize) {
        ImageProcess process = null;
        process = null == this._executableException && null == this._libraryException ? new ImageProcess(pid, commandLine, environment, (ImageThread)currentThread, threads, (ImageModule)executable, libraries, addressSize) : new PartialProcess(pid, commandLine, environment, (ImageThread)currentThread, threads, (ImageModule)executable, libraries, addressSize, this._executableException, this._libraryException);
        ImageAddressSpace space = (ImageAddressSpace)addressSpace;
        space.addProcess(process);
        return process;
    }

    public Object buildAddressSpace(String name, int id) {
        ImageAddressSpace space = new ImageAddressSpace(this._memory, id);
        this._addressSpaces.add(space);
        return space;
    }

    public Object buildRegister(String name, Number value) {
        return new ImageRegister(name, value);
    }

    public Object buildStackSection(Object addressSpace, long stackStart, long stackEnd) {
        return new StackImageSection(this.pointer(addressSpace, stackStart), stackEnd - stackStart);
    }

    private ImagePointer pointer(Object addressSpace, long address) {
        return new ImagePointer((ImageAddressSpace)addressSpace, address);
    }

    public Object buildThread(String name, Iterator registers, Iterator stackSections, Iterator stackFrames, Properties properties, int signalNumber) {
        return new ImageThread(name, registers, stackSections, stackFrames, properties, signalNumber);
    }

    public Object buildModuleSection(Object addressSpace, String name, long imageStart, long imageEnd) {
        return new ModuleImageSection(name, this.pointer(addressSpace, imageStart), imageEnd - imageStart);
    }

    public Object buildModule(String name, Properties properties, Iterator sections, Iterator symbols, long loadAddress) {
        return new ImageModule(name, properties, sections, symbols, loadAddress);
    }

    public Iterator getAddressSpaces() {
        return this._addressSpaces.iterator();
    }

    public long getEnvironmentAddress() {
        return this._environmentAddress;
    }

    public long getValueOfNamedRegister(List registers, String string) {
        for (ImageRegister register : registers) {
            if (!register.getName().equals(string)) continue;
            try {
                return register.getValue().longValue();
            }
            catch (CorruptDataException e) {
            }
        }
        return -1L;
    }

    public Object buildStackFrame(Object addressSpace, long stackBasePointer, long pc) {
        ImageAddressSpace space = (ImageAddressSpace)addressSpace;
        return new ImageStackFrame(space, space.getPointer(pc), space.getPointer(stackBasePointer));
    }

    public ClosingFileReader openFile(String filename) throws IOException {
        File foundFile = this._resolvingAgent.findFileWithFullPath(filename);
        ClosingFileReader reader = new ClosingFileReader(foundFile);
        this._fileTracker.addFile(reader);
        return reader;
    }

    public Object buildSymbol(Object addressSpace, String functionName, long relocatedFunctionAddress) {
        return new ImageSymbol(functionName, ((ImageAddressSpace)addressSpace).getPointer(relocatedFunctionAddress));
    }

    public void setExecutableUnavailable(String description) {
        this._libraryException = this._executableException = new DataUnavailable(description);
    }

    public String getOSType() {
        return this._osType;
    }

    public String getCPUType() {
        return this._cpuType;
    }

    public String getCPUSubType() {
        return this._cpuSubType;
    }

    public long getCreationTime() {
        return this._creationTimeMillis;
    }

    public void setOSType(String osType) {
        this._osType = osType;
    }

    public void setCPUType(String cpuType) {
        this._cpuType = cpuType;
    }

    public void setCPUSubType(String subType) {
        this._cpuSubType = subType;
    }

    public void setCreationTime(long millis) {
        this._creationTimeMillis = millis;
    }

    public Object buildCorruptData(Object addressSpace, String message, long address) {
        return new CorruptData(message, this.pointer(addressSpace, address));
    }
}

